/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy.font;

import fr.catcore.translatedlegacy.font.GlyphContainer;
import fr.catcore.translatedlegacy.font.Style;
import fr.catcore.translatedlegacy.font.TextInfo;
import fr.catcore.translatedlegacy.font.api.GameProvider;
import fr.catcore.translatedlegacy.font.api.Glyph;
import fr.catcore.translatedlegacy.font.api.GlyphProvider;
import fr.catcore.translatedlegacy.font.renderable.GlyphRenderer;
import fr.catcore.translatedlegacy.font.renderable.ObfuscatedGlyphRenderer;
import fr.catcore.translatedlegacy.font.renderable.RenderableItem;
import fr.catcore.translatedlegacy.font.renderable.RenderableText;
import fr.catcore.translatedlegacy.font.renderable.SpaceRenderer;
import fr.catcore.translatedlegacy.util.AccessWeightedMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class TextRenderer {
    private static GameProvider game;
    private static final List<GlyphProvider> providers;
    private static final Map<String, List<RenderableItem>> CACHED_TEXT;
    public static final String RANDOM_CHARS_PALLETTE = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    public static final Random fontRandom;

    public static int getSpaceWidth() {
        return 4;
    }

    public static void setGameProvider(GameProvider provider) {
        game = provider;
    }

    public static GameProvider getGameProvider() {
        return game;
    }

    public static void registerProvider(GlyphProvider provider) {
        providers.add(provider);
    }

    private static GlyphProvider getCharRenderer(Character character) {
        for (GlyphProvider provider : providers) {
            if (!provider.provides(character)) continue;
            return provider;
        }
        return null;
    }

    private static List<TextInfo> parseTextInfos(String text) {
        ArrayList<TextInfo> infos = new ArrayList<TextInfo>();
        StringBuilder currentText = new StringBuilder();
        Style currentStyle = null;
        for (int i = 0; i < text.length(); ++i) {
            char character = text.charAt(i);
            if (character == '\u00a7' && text.length() > i + 1) {
                Character modifier = Character.valueOf(text.charAt(i + 1));
                Style newStyle = Style.VANILLA.get(modifier);
                if (newStyle == null) {
                    newStyle = Style.VANILLA.get(Character.valueOf('r'));
                }
                ++i;
                if (currentText.length() > 0) {
                    infos.add(new TextInfo(currentText.toString(), currentStyle));
                    currentText = new StringBuilder();
                }
                if (currentStyle != null) {
                    currentStyle = currentStyle.append(newStyle);
                    continue;
                }
                currentStyle = newStyle;
                continue;
            }
            currentText.append(character);
        }
        if (currentText.length() > 0) {
            infos.add(new TextInfo(currentText.toString(), currentStyle));
        }
        return infos;
    }

    private static List<Glyph> parseGlyphs(String text) {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        for (int i = 0; i < text.length(); ++i) {
            Glyph glyph;
            char character = text.charAt(i);
            GlyphProvider provider = TextRenderer.getCharRenderer(Character.valueOf(character));
            if (provider == null) continue;
            if (!provider.isLoaded()) {
                try {
                    provider.load();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!provider.isLoaded() || (glyph = provider.getGlyph(Character.valueOf(character))) == null) continue;
            glyphs.add(glyph);
        }
        return glyphs;
    }

    private static List<RenderableItem> getTextImage(String text, TextInfo info) {
        ArrayList<RenderableItem> images = new ArrayList<RenderableItem>();
        if (CACHED_TEXT.containsKey(info.getStylePrefix() + text)) {
            return CACHED_TEXT.get(info.getStylePrefix() + text);
        }
        List<Glyph> glyphs = TextRenderer.parseGlyphs(text);
        List items = glyphs.stream().map(glyph -> {
            if (info.style != null && info.style.random != null && info.style.random.booleanValue()) {
                return new ObfuscatedGlyphRenderer((Glyph)glyph);
            }
            return new GlyphRenderer((Glyph)glyph);
        }).collect(Collectors.toList());
        images.addAll(items);
        CACHED_TEXT.put(info.getStylePrefix() + text, items);
        return images;
    }

    private static GlyphContainer getContainer(TextInfo info) {
        ArrayList<RenderableItem> items = new ArrayList<RenderableItem>();
        if (!info.text.contains(" ")) {
            items.addAll(TextRenderer.getTextImage(info.text, info));
        } else {
            String[] texts = info.text.split(" ", -1);
            for (int i = 0; i < texts.length; ++i) {
                String text = texts[i];
                items.addAll(TextRenderer.getTextImage(text, info));
                if (i == texts.length - 1) continue;
                items.add(new SpaceRenderer());
            }
        }
        return new GlyphContainer(items, info.style);
    }

    private static RenderableText getRenderableText(String string) {
        return new RenderableText(TextRenderer.parseTextInfos(string).stream().map(TextRenderer::getContainer).collect(Collectors.toList()));
    }

    public static void reload() {
        CACHED_TEXT.clear();
        providers.forEach(GlyphProvider::unload);
    }

    public static int draw(String string, int x, int y, int color, boolean flag) {
        if (string == null || string.isEmpty()) {
            return 8;
        }
        Style.init();
        RenderableText renderableText = TextRenderer.getRenderableText(string);
        if (flag) {
            int c = color & 0xFF000000;
            color = (color & 0xFCFCFC) >> 2;
            color += c;
        }
        renderableText.render(x, y, color, 0, game, flag);
        if (renderableText.getHeight() > 8) {
            return renderableText.getHeight() - 2;
        }
        return renderableText.getHeight();
    }

    public static int getTextWidth(String string) {
        if (string == null || string.isEmpty()) {
            return 0;
        }
        RenderableText renderableText = TextRenderer.getRenderableText(string);
        return renderableText.getWidth();
    }

    public static int getTextHeight(String string) {
        if (string == null || string.isEmpty()) {
            return 8;
        }
        RenderableText renderableText = TextRenderer.getRenderableText(string);
        int height = renderableText.getHeight();
        return height > 8 ? height - 2 : height;
    }

    public static Glyph getGlyph(char character) {
        GlyphProvider provider = TextRenderer.getCharRenderer(Character.valueOf(character));
        if (provider != null) {
            if (!provider.isLoaded()) {
                try {
                    provider.load();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (provider.isLoaded()) {
                return provider.getGlyph(Character.valueOf(character));
            }
            return null;
        }
        return null;
    }

    public static Glyph getObfuscated(int width, int height) {
        Glyph glyph = TextRenderer.getGlyph((char)RANDOM_CHARS_PALLETTE.indexOf(fontRandom.nextInt(RANDOM_CHARS_PALLETTE.length())));
        while (glyph == null || glyph.getHeight() != height || glyph.getWidth() != width) {
            glyph = TextRenderer.getGlyph((char)RANDOM_CHARS_PALLETTE.indexOf(fontRandom.nextInt(RANDOM_CHARS_PALLETTE.length())));
        }
        return glyph;
    }

    static {
        providers = new ArrayList<GlyphProvider>();
        CACHED_TEXT = new AccessWeightedMap<String, List>(20000, text -> {});
        fontRandom = new Random();
    }
}

