/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy.font.api;

import fr.catcore.translatedlegacy.font.NativeTexture;
import fr.catcore.translatedlegacy.font.api.GameProvider;
import fr.catcore.translatedlegacy.font.api.GlyphProvider;
import fr.catcore.translatedlegacy.util.NativeImage;

public interface Glyph {
    public int getWidth();

    public int getHeight();

    public int getOffset();

    public int getXStart();

    public int getYStart();

    default public void upload(NativeImage from, NativeImage to, int x, int y) {
        this.upload(from, to, x, y, false, false);
    }

    default public void upload(NativeImage from, NativeImage to, int x, int y, boolean flipX, boolean flipY) {
        from.copyRect(to, this.getXStart(), this.getYStart(), x, y, this.getWidth(), this.getHeight(), flipX, flipY);
    }

    default public int getFullWidth() {
        return this.getWidth();
    }

    public GlyphProvider getProvider();

    public Character getChar();

    default public String getId() {
        return this.getProvider().getId() + ":" + this.getChar().charValue();
    }

    default public void draw(GameProvider gameProvider, NativeTexture texture, int x, int y, int width, int height, float blitOffset, boolean italic) {
        texture.bind();
        int textureWidth = texture.getWidth();
        int textureHeight = texture.getHeight();
        float x0 = (float)this.getXStart() / (float)textureWidth;
        float x1 = (float)(this.getXStart() + this.getWidth()) / (float)textureWidth;
        float y0 = (float)this.getYStart() / (float)textureHeight;
        float y1 = (float)(this.getYStart() + this.getHeight()) / (float)textureHeight;
        gameProvider.draw(x, y, width, height, x0, y0, x1, y1, blitOffset, italic);
    }
}

