/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy.font.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.catcore.translatedlegacy.font.NativeTexture;
import fr.catcore.translatedlegacy.font.TextRenderer;
import fr.catcore.translatedlegacy.font.api.GameProvider;
import fr.catcore.translatedlegacy.font.api.Glyph;
import fr.catcore.translatedlegacy.font.api.GlyphProvider;
import fr.catcore.translatedlegacy.font.provider.BitmapGlyph;
import fr.catcore.translatedlegacy.util.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BitmapGlyphProvider
implements GlyphProvider {
    private final Map<Character, Glyph> glyphs = new HashMap<Character, Glyph>();
    private final String texturePath;
    private final int ascent;
    private final int height;
    private final List<int[]> chars = new ArrayList<int[]>();
    private final Set<Character> charSet;
    private NativeTexture fullTexture;

    public BitmapGlyphProvider(JsonObject obj) {
        String path = obj.get("file").getAsString();
        if (path.contains(":")) {
            String[] split = path.split(":");
            path = "/assets/" + split[0] + "/textures/" + split[1];
        }
        this.texturePath = path;
        for (JsonElement element : obj.getAsJsonArray("chars")) {
            int[] is = element.getAsString().codePoints().toArray();
            this.chars.add(is);
        }
        this.ascent = obj.get("ascent").getAsInt();
        this.height = obj.has("height") ? obj.get("height").getAsInt() : 8;
        this.charSet = this.chars.stream().flatMapToInt(Arrays::stream).mapToObj(x -> Character.valueOf((char)x)).filter(x -> x.charValue() != '\u0000').collect(Collectors.toSet());
    }

    @Override
    public boolean provides(Character c) {
        return this.charSet.contains(c);
    }

    @Override
    public Glyph getGlyph(Character c) {
        return this.glyphs.get(c);
    }

    @Override
    public String getId() {
        return this.texturePath;
    }

    @Override
    public List<Glyph> getShowcasedGlyphs() {
        ArrayList<Glyph> showcased = new ArrayList<Glyph>();
        showcased.add(this.getGlyph(Character.valueOf('A')));
        return showcased;
    }

    @Override
    public boolean isLoaded() {
        return this.fullTexture != null;
    }

    @Override
    public void load() throws IOException {
        NativeImage fullImage = NativeImage.read(NativeImage.Format.RGBA, TextRenderer.getGameProvider().getResource(this.texturePath));
        this.fullTexture = new NativeTexture(fullImage);
        int imageWidth = this.fullTexture.getWidth();
        int imageHeight = this.fullTexture.getHeight();
        int columnWidth = imageWidth / this.chars.get(0).length;
        int rowHeight = imageHeight / this.chars.size();
        float scaleFactor = (float)this.height / (float)rowHeight;
        for (int rowIndex = 0; rowIndex < this.chars.size(); ++rowIndex) {
            int[] row = this.chars.get(rowIndex);
            for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                int currentChar = row[columnIndex];
                if (currentChar == 0 || currentChar == 32) continue;
                int startingX = this.findCharacterStartX(fullImage, columnWidth, rowHeight, columnIndex, rowIndex) + 1;
                int x = columnIndex * columnWidth;
                int y = rowIndex * rowHeight;
                int width = (int)(0.5 + (double)((float)startingX * scaleFactor)) + 1;
                this.glyphs.put(Character.valueOf((char)currentChar), new BitmapGlyph(width, this.height, x, y, currentChar, this));
            }
        }
    }

    private int findCharacterStartX(NativeImage image, int characterWidth, int characterHeight, int columnIndex, int rowIndex) {
        int i;
        for (i = characterWidth - 1; i >= 0; --i) {
            int j = columnIndex * characterWidth + i;
            for (int k = 0; k < characterHeight; ++k) {
                int l = rowIndex * characterHeight + k;
                if (image.getPixelOpacity(j, l) == 0) continue;
                return i;
            }
        }
        return i;
    }

    @Override
    public void unload() {
        if (this.fullTexture != null) {
            this.fullTexture.close();
            this.fullTexture = null;
            this.glyphs.clear();
        }
    }

    @Override
    public void draw(Glyph glyph, GameProvider game, int x, int y, int width, int height, float blitOffset, boolean italic) {
        glyph.draw(game, this.fullTexture, x, y, width, height, blitOffset, italic);
    }
}

