/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy.font.provider;

import com.google.gson.JsonObject;
import fr.catcore.translatedlegacy.font.NativeTexture;
import fr.catcore.translatedlegacy.font.TextRenderer;
import fr.catcore.translatedlegacy.font.api.GameProvider;
import fr.catcore.translatedlegacy.font.api.Glyph;
import fr.catcore.translatedlegacy.font.api.GlyphProvider;
import fr.catcore.translatedlegacy.font.provider.LegacyUnicodeGlyph;
import fr.catcore.translatedlegacy.util.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LegacyUnicodeProvider
implements GlyphProvider {
    private final Map<Character, Glyph> glyphs = new HashMap<Character, Glyph>();
    private final Map<Integer, NativeTexture> textures = new HashMap<Integer, NativeTexture>();
    private byte[] CHARS_WIDTH = null;
    private final List<Integer> ignoredBlocks = new ArrayList<Integer>();
    private final String sizesLocation;
    private final String template;

    public LegacyUnicodeProvider(JsonObject object) {
        this.sizesLocation = "/assets/" + object.get("sizes").getAsString().replace(":", "/");
        this.template = "/assets/" + object.get("template").getAsString().replace(":", "/textures/");
    }

    @Override
    public boolean provides(Character c) {
        int blockIndex = c.charValue() / 256;
        if (this.ignoredBlocks.contains(blockIndex)) {
            return false;
        }
        return c.charValue() <= '\u10000';
    }

    @Override
    public Glyph getGlyph(Character c) {
        int blockIndex = c.charValue() / 256;
        if (!this.textures.containsKey(blockIndex)) {
            try {
                this.loadTexture(blockIndex);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.glyphs.get(c);
    }

    @Override
    public String getId() {
        return "minecraft:legacy_unicode";
    }

    @Override
    public List<Glyph> getShowcasedGlyphs() {
        return new ArrayList<Glyph>();
    }

    @Override
    public boolean isLoaded() {
        return this.CHARS_WIDTH != null;
    }

    @Override
    public void load() {
        InputStream inputStream = null;
        try {
            this.CHARS_WIDTH = new byte[65536];
            inputStream = TextRenderer.getGameProvider().getResource(this.sizesLocation);
            inputStream.read(this.CHARS_WIDTH);
        }
        catch (IOException var6) {
            throw new RuntimeException(var6);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void unload() {
        this.CHARS_WIDTH = null;
        this.textures.values().forEach(NativeTexture::close);
        this.textures.clear();
        this.glyphs.clear();
        this.ignoredBlocks.clear();
    }

    @Override
    public float scalingFactor() {
        return 0.5f;
    }

    private void loadTexture(int blockIndex) throws IOException {
        int startIndex = blockIndex * 256;
        String path = String.format(String.format(this.template, "%02x"), blockIndex);
        InputStream inputStream = TextRenderer.getGameProvider().getResource(path);
        if (inputStream == null) {
            System.err.println("Failed to find font texture: " + path);
            this.ignoredBlocks.add(blockIndex);
            return;
        }
        NativeImage nativeImage = NativeImage.read(NativeImage.Format.RGBA, inputStream);
        NativeTexture nativeTexture = new NativeTexture(nativeImage);
        int imageWidth = nativeTexture.getWidth();
        int imageHeight = nativeTexture.getHeight();
        if (imageWidth != 256 || imageHeight != 256) {
            return;
        }
        for (int k = 0; k < 256; ++k) {
            byte width = this.CHARS_WIDTH[startIndex + k];
            if (width == 0 || LegacyUnicodeProvider.getStart(width) <= LegacyUnicodeProvider.getEnd(width)) continue;
            this.CHARS_WIDTH[startIndex + k] = 0;
        }
        int columnWidth = imageWidth / 16;
        int rowHeight = imageHeight / 16;
        for (int rowIndex = 0; rowIndex < 16; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < 16; ++columnIndex) {
                int charIndex = startIndex + rowIndex * 16 + columnIndex;
                int width = this.findCharacterStartX(nativeImage, columnWidth, rowHeight, columnIndex, rowIndex) + 1;
                int x = columnIndex * columnWidth;
                int y = rowIndex * rowHeight;
                this.glyphs.put(Character.valueOf((char)charIndex), new LegacyUnicodeGlyph(this, Character.valueOf((char)charIndex), width, x, y));
            }
        }
        this.textures.put(blockIndex, nativeTexture);
    }

    private int findCharacterStartX(NativeImage image, int characterWidth, int characterHeight, int columnIndex, int rowIndex) {
        int i;
        for (i = characterWidth - 1; i >= 0; --i) {
            int j = columnIndex * characterWidth + i;
            for (int k = 0; k < characterHeight; ++k) {
                int l = rowIndex * characterHeight + k;
                if (image.getPixelOpacity(j, l) == 0) continue;
                return i;
            }
        }
        return i;
    }

    private static int getStart(byte size) {
        return size >> 4 & 0xF;
    }

    private static int getEnd(byte size) {
        return (size & 0xF) + 1;
    }

    @Override
    public void draw(Glyph glyph, GameProvider game, int x, int y, int width, int height, float blitOffset, boolean italic) {
        int blockIndex = glyph.getChar().charValue() / 256;
        glyph.draw(game, this.textures.get(blockIndex), x, y, width, height, blitOffset, italic);
    }
}

