/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class AccessWeightedMap<K, V>
extends HashMap<K, V> {
    private final Map<K, Integer> weights = new HashMap<K, Integer>();
    private final int threshold;
    private final int toKeep;
    private final Consumer<V> removeCallback;

    public AccessWeightedMap(int threshold, Consumer<V> removeCallback) {
        this.threshold = threshold;
        this.toKeep = threshold / 4;
        this.removeCallback = removeCallback;
    }

    @Override
    public V put(K key, V value) {
        if (this.size() >= this.threshold) {
            System.out.println("Cleaning cache of less used values...");
            List sortedList = this.weights.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
            for (int i = 0; i < sortedList.size(); ++i) {
                Object k;
                if (i < this.toKeep || !this.containsKey(k = sortedList.get(i))) continue;
                this.remove(k);
            }
        }
        this.weights.put(key, 0);
        return super.put(key, value);
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (value != null) {
            this.weights.replace(key, this.weights.get(key) + 1);
        }
        return value;
    }

    @Override
    public V remove(Object key) {
        Object value = super.remove(key);
        this.removeCallback.accept(value);
        return value;
    }

    @Override
    public void clear() {
        for (Object value : this.values()) {
            this.removeCallback.accept(value);
        }
        super.clear();
        this.weights.clear();
    }
}

