/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy.util;

import fr.catcore.translatedlegacy.util.NativeImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;

public class GLUtils {
    public static synchronized ByteBuffer allocateByteBuffer(int i) {
        return ByteBuffer.allocateDirect(i).order(ByteOrder.nativeOrder());
    }

    public static int generateTextureId() {
        return GL11.glGenTextures();
    }

    public static void releaseTextureId(int id) {
        GL11.glDeleteTextures((int)id);
    }

    public static void prepareImage(int id, int width, int height) {
        GLUtils.prepareImage(NativeImage.InternalFormat.RGBA, id, 0, width, height);
    }

    public static void prepareImage(NativeImage.InternalFormat internalFormat, int id, int width, int height) {
        GLUtils.prepareImage(internalFormat, id, 0, width, height);
    }

    public static void prepareImage(int id, int maxLevel, int width, int height) {
        GLUtils.prepareImage(NativeImage.InternalFormat.RGBA, id, maxLevel, width, height);
    }

    public static void prepareImage(NativeImage.InternalFormat internalFormat, int id, int maxLevel, int width, int height) {
        GLUtils.bind(id);
        if (maxLevel >= 0) {
            GL11.glTexParameteri((int)3553, (int)33085, (int)maxLevel);
            GL11.glTexParameteri((int)3553, (int)33082, (int)0);
            GL11.glTexParameteri((int)3553, (int)33083, (int)maxLevel);
            GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        }
        for (int i = 0; i <= maxLevel; ++i) {
            GL11.glTexImage2D((int)3553, (int)i, (int)internalFormat.getValue(), (int)(width >> i), (int)(height >> i), (int)0, (int)6408, (int)5121, (IntBuffer)null);
        }
    }

    private static void bind(int id) {
        GL11.glBindTexture((int)3553, (int)id);
    }

    public static void initTexture(IntBuffer imageData, int width, int height) {
        GL11.glPixelStorei((int)3312, (int)0);
        GL11.glPixelStorei((int)3313, (int)0);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3317, (int)4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)imageData);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
    }
}

