/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy.util;

import fr.catcore.translatedlegacy.font.TextRenderer;
import fr.catcore.translatedlegacy.font.api.GameProvider;
import fr.catcore.translatedlegacy.util.GLUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public final class NativeImage
implements AutoCloseable {
    private static final Set<StandardOpenOption> WRITE_TO_FILE_OPEN_OPTIONS = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private final Format format;
    private final int width;
    private final int height;
    private final boolean isStbImage;
    private ByteBuffer buffer;
    private final long sizeBytes;

    static int bufferedToNative(int buffered) {
        if (buffered == 2) {
            return 0;
        }
        if (buffered == 1) {
            return 1;
        }
        return -1;
    }

    static int nativeToBuffered(int nativ) {
        if (nativ == 0) {
            return 2;
        }
        if (nativ == 1) {
            return 1;
        }
        return -1;
    }

    public NativeImage(int width, int height, boolean useStb) {
        this(Format.RGBA, width, height, useStb);
    }

    public NativeImage(Format format, int width, int height, boolean useStb) {
        this.format = format;
        this.width = width;
        this.height = height;
        this.sizeBytes = (long)width * (long)height * (long)format.getChannelCount();
        this.isStbImage = false;
        this.buffer = GLUtils.allocateByteBuffer((int)this.sizeBytes);
    }

    private NativeImage(Format format, int width, int height, boolean useStb, ByteBuffer buffer) {
        this.format = format;
        this.width = width;
        this.height = height;
        this.isStbImage = useStb;
        this.buffer = buffer;
        this.sizeBytes = (long)width * (long)height * (long)format.getChannelCount();
    }

    public String toString() {
        return "SimpleNativeImage[" + (Object)((Object)this.format) + " " + this.width + "x" + this.height + "@" + (this.isStbImage ? "S" : "N") + "]";
    }

    public static NativeImage read(InputStream inputStream) throws IOException {
        return NativeImage.read(Format.RGBA, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeImage read(@Nullable Format format, InputStream inputStream) throws IOException {
        try {
            BufferedImage image = ImageIO.read(inputStream);
            format = format == null ? Format.ALL[NativeImage.bufferedToNative(image.getType())] : format;
            NativeImage nativeImage = new NativeImage(format, image.getWidth(), image.getHeight(), true, NativeImage.read(format, image));
            return nativeImage;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static NativeImage read(ByteBuffer byteBuffer) throws IOException {
        return NativeImage.read(Format.RGBA, byteBuffer);
    }

    public static NativeImage read(@Nullable Format format, ByteBuffer byteBuffer) throws IOException {
        byte[] imageBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(imageBytes);
        ByteArrayInputStream imageStream = new ByteArrayInputStream(imageBytes);
        BufferedImage image = ImageIO.read(imageStream);
        imageStream.close();
        format = format == null ? Format.ALL[NativeImage.bufferedToNative(image.getType())] : format;
        return new NativeImage(format, image.getWidth(), image.getHeight(), true, NativeImage.read(format, image));
    }

    private static ByteBuffer read(@NotNull Format format, BufferedImage image) {
        int sizeBytes = image.getWidth() * image.getHeight() * format.getChannelCount();
        int[] ints = new int[sizeBytes / format.getChannelCount()];
        byte[] bytes = new byte[sizeBytes];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), ints, 0, image.getWidth());
        for (int var7 = 0; var7 < ints.length; ++var7) {
            int var8 = ints[var7] >> 24 & 0xFF;
            int var9 = ints[var7] >> 16 & 0xFF;
            int var10 = ints[var7] >> 8 & 0xFF;
            int var11 = ints[var7] & 0xFF;
            GameProvider gameProvider = TextRenderer.getGameProvider();
            if (gameProvider != null && gameProvider.anaglyph3d()) {
                int var12 = (var9 * 30 + var10 * 59 + var11 * 11) / 100;
                int var13 = (var9 * 30 + var10 * 70) / 100;
                int var14 = (var9 * 30 + var11 * 70) / 100;
                var9 = var12;
                var10 = var13;
                var11 = var14;
            }
            bytes[var7 * 4] = (byte)var9;
            bytes[var7 * 4 + 1] = (byte)var10;
            bytes[var7 * 4 + 2] = (byte)var11;
            bytes[var7 * 4 + 3] = (byte)var8;
        }
        ByteBuffer directBuffer = GLUtils.allocateByteBuffer(sizeBytes);
        directBuffer.put(bytes);
        directBuffer.position(0);
        return directBuffer;
    }

    private static void setTextureClamp(boolean clamp) {
        if (clamp) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
    }

    private static void setTextureFilter(boolean blur, boolean mipmap) {
        if (blur) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)(mipmap ? 9987 : 9729));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)(mipmap ? 9986 : 9728));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }

    private void checkAllocated() {
        if (this.buffer == null) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.buffer = null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Format getFormat() {
        return this.format;
    }

    public int getColor(int x, int y) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.format}));
        }
        if (x <= this.width && y <= this.height) {
            this.checkAllocated();
            int l = (x + y * this.width) * 4;
            return this.buffer.getInt(l);
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.width, this.height));
    }

    public void setColor(int x, int y, int color) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.format}));
        }
        if (x > this.width || y > this.height) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.width, this.height));
        }
        this.checkAllocated();
        int l = (x + y * this.width) * 4;
        this.buffer.putInt(l, color);
    }

    public NativeImage apply(IntUnaryOperator operator) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "function application only works on RGBA images; have %s", new Object[]{this.format}));
        }
        this.checkAllocated();
        NativeImage NativeImage2 = new NativeImage(this.width, this.height, false);
        for (int j = 0; j < this.width * this.height; ++j) {
            this.buffer.putInt(j, operator.applyAsInt(this.buffer.getInt(j)));
        }
        return NativeImage2;
    }

    public byte getPixelOpacity(int x, int y) {
        if (!this.format.hasOpacityChannel()) {
            throw new IllegalArgumentException(String.format("no luminance or alpha in %s", new Object[]{this.format}));
        }
        if (x <= this.width && y <= this.height) {
            int i = (x + y * this.width) * this.format.getChannelCount() + this.format.getOpacityOffset() / 8;
            return this.buffer.get(i);
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.width, this.height));
    }

    public int[] makePixelArray() {
        if (this.format != Format.RGBA) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        this.checkAllocated();
        int[] is = new int[this.getWidth() * this.getHeight()];
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                is[j + i * this.getWidth()] = this.getColor(j, i);
            }
        }
        return is;
    }

    public void upload(int level, int offsetX, int offsetY, boolean close) {
        this.upload(level, offsetX, offsetY, 0, 0, this.width, this.height, false, close);
    }

    public void upload(int level, int offsetX, int offsetY, int unpackSkipPixels, int unpackSkipRows, int width, int height, boolean mipmap, boolean close) {
        this.upload(level, offsetX, offsetY, unpackSkipPixels, unpackSkipRows, width, height, false, false, mipmap, close);
    }

    public void upload(int level, int offsetX, int offsetY, int unpackSkipPixels, int unpackSkipRows, int width, int height, boolean blur, boolean clamp, boolean mipmap, boolean close) {
        this.uploadInternal(level, offsetX, offsetY, unpackSkipPixels, unpackSkipRows, width, height, blur, clamp, mipmap, close);
    }

    private void uploadInternal(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int width, int height, boolean blur, boolean clamp, boolean mipmap, boolean close) {
        this.checkAllocated();
        NativeImage.setTextureFilter(blur, mipmap);
        NativeImage.setTextureClamp(clamp);
        if (width == this.getWidth()) {
            GL11.glPixelStorei((int)3314, (int)0);
        } else {
            GL11.glPixelStorei((int)3314, (int)this.getWidth());
        }
        GL11.glPixelStorei((int)3316, (int)unpackSkipPixels);
        GL11.glPixelStorei((int)3315, (int)unpackSkipRows);
        this.format.setUnpackAlignment();
        GL11.glTexSubImage2D((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)this.format.getPixelDataFormat(), (int)5121, (ByteBuffer)this.buffer);
        if (close) {
            this.close();
        }
    }

    public void loadFromTextureImage(int level, boolean removeAlpha) {
        this.checkAllocated();
        this.format.setPackAlignment();
        GL11.glGetTexImage((int)3553, (int)level, (int)this.format.getPixelDataFormat(), (int)5121, (ByteBuffer)this.buffer);
        if (removeAlpha && this.format.hasAlphaChannel()) {
            for (int i = 0; i < this.getHeight(); ++i) {
                for (int j = 0; j < this.getWidth(); ++j) {
                    this.setColor(j, i, this.getColor(j, i) | 255 << this.format.getAlphaChannelOffset());
                }
            }
        }
    }

    public void writeTo(Path path) throws IOException {
        if (!this.format.isWriteable()) {
            throw new UnsupportedOperationException("Don't know how to write format " + (Object)((Object)this.format));
        }
        this.checkAllocated();
        try (SeekableByteChannel writableByteChannel = Files.newByteChannel(path, WRITE_TO_FILE_OPEN_OPTIONS, new FileAttribute[0]);){
            if (!this.write(writableByteChannel)) {
                throw new IOException("Could not write image to the PNG file \"" + path.toAbsolutePath() + "\"");
            }
        }
    }

    private boolean write(WritableByteChannel channel) throws IOException {
        channel.write(this.buffer);
        return true;
    }

    public void fillRect(int x, int y, int width, int height, int color) {
        for (int i = y; i < y + height; ++i) {
            for (int j = x; j < x + width; ++j) {
                this.setColor(j, i, color);
            }
        }
    }

    public void copyRect(int x, int y, int translateX, int translateY, int width, int height, boolean flipX, boolean flipY) {
        this.copyRect(this, x, y, x + translateX, y + translateY, width, height, flipX, flipY);
    }

    public void copyRect(NativeImage image, int x, int y, int destX, int destY, int width, int height, boolean flipX, boolean flipY) {
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int k = flipX ? width - 1 - j : j;
                int l = flipY ? height - 1 - i : i;
                int m = this.getColor(x + j, y + i);
                image.setColor(destX + k, destY + l, m);
            }
        }
    }

    public void untrack() {
    }

    public static NativeImage read(String dataUri) throws IOException {
        byte[] bs = Base64.getDecoder().decode(dataUri.replaceAll("\n", "").getBytes(StandardCharsets.UTF_8));
        ByteBuffer byteBuffer = GLUtils.allocateByteBuffer(bs.length);
        byteBuffer.put(bs);
        byteBuffer.rewind();
        return NativeImage.read(byteBuffer);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Format {
        RGBA(4, 6408, true, true, true, false, true, 0, 8, 16, 255, 24, true),
        BGR(3, 6407, true, true, true, false, false, 0, 8, 16, 255, 255, true),
        LUMINANCE_ALPHA(2, 6410, false, false, false, true, true, 255, 255, 255, 0, 8, true),
        LUMINANCE(1, 6409, false, false, false, true, false, 0, 0, 0, 0, 255, true);

        private static final Format[] ALL;
        private final int channelCount;
        private final int pixelDataFormat;
        private final boolean hasRed;
        private final boolean hasGreen;
        private final boolean hasBlue;
        private final boolean hasLuminance;
        private final boolean hasAlpha;
        private final int redOffset;
        private final int greenOffset;
        private final int blueOffset;
        private final int luminanceChannelOffset;
        private final int alphaChannelOffset;
        private final boolean writeable;

        private Format(int channels, int glFormat, boolean hasRed, boolean hasGreen, boolean hasBlue, boolean hasLuminance, boolean hasAlpha, int redOffset, int greenOffset, int blueOffset, int luminanceOffset, int alphaOffset, boolean writeable) {
            this.channelCount = channels;
            this.pixelDataFormat = glFormat;
            this.hasRed = hasRed;
            this.hasGreen = hasGreen;
            this.hasBlue = hasBlue;
            this.hasLuminance = hasLuminance;
            this.hasAlpha = hasAlpha;
            this.redOffset = redOffset;
            this.greenOffset = greenOffset;
            this.blueOffset = blueOffset;
            this.luminanceChannelOffset = luminanceOffset;
            this.alphaChannelOffset = alphaOffset;
            this.writeable = writeable;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public void setPackAlignment() {
            GL11.glPixelStorei((int)3333, (int)this.getChannelCount());
        }

        public void setUnpackAlignment() {
            GL11.glPixelStorei((int)3317, (int)this.getChannelCount());
        }

        public int getPixelDataFormat() {
            return this.pixelDataFormat;
        }

        public boolean hasAlphaChannel() {
            return this.hasAlpha;
        }

        public int getAlphaChannelOffset() {
            return this.alphaChannelOffset;
        }

        public boolean hasOpacityChannel() {
            return this.hasLuminance || this.hasAlpha;
        }

        public int getOpacityOffset() {
            return this.hasLuminance ? this.luminanceChannelOffset : this.alphaChannelOffset;
        }

        public boolean isWriteable() {
            return this.writeable;
        }

        private static Format getFormat(int glFormat) {
            if (glFormat == 1) {
                return LUMINANCE;
            }
            if (glFormat == 2) {
                return LUMINANCE_ALPHA;
            }
            if (glFormat == 3) {
                return BGR;
            }
            return RGBA;
        }

        static {
            ALL = Format.values();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum InternalFormat {
        RGBA(6408),
        RGB(6407),
        RG(33319),
        RED(6403);

        private final int value;

        private InternalFormat(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

