/*
 * Decompiled with CFR 0.152.
 */
package dev.celestialfault.toggletogglesprint.config;

import com.google.gson.JsonObject;
import dev.celestialfault.toggletogglesprint.ToggleToggleSprint;
import dev.celestialfault.toggletogglesprint.config.ActivateKey;
import org.jetbrains.annotations.NotNull;

public class ConfigUtils {
    private ConfigUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean getBoolean(JsonObject data, String key, boolean defaultValue) {
        return data.has(key) ? data.get(key).getAsBoolean() : defaultValue;
    }

    @NotNull
    public static JsonObject getObject(JsonObject data, String key) {
        return data.has(key) ? data.get(key).getAsJsonObject() : new JsonObject();
    }

    public static int getInt(JsonObject data, String key, int defaultValue) {
        return data.has(key) ? data.get(key).getAsInt() : defaultValue;
    }

    @NotNull
    public static <T extends Enum<T>> T getEnum(JsonObject data, String key, @NotNull T defaultValue) {
        Enum[] entries = (Enum[])defaultValue.getClass().getEnumConstants();
        if (data.has(key)) {
            String value = data.get(key).getAsString();
            for (Enum entry : entries) {
                if (!entry.name().equalsIgnoreCase(value)) continue;
                return (T)entry;
            }
            ToggleToggleSprint.LOGGER.warn("Value {} is invalid; defaulting to {}", (Object)data.get(key).getAsString(), defaultValue);
        }
        return defaultValue;
    }

    public static ActivateKey convertToActivationState(boolean emulateKeyPress, boolean emulateOnRepress) {
        if (emulateKeyPress && emulateOnRepress) {
            return ActivateKey.ALWAYS;
        }
        if (emulateKeyPress) {
            return ActivateKey.WHEN_UNTOGGLED;
        }
        return ActivateKey.NEVER;
    }
}

