/*
 * Decompiled with CFR 0.152.
 */
package dev.celestialfault.toggletogglesprint;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import dev.celestialfault.toggletogglesprint.ToggleToggleSprint;
import dev.celestialfault.toggletogglesprint.config.ActivateKey;
import dev.celestialfault.toggletogglesprint.config.ConfigUtils;
import dev.celestialfault.toggletogglesprint.config.KeyState;
import dev.celestialfault.toggletogglesprint.config.ToggleState;
import dev.celestialfault.toggletogglesprint.config.Value;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("toggle-toggle-sprint.json");
    private static final TypeAdapter<JsonObject> ADAPTER = new Gson().getAdapter(JsonObject.class);
    private static final int VERSION = 2;
    public static final Value<Boolean> keepSprintingOnDeath = new Value<Boolean>(true);
    public static final KeyState sprint = new KeyState(true, ToggleState.UNCHANGED, ActivateKey.ALWAYS);
    public static final KeyState sneak = new KeyState(false, ToggleState.UNCHANGED, ActivateKey.WHEN_UNTOGGLED);

    static void load() {
        File configFile = PATH.toFile();
        if (!configFile.exists()) {
            Config.save();
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject data = (JsonObject)ADAPTER.fromJson((Reader)reader);
            int version = ConfigUtils.getInt(data, "version", 1);
            keepSprintingOnDeath.set(ConfigUtils.getBoolean(data, "keepSprintingOnDeath", true));
            if (version == 1) {
                Config.loadV1Config(data);
            } else {
                sprint.apply(ConfigUtils.getObject(data, "sprint"));
                sneak.apply(ConfigUtils.getObject(data, "sneak"));
            }
        }
        catch (Exception e) {
            ToggleToggleSprint.LOGGER.error("Failed to load config", (Throwable)e);
        }
    }

    private static void loadV1Config(JsonObject data) {
        Config.sprint.onJoin.set(ConfigUtils.getBoolean(data, "sprintOnJoin", true));
        Config.sprint.defaultState.set(ConfigUtils.getEnum(data, "defaultSprintState", ToggleState.UNCHANGED));
        boolean alsoStartSprinting = ConfigUtils.getBoolean(data, "alsoStartSprinting", true);
        boolean simulateSprintOnRepress = ConfigUtils.getBoolean(data, "simulateSprintOnRepress", true);
        Config.sprint.activateKey.set(ConfigUtils.convertToActivationState(alsoStartSprinting, simulateSprintOnRepress));
        Config.sneak.onJoin.set(ConfigUtils.getBoolean(data, "sneakOnJoin", false));
        Config.sneak.defaultState.set(ConfigUtils.getEnum(data, "defaultSneakState", ToggleState.UNCHANGED));
        boolean alsoStartSneaking = ConfigUtils.getBoolean(data, "alsoStartSneaking", true);
        boolean simulateSneakOnRepress = ConfigUtils.getBoolean(data, "simulateSneakOnRepress", false);
        Config.sneak.activateKey.set(ConfigUtils.convertToActivationState(alsoStartSneaking, simulateSneakOnRepress));
    }

    static void save() {
        File configFile = PATH.toFile();
        try (FileWriter writer = new FileWriter(configFile);
             JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            jsonWriter.setIndent("  ");
            JsonObject object = new JsonObject();
            object.addProperty("version", (Number)2);
            object.addProperty("keepSprintingOnDeath", keepSprintingOnDeath.get());
            object.add("sprint", (JsonElement)sprint.encode());
            object.add("sneak", (JsonElement)sneak.encode());
            ADAPTER.write(jsonWriter, (Object)object);
        }
        catch (IOException e) {
            ToggleToggleSprint.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }
}

