/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block.data;

import java.net.URI;
import java.util.LinkedList;
import java.util.UUID;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.data.types.AudioPosition;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.DisplayScreen;
import me.srrapero720.waterframes.common.screens.PlayListScreen;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector2f;

public class DisplayData {
    public static final String URL = "url";
    public static final String URI_LIST = "uri_list";
    public static final String URI_INDEX = "uri_index";
    public static final String PLAYER_UUID = "player_uuid";
    public static final String ACTIVE = "active";
    public static final String MIN_X = "min_x";
    public static final String MIN_Y = "min_y";
    public static final String MAX_X = "max_x";
    public static final String MAX_Y = "max_y";
    public static final String FLIP_X = "flip_x";
    public static final String FLIP_Y = "flip_y";
    public static final String ROTATION = "rotation";
    public static final String ALPHA = "alpha";
    public static final String BRIGHTNESS = "brightness";
    public static final String RENDER_DISTANCE = "render_distance";
    public static final String VOLUME = "volume";
    public static final String VOL_RANGE_MIN = "volume_min_range";
    public static final String VOL_RANGE_MAX = "volume_max_range";
    public static final String LOOP = "loop";
    public static final String PAUSED = "paused";
    public static final String MUTED = "muted";
    public static final String TICK = "tick";
    public static final String TIME = "time_ms";
    public static final String TICK_MAX = "tick_max";
    public static final String LIT = "lit";
    public static final String DATA_V = "data_v";
    public static final String RENDER_BOTH_SIDES = "render_both";
    public static final String PROJECTION_DISTANCE = "projection_distance";
    public static final String AUDIO_OFFSET = "audio_offset";
    public static final short V = 2;
    public URI uri = null;
    public LinkedList<URI> uris = new LinkedList();
    public int uri_index;
    public UUID uuid = Util.f_137441_;
    public boolean active = true;
    public Vector2f min = new Vector2f(0.0f, 0.0f);
    public Vector2f max = new Vector2f(1.0f, 1.0f);
    public boolean flipX = false;
    public boolean flipY = false;
    public float rotation = 0.0f;
    public int alpha = 255;
    public int brightness = 255;
    public int renderDistance = DisplaysConfig.maxRenDis(32);
    public int volume = DisplaysConfig.maxVol();
    public int maxVolumeDistance = DisplaysConfig.maxVolDis(20);
    public int minVolumeDistance = Math.min(5, this.maxVolumeDistance);
    public boolean loop = true;
    public boolean paused = false;
    public boolean muted = false;
    public boolean lit = true;
    public int tick = 0;
    public int tickMax = -1;
    public boolean renderBothSides = false;
    public float projectionDistance = DisplaysConfig.maxProjDis(8.0f);
    public float audioOffset = 0.0f;

    public boolean nextUri() {
        if (this.uris.isEmpty()) {
            return false;
        }
        ++this.uri_index;
        if (this.uri_index >= this.uris.size()) {
            this.uri_index = 0;
        }
        this.uri = this.uris.get(this.uri_index);
        this.tick = 0;
        this.tickMax = -1;
        return true;
    }

    public boolean prevUri() {
        if (this.uris.isEmpty()) {
            return false;
        }
        --this.uri_index;
        if (this.uri_index < 0) {
            this.uri_index = this.uris.size() - 1;
        }
        this.uri = this.uris.get(this.uri_index);
        this.tick = 0;
        this.tickMax = -1;
        return true;
    }

    public boolean hasUri() {
        return this.uri != null || !this.uris.isEmpty();
    }

    public URI getUri() {
        return this.uris.isEmpty() ? this.uri : this.uris.get(this.uri_index);
    }

    public PositionHorizontal getPosX() {
        return this.min.x == 0.0f ? PositionHorizontal.LEFT : (this.max.x == 1.0f ? PositionHorizontal.RIGHT : PositionHorizontal.CENTER);
    }

    public PositionVertical getPosY() {
        return this.min.y == 0.0f ? PositionVertical.TOP : (this.max.y == 1.0f ? PositionVertical.BOTTOM : PositionVertical.CENTER);
    }

    public float getWidth() {
        return this.max.x - this.min.x;
    }

    public float getHeight() {
        return this.max.y - this.min.y;
    }

    public void save(CompoundTag nbt, DisplayTile tile) {
        nbt.m_128359_(URL, !this.hasUri() ? "" : this.getUri().toString());
        nbt.m_128359_(URI_LIST, WaterFrames.composeURIString(this.uris));
        nbt.m_128405_(URI_INDEX, this.uri_index);
        nbt.m_128362_(PLAYER_UUID, this.uuid);
        nbt.m_128379_(ACTIVE, this.active);
        if (tile.caps.resizes()) {
            nbt.m_128350_(MIN_X, this.min.x);
            nbt.m_128350_(MIN_Y, this.min.y);
            nbt.m_128350_(MAX_X, this.max.x);
            nbt.m_128350_(MAX_Y, this.max.y);
            nbt.m_128350_(ROTATION, this.rotation);
        }
        nbt.m_128405_(RENDER_DISTANCE, this.renderDistance);
        nbt.m_128379_(FLIP_X, this.flipX);
        nbt.m_128379_(FLIP_Y, this.flipY);
        nbt.m_128405_(ALPHA, this.alpha);
        nbt.m_128405_(BRIGHTNESS, this.brightness);
        nbt.m_128405_(VOLUME, this.volume);
        nbt.m_128405_(VOL_RANGE_MIN, this.minVolumeDistance);
        nbt.m_128405_(VOL_RANGE_MAX, this.maxVolumeDistance);
        nbt.m_128379_(PAUSED, this.paused);
        nbt.m_128379_(MUTED, this.muted);
        nbt.m_128379_(LIT, this.lit);
        nbt.m_128356_(TICK, (long)this.tick);
        nbt.m_128356_(TICK_MAX, (long)this.tickMax);
        nbt.m_128379_(LOOP, this.loop);
        if (tile.caps.renderBehind()) {
            nbt.m_128379_(RENDER_BOTH_SIDES, this.renderBothSides);
        }
        if (tile.caps.projects()) {
            nbt.m_128350_(PROJECTION_DISTANCE, this.projectionDistance);
            nbt.m_128350_(AUDIO_OFFSET, this.audioOffset);
        }
        nbt.m_128376_(DATA_V, (short)2);
    }

    public void load(CompoundTag nbt, DisplayTile tile) {
        String url = nbt.m_128461_(URL);
        this.uri = url.isEmpty() ? null : WaterFrames.createURI(nbt.m_128461_(URL));
        this.uris = WaterFrames.decomposeURIString(nbt.m_128461_(URI_LIST));
        this.uri_index = nbt.m_128451_(URI_INDEX);
        this.uuid = nbt.m_128441_(PLAYER_UUID) ? nbt.m_128342_(PLAYER_UUID) : this.uuid;
        boolean bl = this.active = nbt.m_128441_(ACTIVE) ? nbt.m_128471_(ACTIVE) : this.active;
        if (tile.caps.resizes()) {
            this.min.x = nbt.m_128457_(MIN_X);
            this.min.y = nbt.m_128457_(MIN_Y);
            this.max.x = nbt.m_128457_(MAX_X);
            this.max.y = nbt.m_128457_(MAX_Y);
            this.rotation = nbt.m_128457_(ROTATION);
        }
        this.renderDistance = DisplaysConfig.maxRenDis(nbt.m_128451_(RENDER_DISTANCE));
        this.flipX = nbt.m_128471_(FLIP_X);
        this.flipY = nbt.m_128471_(FLIP_Y);
        this.alpha = nbt.m_128441_(ALPHA) ? nbt.m_128451_(ALPHA) : this.alpha;
        this.brightness = nbt.m_128441_(BRIGHTNESS) ? nbt.m_128451_(BRIGHTNESS) : this.alpha;
        this.volume = nbt.m_128441_(VOLUME) ? DisplaysConfig.maxVol(nbt.m_128451_(VOLUME)) : this.volume;
        this.maxVolumeDistance = nbt.m_128441_(VOL_RANGE_MAX) ? DisplaysConfig.maxVolDis(nbt.m_128451_(VOL_RANGE_MAX)) : this.maxVolumeDistance;
        this.minVolumeDistance = nbt.m_128441_(VOL_RANGE_MIN) ? Math.min(nbt.m_128451_(VOL_RANGE_MIN), this.maxVolumeDistance) : this.minVolumeDistance;
        this.paused = nbt.m_128471_(PAUSED);
        this.muted = nbt.m_128471_(MUTED);
        this.lit = !nbt.m_128441_(LIT) || nbt.m_128471_(LIT);
        this.tick = nbt.m_128451_(TICK);
        this.tickMax = nbt.m_128441_(TICK_MAX) ? nbt.m_128451_(TICK_MAX) : this.tickMax;
        this.loop = nbt.m_128471_(LOOP);
        if (tile.caps.renderBehind()) {
            this.renderBothSides = nbt.m_128471_(RENDER_BOTH_SIDES);
        }
        if (tile.caps.projects()) {
            this.projectionDistance = nbt.m_128441_(PROJECTION_DISTANCE) ? DisplaysConfig.maxProjDis(nbt.m_128457_(PROJECTION_DISTANCE)) : this.projectionDistance;
            this.audioOffset = nbt.m_128441_(AUDIO_OFFSET) ? nbt.m_128457_(AUDIO_OFFSET) : this.audioOffset;
        }
        switch (nbt.m_128448_(DATA_V)) {
            case 1: {
                this.alpha = (int)(nbt.m_128457_(ALPHA) * 255.0f);
                this.brightness = (int)(nbt.m_128457_(BRIGHTNESS) * 255.0f);
                break;
            }
            default: {
                if (!nbt.m_128441_("maxx")) {
                    return;
                }
                this.min.x = nbt.m_128457_("minx");
                this.min.y = nbt.m_128457_("miny");
                this.max.x = nbt.m_128457_("maxx");
                this.max.y = nbt.m_128457_("maxy");
                this.flipX = nbt.m_128471_("flipX");
                this.flipY = nbt.m_128471_("flipY");
                this.maxVolumeDistance = DisplaysConfig.maxVolDis((int)nbt.m_128457_("max"));
                this.minVolumeDistance = Math.min((int)nbt.m_128457_("min"), this.maxVolumeDistance);
                this.renderDistance = nbt.m_128451_("render");
                if (tile.canHideModel()) {
                    tile.setVisibility(nbt.m_128471_("visibleFrame"));
                }
                if (!tile.caps.renderBehind()) break;
                this.renderBothSides = nbt.m_128471_("bothSides");
            }
        }
        this.restrictWidth();
        this.restrictHeight();
    }

    public void setAudioPosition(AudioPosition position) {
        this.audioOffset = switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case AudioPosition.BLOCK -> 0.0f;
            case AudioPosition.PROJECTION -> this.projectionDistance;
            case AudioPosition.CENTER -> this.projectionDistance / 2.0f;
        };
    }

    public AudioPosition getAudioPosition() {
        return this.audioOffset == 0.0f ? AudioPosition.BLOCK : (this.audioOffset == this.projectionDistance ? AudioPosition.PROJECTION : AudioPosition.CENTER);
    }

    public void setWidth(float width) {
        this.setWidth(this.getPosX(), width);
    }

    public void setWidth(PositionHorizontal position, float width) {
        switch (position) {
            case LEFT: {
                this.min.x = 0.0f;
                this.max.x = width;
                break;
            }
            case RIGHT: {
                this.min.x = 1.0f - width;
                this.max.x = 1.0f;
                break;
            }
            default: {
                float middle = width / 2.0f;
                this.min.x = 0.5f - middle;
                this.max.x = 0.5f + middle;
            }
        }
    }

    public void setHeight(float height) {
        this.setHeight(this.getPosY(), height);
    }

    public void setHeight(PositionVertical position, float height) {
        switch (position) {
            case TOP: {
                this.min.y = 0.0f;
                this.max.y = height;
                break;
            }
            case BOTTOM: {
                this.min.y = 1.0f - height;
                this.max.y = 1.0f;
                break;
            }
            default: {
                float middle = height / 2.0f;
                this.min.y = 0.5f - middle;
                this.max.y = 0.5f + middle;
            }
        }
    }

    private void restrictWidth() {
        float maxWidth = DisplaysConfig.maxWidth();
        if (this.getWidth() > maxWidth) {
            switch (this.getPosX()) {
                case LEFT: {
                    this.min.x = 0.0f;
                    this.max.x = maxWidth;
                    break;
                }
                case RIGHT: {
                    this.min.x = 1.0f - maxWidth;
                    this.max.x = 1.0f;
                    break;
                }
                default: {
                    float middle = maxWidth / 2.0f;
                    this.min.x = 0.5f - middle;
                    this.max.x = 0.5f + middle;
                }
            }
        }
    }

    public DisplayData setProjectionDistance(float projectionDistance) {
        this.projectionDistance = projectionDistance;
        return this;
    }

    private void restrictHeight() {
        float maxHeight = DisplaysConfig.maxHeight();
        if (this.getHeight() > maxHeight) {
            switch (this.getPosY()) {
                case TOP: {
                    this.min.y = 0.0f;
                    this.max.y = maxHeight;
                    break;
                }
                case BOTTOM: {
                    this.min.y = 1.0f - maxHeight;
                    this.max.y = 1.0f;
                    break;
                }
                default: {
                    float middle = maxHeight / 2.0f;
                    this.min.y = 0.5f - middle;
                    this.max.y = 0.5f + middle;
                }
            }
        }
    }

    public static CompoundTag build(PlayListScreen screen, DisplayTile tile) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(URI_LIST, WaterFrames.composeURIString(screen.getUris()));
        nbt.m_128405_(URI_INDEX, 0);
        return nbt;
    }

    public static CompoundTag build(DisplayScreen screen, DisplayTile tile) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(URL, screen.url.getText());
        nbt.m_128379_(ACTIVE, true);
        if (tile.caps.resizes()) {
            nbt.m_128350_("width", Math.max(0.1f, (float)screen.widthField.getValue()));
            nbt.m_128350_("height", Math.max(0.1f, (float)screen.heightField.getValue()));
            nbt.m_128405_("pos_x", screen.pos_view.getX().ordinal());
            nbt.m_128405_("pos_y", screen.pos_view.getY().ordinal());
            nbt.m_128350_(ROTATION, (float)screen.rotation.getValue());
        }
        nbt.m_128379_(FLIP_X, screen.flip_x.value);
        nbt.m_128379_(FLIP_Y, screen.flip_y.value);
        nbt.m_128405_(ALPHA, screen.alpha.getIntValue());
        nbt.m_128405_(BRIGHTNESS, screen.brightness.getIntValue());
        nbt.m_128405_(RENDER_DISTANCE, screen.render_distance.getIntValue());
        nbt.m_128405_(VOLUME, screen.volume.getIntValue());
        nbt.m_128405_(VOL_RANGE_MIN, screen.volume_min.getIntValue());
        nbt.m_128405_(VOL_RANGE_MAX, screen.volume_max.getIntValue());
        if (tile.m_58900_().m_61138_((Property)DisplayBlock.VISIBLE)) {
            nbt.m_128379_("visible", screen.show_model.value);
        }
        nbt.m_128379_(LIT, screen.lit.value);
        if (tile.caps.renderBehind()) {
            nbt.m_128379_(RENDER_BOTH_SIDES, screen.mirror.value);
        }
        if (tile.caps.projects()) {
            nbt.m_128350_(PROJECTION_DISTANCE, (float)screen.projection_distance.getValue());
            nbt.m_128405_(AUDIO_OFFSET, screen.audio_offset.getState());
        }
        return nbt;
    }

    public static void syncList(DisplayTile tile, Player player, CompoundTag tag) {
        tile.data.uris = WaterFrames.decomposeURIString(tag.m_128461_(URI_LIST));
        tile.data.uri_index = tag.m_128451_(URI_INDEX);
        if (tile.data.uris.isEmpty()) {
            tile.data.uri = null;
        }
        tile.setDirty();
    }

    public static void sync(DisplayTile tile, Player player, CompoundTag nbt) {
        String url = nbt.m_128461_(URL);
        if (DisplaysConfig.canSave(player, url)) {
            URI uri = WaterFrames.createURI(url);
            if (!tile.data.hasUri() || !tile.data.getUri().equals(uri)) {
                tile.data.tick = 0;
                tile.data.tickMax = -1;
            }
            tile.data.uri = uri;
            tile.data.uuid = tile.data.hasUri() ? player.m_20148_() : Util.f_137441_;
            tile.data.active = nbt.m_128471_(ACTIVE);
            if (tile.caps.resizes()) {
                float width = DisplaysConfig.maxWidth(nbt.m_128457_("width"));
                float height = DisplaysConfig.maxHeight(nbt.m_128457_("height"));
                int posX = nbt.m_128451_("pos_x");
                int posY = nbt.m_128451_("pos_y");
                tile.data.setWidth(PositionHorizontal.VALUES[posX], width);
                tile.data.setHeight(PositionVertical.VALUES[posY], height);
                tile.data.rotation = nbt.m_128457_(ROTATION);
            }
            tile.data.flipX = nbt.m_128471_(FLIP_X);
            tile.data.flipY = nbt.m_128471_(FLIP_Y);
            tile.data.alpha = nbt.m_128451_(ALPHA);
            tile.data.brightness = nbt.m_128451_(BRIGHTNESS);
            tile.data.renderDistance = DisplaysConfig.maxRenDis(nbt.m_128451_(RENDER_DISTANCE));
            tile.data.volume = DisplaysConfig.maxVol(nbt.m_128451_(VOLUME));
            tile.data.maxVolumeDistance = DisplaysConfig.maxVolDis(nbt.m_128451_(VOL_RANGE_MAX));
            tile.data.minVolumeDistance = Math.min(nbt.m_128451_(VOL_RANGE_MIN), tile.data.maxVolumeDistance);
            if (tile.data.minVolumeDistance > tile.data.maxVolumeDistance) {
                tile.data.maxVolumeDistance = tile.data.minVolumeDistance;
            }
            if (tile.canHideModel()) {
                tile.setVisibility(nbt.m_128471_("visible"));
            }
            tile.data.lit = nbt.m_128471_(LIT);
            if (tile.caps.renderBehind()) {
                tile.data.renderBothSides = nbt.m_128471_(RENDER_BOTH_SIDES);
            }
            if (tile.caps.projects()) {
                int mode = nbt.m_128451_(AUDIO_OFFSET);
                tile.data.projectionDistance = DisplaysConfig.maxProjDis(nbt.m_128457_(PROJECTION_DISTANCE));
                tile.data.setAudioPosition(AudioPosition.VALUES[mode]);
            }
        }
        tile.setDirty();
    }
}

