/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1132;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.ICreativeConfig;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;

public class DisplaysConfig
implements ICreativeConfig {
    public static final Marker IT = MarkerManager.getMarker((String)"Config");
    public static final DisplaysConfig ROOT = new DisplaysConfig();
    public static final Rendering RENDERING = new Rendering();
    public static final Multimedia MULTIMEDIA = new Multimedia();
    public static final Multimedia.WaterMedia WATERMEDIA = new Multimedia.WaterMedia();
    public static final BlockBehavior BEHAVIOR = new BlockBehavior();
    public static final RemoteControl REMOTE = new RemoteControl();
    public static final Permissions PERMISSIONS = new Permissions();
    public static final Permissions.Whitelist WHITELIST = new Permissions.Whitelist();
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean overrideServerConfig = false;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean clientUseMultimedia = false;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean clientKeepsRendering = false;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean forceDevMode = false;

    public static void init() {
        ConfigHolderDynamic holder = CreativeConfigRegistry.ROOT.registerFolder("waterframes");
        holder.registerValue("General", (Object)ROOT);
        holder.registerValue("Rendering", (Object)RENDERING);
        ConfigHolderDynamic folderMultimedia = holder.registerFolder("Multimedia");
        folderMultimedia.registerValue("Multimedia", (Object)MULTIMEDIA);
        ConfigHolderDynamic folderWaterMedia = folderMultimedia.registerFolder("WaterMedia");
        folderWaterMedia.registerValue("WaterMedia", (Object)WATERMEDIA);
        holder.registerValue("BlockBehavior", (Object)BEHAVIOR);
        holder.registerValue("RemoteControl", (Object)REMOTE);
        ConfigHolderDynamic permissions = holder.registerValue("Permissions", (Object)PERMISSIONS);
        permissions.registerValue("Whitelist", (Object)WHITELIST);
    }

    public void configured(Side side) {
    }

    public static float maxWidth() {
        return DisplaysConfig.RENDERING.maxWidth;
    }

    public static float maxHeight() {
        return DisplaysConfig.RENDERING.maxHeight;
    }

    public static float maxWidth(float width) {
        return Math.min(width, DisplaysConfig.maxWidth());
    }

    public static float maxHeight(float height) {
        return Math.min(height, DisplaysConfig.maxHeight());
    }

    public static int maxRenDis() {
        return DisplaysConfig.RENDERING.maxRenderDistance;
    }

    public static int maxRenDis(int value) {
        return Math.min(value, DisplaysConfig.maxRenDis());
    }

    public static float maxProjDis() {
        return DisplaysConfig.RENDERING.maxProjectionDistance;
    }

    public static float maxProjDis(float value) {
        return Math.min(value, DisplaysConfig.maxProjDis());
    }

    public static boolean keepsRendering() {
        return DisplaysConfig.ROOT.overrideServerConfig ? DisplaysConfig.ROOT.clientKeepsRendering : DisplaysConfig.RENDERING.keepRendering;
    }

    public static boolean useLightOnPlay() {
        return DisplaysConfig.BEHAVIOR.useLightsOnPlay;
    }

    public static boolean forceLightOnPlay() {
        return DisplaysConfig.BEHAVIOR.forceLightsOnPlay;
    }

    public static boolean useLagTickCorrection() {
        return DisplaysConfig.BEHAVIOR.useLagTickCorrection;
    }

    public static int maxVolDis() {
        return DisplaysConfig.MULTIMEDIA.maxVolumeDistance;
    }

    public static int maxVolDis(int value) {
        return Math.min(value, DisplaysConfig.maxVolDis());
    }

    public static boolean useMasterVolume() {
        return DisplaysConfig.MULTIMEDIA.useMasterVolume;
    }

    public static boolean vsEurekaCompat() {
        return DisplaysConfig.MULTIMEDIA.useVSEurekaCompat;
    }

    public static int maxVol() {
        return DisplaysConfig.MULTIMEDIA.maxVolume;
    }

    public static int maxVol(int value) {
        return Math.max(Math.min(value, DisplaysConfig.maxVol()), 0);
    }

    public static boolean useMultimedia() {
        return DisplaysConfig.ROOT.overrideServerConfig ? DisplaysConfig.ROOT.clientUseMultimedia : DisplaysConfig.WATERMEDIA.useMultimedia;
    }

    public static boolean useRedstone() {
        return DisplaysConfig.BEHAVIOR.useRedstone;
    }

    public static boolean useMasterModeRedstone() {
        return DisplaysConfig.useRedstone() && DisplaysConfig.BEHAVIOR.useMasterModeOnRedsone;
    }

    public static int maxRcDis() {
        return DisplaysConfig.REMOTE.remoteDistance;
    }

    public static boolean useInAdv() {
        return DisplaysConfig.PERMISSIONS.useInAdventure;
    }

    public static boolean useInSurv() {
        return DisplaysConfig.PERMISSIONS.useInSurvival;
    }

    public static boolean useForAnyone() {
        return DisplaysConfig.PERMISSIONS.useForAnyone;
    }

    public static boolean useWhitelist() {
        return DisplaysConfig.WHITELIST.useWhitelist;
    }

    public static boolean useWhitelist(boolean state) {
        DisplaysConfig.WHITELIST.useWhitelist = state;
        return state;
    }

    public static boolean toggleWhitelist() {
        return DisplaysConfig.useWhitelist(!DisplaysConfig.useWhitelist());
    }

    public static void addOnWhitelist(String url) {
        DisplaysConfig.WHITELIST.whitelist.add(url);
    }

    public static boolean removeOnWhitelist(String url) {
        return DisplaysConfig.WHITELIST.whitelist.remove(url);
    }

    public static boolean isWhiteListed(URI uri) {
        if (!DisplaysConfig.useWhitelist()) {
            return true;
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return false;
        }
        if (scheme.equals("water")) {
            return true;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        for (String s : DisplaysConfig.WHITELIST.whitelist) {
            if (!host.endsWith("." + s) && !host.equals(s)) continue;
            return !DisplaysConfig.PERMISSIONS.blackWhitelist;
        }
        return DisplaysConfig.PERMISSIONS.blackWhitelist;
    }

    public static <T> Set<T> mutableSet(Iterator<T> it) {
        HashSet<T> list = new HashSet<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static boolean canSave(class_1657 player, String url) {
        boolean valid;
        URI uri = WaterFrames.createURI(url);
        boolean bl = valid = uri != null || url.isEmpty();
        if (DisplaysConfig.PERMISSIONS.usePermissionAPI) {
            boolean canSave = DisplaysRegistry.getPermBoolean(player, "waterframes.displays.save");
            boolean canBypass = DisplaysRegistry.getPermBoolean(player, "waterframes.whitelist.bypass");
            boolean whitelisted = DisplaysConfig.isWhiteListed(uri);
            if (canSave && (whitelisted || canBypass)) {
                return valid;
            }
            return false;
        }
        boolean canSave = DisplaysConfig.PERMISSIONS.allowSaving;
        if (DisplaysConfig.isAdmin(player)) {
            return valid;
        }
        if (url.isEmpty()) {
            return true;
        }
        return valid && canSave && DisplaysConfig.isWhiteListed(uri);
    }

    public static boolean canInteractBlock(class_1657 player, DisplayBlock block) {
        class_1934 gameType;
        if (DisplaysConfig.PERMISSIONS.usePermissionAPI) {
            String NODE = block.getPermissionNode();
            return DisplaysRegistry.getPermBoolean(player, "waterframes.displays.interact") || DisplaysRegistry.getPermBoolean(player, NODE);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            v0 = serverPlayer.field_13974.method_14257();
        } else {
            v0 = gameType = class_310.method_1551().field_1761.method_2920();
        }
        if (DisplaysConfig.isAdmin(player)) {
            return true;
        }
        if (!DisplaysConfig.useInSurv() && gameType.equals((Object)class_1934.field_9215)) {
            return false;
        }
        if (!DisplaysConfig.useInAdv() && gameType.equals((Object)class_1934.field_9216)) {
            return false;
        }
        return DisplaysConfig.useForAnyone();
    }

    public static boolean canInteractRemote(class_1657 player) {
        if (DisplaysConfig.PERMISSIONS.usePermissionAPI) {
            return DisplaysRegistry.getPermBoolean(player, "waterframes.remote.interact") || DisplaysConfig.isOwner(player);
        }
        if (DisplaysConfig.isAdmin(player)) {
            return true;
        }
        return DisplaysConfig.PERMISSIONS.useRemotes;
    }

    public static boolean canBindRemote(class_1657 player) {
        if (DisplaysConfig.PERMISSIONS.usePermissionAPI) {
            return DisplaysRegistry.getPermBoolean(player, "waterframes.remote.bind") || DisplaysConfig.isOwner(player);
        }
        if (DisplaysConfig.isAdmin(player)) {
            return true;
        }
        return DisplaysConfig.PERMISSIONS.useBindingRemotes;
    }

    public static boolean isAdmin(class_1657 player) {
        class_1937 level = player.field_6002;
        boolean owner = DisplaysConfig.isOwner(player);
        if (owner) {
            return true;
        }
        if (level.method_8608()) {
            class_1132 integrated = class_310.method_1551().method_1576();
            if (integrated != null) {
                return integrated.method_19466(player.method_7334()) || player.method_5687(integrated.method_3798());
            }
            return player.method_5687(4);
        }
        return player.method_5687(4);
    }

    public static boolean isOwner(class_1657 player) {
        String name = player.method_7334().getName();
        return name.equals("SrRaapero720") || name.equals("SrRapero720");
    }

    public static boolean isDevMode() {
        return FabricLoader.getInstance().isDevelopmentEnvironment() || DisplaysConfig.ROOT.forceDevMode;
    }

    public static class Rendering {
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        @CreativeConfig.DecimalRange(min=1.0, max=256.0)
        public float maxWidth = 48.0f;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        @CreativeConfig.DecimalRange(min=1.0, max=256.0)
        public float maxHeight = 48.0f;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        @CreativeConfig.IntRange(min=1, max=512)
        public int maxRenderDistance = 64;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        @CreativeConfig.DecimalRange(min=1.0, max=256.0)
        public float maxProjectionDistance = 64.0f;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean keepRendering = true;
    }

    public static class Multimedia {
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        @CreativeConfig.IntRange(min=8, max=512)
        public int maxVolumeDistance = 64;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        @CreativeConfig.IntRange(min=10, max=128)
        public int maxVolume = 100;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useMasterVolume = false;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useVSEurekaCompat = true;

        public static class WaterMedia {
            @CreativeConfig(type=ConfigSynchronization.SERVER)
            public boolean useMultimedia = true;
        }
    }

    public static class BlockBehavior {
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useLightsOnPlay = true;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean forceLightsOnPlay = true;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useRedstone = true;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useMasterModeOnRedsone = false;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useLagTickCorrection = true;
    }

    public static class RemoteControl {
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        @CreativeConfig.IntRange(min=4, max=128)
        public int remoteDistance = 32;
    }

    public static class Permissions {
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useInAdventure = false;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useInSurvival = true;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useForAnyone = true;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useBindingRemotes = true;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useRemotes = true;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean useWhitelist = true;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean blackWhitelist = false;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean allowSaving = true;
        @CreativeConfig(type=ConfigSynchronization.SERVER)
        public boolean usePermissionAPI = false;

        public static class Whitelist {
            @CreativeConfig(type=ConfigSynchronization.SERVER)
            public boolean useWhitelist = true;
            @CreativeConfig(type=ConfigSynchronization.SERVER)
            public List<String> whitelist = List.of("imgur.com", "gyazo.com", "prntscr.com", "tinypic.com", "puu.sh", "pinimg.com", "photobucket.com", "staticflickr.com", "flic.kr", "tenor.co", "gfycat.com", "giphy.com", "gph.is", "gifbin.com", "i.redd.it", "media.tumblr.com", "twimg.com", "discordapp.com", "images.discordapp.net", "discord.com", "githubusercontent.com", "googleusercontent.com", "googleapis.com", "wikimedia.org", "ytimg.com", "youtube.com", "youtu.be", "twitch.tv", "twitter.com", "soundcloud.com", "kick.com", "srrapero720.me", "fbcdn.net", "drive.google.com");
        }
    }
}

