/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import team.creative.creativecore.common.gui.control.simple.GuiIcon;
import team.creative.creativecore.common.gui.style.Icon;

public class WidgetClickableArea
extends GuiIcon {
    private PositionHorizontal x;
    private PositionVertical y;
    private boolean selected = false;

    public WidgetClickableArea(String name, PositionHorizontal x, PositionVertical y) {
        super(name, IconStyles.POS_BASE);
        this.x = x;
        this.y = y;
    }

    protected void renderContent(class_332 guiGraphics, int mouseX, int mouseY) {
        class_4587 pose = guiGraphics.method_51448();
        super.renderContent(guiGraphics, mouseX, mouseY);
        this.renderSelector(guiGraphics, mouseX, mouseY);
    }

    protected void renderSelector(class_332 graphics, int mouseX, int mouseY) {
        class_4587 pose = graphics.method_51448();
        Icon icon = IconStyles.POS_ICON;
        float width = (float)this.rect.getWidth() / 3.0f;
        float height = (float)this.rect.getWidth() / 3.0f;
        float offsetX = switch (this.x) {
            default -> throw new MatchException(null, null);
            case PositionHorizontal.LEFT -> 0.0f;
            case PositionHorizontal.CENTER -> width;
            case PositionHorizontal.RIGHT -> (float)((double)width * 2.0);
        };
        float offsetY = switch (this.y) {
            default -> throw new MatchException(null, null);
            case PositionVertical.TOP -> 0.0f;
            case PositionVertical.CENTER -> height;
            case PositionVertical.BOTTOM -> (float)((double)height * 2.0);
        };
        pose.method_22903();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)icon.location());
        this.color.glColor();
        Matrix4f matrix = pose.method_23760().method_23761();
        float x = offsetX;
        float x2 = offsetX + width;
        float y = offsetY;
        float y2 = offsetY + height;
        float u = (float)icon.minX() / 256.0f;
        float v = (float)icon.minY() / 256.0f;
        float u2 = (float)(icon.minX() + icon.width()) / 256.0f;
        float v2 = (float)(icon.minY() + icon.height()) / 256.0f;
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(matrix, x, y2, 0.0f).method_22913(u, v2);
        bufferbuilder.method_22918(matrix, x2, y2, 0.0f).method_22913(u2, v2);
        bufferbuilder.method_22918(matrix, x2, y, 0.0f).method_22913(u2, v);
        bufferbuilder.method_22918(matrix, x, y, 0.0f).method_22913(u, v);
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
        RenderSystem.disableBlend();
        pose.method_22909();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        WidgetClickableArea.playSound((class_6880.class_6883)class_3417.field_15015);
        this.selected = true;
        this.mouseMoved(mouseX, mouseY);
        return true;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        if (this.selected) {
            int areaX = (int)(mouseX / (double)this.rect.getWidth() * 3.0);
            int areaY = (int)(mouseY / (double)this.rect.getHeight() * 3.0);
            this.x = switch (areaX) {
                case 0 -> PositionHorizontal.LEFT;
                case 1 -> PositionHorizontal.CENTER;
                case 2, 3 -> PositionHorizontal.RIGHT;
                default -> areaX > 3 ? PositionHorizontal.RIGHT : PositionHorizontal.LEFT;
            };
            this.y = switch (areaY) {
                case 0 -> PositionVertical.TOP;
                case 1 -> PositionVertical.CENTER;
                case 2, 3 -> PositionVertical.BOTTOM;
                default -> areaY > 3 ? PositionVertical.BOTTOM : PositionVertical.TOP;
            };
        }
    }

    public void mouseReleased(double x, double y, int button) {
        this.selected = false;
        super.mouseReleased(x, y, button);
    }

    public List<class_2561> getTooltip() {
        ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
        tooltips.add((class_2561)WidgetClickableArea.translatable((String)"waterframes.gui.position.desc"));
        tooltips.add((class_2561)WidgetClickableArea.translatable((String)"waterframes.gui.position.vertical", (Object[])new Object[]{String.valueOf(class_124.field_1075) + WidgetClickableArea.translate((String)("waterframes.gui.position." + this.y.name().toLowerCase()))}));
        tooltips.add((class_2561)WidgetClickableArea.translatable((String)"waterframes.gui.position.horizontal", (Object[])new Object[]{String.valueOf(class_124.field_1075) + WidgetClickableArea.translate((String)("waterframes.gui.position." + this.x.name().toLowerCase()))}));
        return tooltips;
    }

    public PositionHorizontal getX() {
        return this.x;
    }

    public PositionVertical getY() {
        return this.y;
    }
}

