/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.display;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.Executor;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.DisplayList;
import me.srrapero720.waterframes.client.rendering.TextureWrapper;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2374;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.api.image.ImageCache;
import org.watermedia.api.image.ImageRenderer;
import org.watermedia.api.math.MathAPI;
import org.watermedia.api.player.videolan.VideoPlayer;
import org.watermedia.videolan4j.player.base.State;

@Environment(value=EnvType.CLIENT)
public class Display {
    private static final Marker IT = MarkerManager.getMarker((String)"Display");
    private static final Int2ObjectOpenHashMap<class_2960> TEXTURES = new Int2ObjectOpenHashMap();
    private VideoPlayer mediaPlayer;
    private final ImageCache imageCache;
    private final DisplayTile tile;
    private boolean notVideo;
    private int currentVolume = 0;
    private long currentLastTime = Long.MIN_VALUE;
    private Mode displayMode = Mode.PICTURE;
    private boolean stream = false;
    private boolean synced = false;
    private boolean released = false;

    public Display(DisplayTile tile) {
        this.tile = tile;
        this.imageCache = tile.imageCache;
        if (this.imageCache.isVideo()) {
            this.switchVideoMode();
        } else {
            this.imageCache.addReleaseCallback(renderer -> {
                for (int tex : renderer.textures) {
                    DisplaysRegistry.unregisterTexture((class_2960)TEXTURES.remove(tex));
                }
            });
        }
    }

    private void switchVideoMode() {
        if (!DisplaysConfig.useMultimedia()) {
            return;
        }
        if (this.notVideo) {
            this.displayMode = Mode.PICTURE;
            return;
        }
        this.displayMode = Mode.VIDEO;
        this.mediaPlayer = new VideoPlayer((Executor)class_310.method_1551());
        if (this.mediaPlayer.isBroken()) {
            this.displayMode = Mode.PICTURE;
            this.notVideo = true;
            return;
        }
        this.currentVolume = this.rangedVol(this.tile.data.volume, this.tile.data.minVolumeDistance, this.tile.data.maxVolumeDistance);
        this.mediaPlayer.setVolume(this.currentVolume);
        this.mediaPlayer.setRepeatMode(this.tile.data.loop);
        this.mediaPlayer.setPauseMode(this.tile.data.paused);
        this.mediaPlayer.setMuteMode(this.tile.data.muted);
        this.mediaPlayer.start(this.tile.data.getUri());
        DisplayList.add(this);
    }

    public int width() {
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                if (this.imageCache.getRenderer() != null) {
                    yield this.imageCache.getRenderer().width;
                }
                yield 1;
            }
            case 0 -> this.mediaPlayer.width();
            case 2 -> 0;
        };
    }

    public int height() {
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                if (this.imageCache.getRenderer() != null) {
                    yield this.imageCache.getRenderer().height;
                }
                yield 1;
            }
            case 0 -> this.mediaPlayer.height();
            case 2 -> 0;
        };
    }

    public int texture() {
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> this.imageCache.getRenderer().texture(this.tile.data.tick, (long)(!this.tile.data.paused ? MathAPI.tickToMs((float)WaterFrames.deltaFrames()) : 0), this.tile.data.loop);
            case 0 -> {
                if (this.mediaPlayer.isBroken()) {
                    yield this.imageCache.getRenderer().texture(this.tile.data.tick, (long)(!this.tile.data.paused ? MathAPI.tickToMs((float)WaterFrames.deltaFrames()) : 0), this.tile.data.loop);
                }
                yield this.mediaPlayer.texture();
            }
            case 2 -> 0;
        };
    }

    public void preRender() {
        switch (this.displayMode.ordinal()) {
            case 1: {
                break;
            }
            case 0: {
                this.mediaPlayer.preRender();
            }
        }
    }

    public class_2960 getTextureId() {
        int texture = this.texture();
        if (texture != -1) {
            return (class_2960)TEXTURES.computeIfAbsent((Object)texture, integer -> {
                class_2960 id = WaterFrames.asResource(texture);
                DisplaysRegistry.registerTexture(id, new TextureWrapper(texture));
                return id;
            });
        }
        return null;
    }

    public int durationInTicks() {
        return MathAPI.msToTick((long)this.duration());
    }

    public long duration() {
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                ImageRenderer renderer = this.imageCache.getRenderer();
                if (renderer != null) {
                    if (renderer.duration == 0L) {
                        yield 200L;
                    }
                    yield renderer.duration;
                }
                yield 0L;
            }
            case 0 -> this.mediaPlayer.getDuration();
            case 2 -> 0L;
        };
    }

    public boolean canTick() {
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> this.imageCache.getStatus().equals((Object)ImageCache.Status.READY);
            case 0 -> {
                if (this.mediaPlayer.isSafeUse() && this.mediaPlayer.isValid()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> this.mediaPlayer.isSafeUse();
        };
    }

    public boolean canRender() {
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                if (this.imageCache.getRenderer() != null && !this.imageCache.isVideo() && this.tile.data.active || this.notVideo) {
                    yield true;
                }
                yield false;
            }
            case 0 -> {
                if (this.mediaPlayer.isSafeUse() && !this.mediaPlayer.isLoading() && this.mediaPlayer.isReady() && this.tile.data.active) {
                    yield true;
                }
                yield false;
            }
            case 2 -> false;
        };
    }

    public void syncDuration() {
        if (this.tile.data.tickMax == -1) {
            this.tile.data.tick = 0;
        }
        this.tile.syncTime(true, this.tile.data.tick, this.durationInTicks());
        this.synced = true;
    }

    public void tick() {
        switch (this.displayMode.ordinal()) {
            case 1: {
                if (!this.imageCache.isVideo() || this.notVideo) break;
                this.switchVideoMode();
                break;
            }
            case 0: 
            case 2: {
                boolean mayPause;
                if (this.mediaPlayer.isBroken()) break;
                int volume = this.rangedVol(this.tile.data.volume, this.tile.data.minVolumeDistance, this.tile.data.maxVolumeDistance);
                if (this.currentVolume != volume) {
                    this.currentVolume = volume;
                    this.mediaPlayer.setVolume(this.currentVolume);
                }
                if (!this.mediaPlayer.isSafeUse() || !this.mediaPlayer.isValid()) break;
                if (this.mediaPlayer.getRepeatMode() != this.tile.data.loop) {
                    this.mediaPlayer.setRepeatMode(this.tile.data.loop);
                }
                if (this.mediaPlayer.isMuted() != this.tile.data.muted) {
                    this.mediaPlayer.setMuteMode(this.tile.data.muted);
                }
                if (!this.stream && this.mediaPlayer.isLive()) {
                    this.stream = true;
                }
                boolean bl = mayPause = this.tile.data.paused || !this.tile.data.active || class_310.method_1551().method_1493();
                if (this.mediaPlayer.isPaused() != mayPause) {
                    this.mediaPlayer.setPauseMode(mayPause);
                }
                if (this.stream || !this.mediaPlayer.isSeekAble()) break;
                long time = MathAPI.tickToMs((long)this.tile.data.tick) + (long)(!mayPause ? MathAPI.tickToMs((float)WaterFrames.deltaFrames()) : 0);
                if (time > this.mediaPlayer.getTime() && this.tile.data.loop) {
                    long mediaDuration = this.mediaPlayer.getMediaInfoDuration();
                    long l = time = time == 0L || mediaDuration == 0L ? 0L : Math.floorMod(time, this.mediaPlayer.getMediaInfoDuration());
                }
                if (Math.abs(time - this.mediaPlayer.getTime()) <= 2000L || Math.abs(time - this.currentLastTime) <= 2000L) break;
                this.currentLastTime = time;
                this.mediaPlayer.seekTo(time);
            }
        }
        if (!this.synced && this.canRender()) {
            this.syncDuration();
        }
    }

    public boolean isReady() {
        if (this.imageCache.getStatus() != ImageCache.Status.READY) {
            return false;
        }
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> true;
            case 0, 2 -> this.imageCache.getStatus() == ImageCache.Status.READY && this.mediaPlayer.isReady();
        };
    }

    public boolean isBuffering() {
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> false;
            case 0, 2 -> this.mediaPlayer.isBuffering() || this.mediaPlayer.isLoading() || this.mediaPlayer.raw().mediaPlayer().status().state() == State.NOTHING_SPECIAL;
        };
    }

    public boolean isBroken() {
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                if (this.imageCache == null) {
                    yield true;
                }
                yield false;
            }
            case 0, 2 -> this.mediaPlayer.isBroken();
        };
    }

    public boolean isNotVideo() {
        if (this.imageCache.getStatus() == ImageCache.Status.FAILED) {
            return true;
        }
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> false;
            case 0, 2 -> this.mediaPlayer.isBroken();
        };
    }

    public boolean isLoading() {
        if (this.imageCache.getStatus() == ImageCache.Status.LOADING) {
            return true;
        }
        return switch (this.displayMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> false;
            case 0, 2 -> this.mediaPlayer.isLoading();
        };
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setPauseMode(boolean pause) {
        switch (this.displayMode.ordinal()) {
            case 1: {
                break;
            }
            case 0: 
            case 2: {
                this.mediaPlayer.seekTo(MathAPI.tickToMs((long)this.tile.data.tick));
                this.mediaPlayer.setPauseMode(pause);
                this.mediaPlayer.setMuteMode(this.tile.data.muted);
            }
        }
    }

    public void setMuteMode(boolean mute) {
        switch (this.displayMode.ordinal()) {
            case 1: {
                break;
            }
            case 0: 
            case 2: {
                this.mediaPlayer.setMuteMode(mute);
            }
        }
    }

    public void release() {
        if (this.isReleased()) {
            return;
        }
        this.released = true;
        this.imageCache.deuse();
        switch (this.displayMode.ordinal()) {
            case 1: {
                break;
            }
            case 0: 
            case 2: {
                this.mediaPlayer.release();
                DisplaysRegistry.unregisterTexture((class_2960)TEXTURES.remove(this.mediaPlayer.texture()));
                DisplayList.remove(this);
            }
        }
    }

    public int rangedVol(int volume, int min, int max) {
        double distance = WaterFrames.getDistance(this.tile.field_11863, this.tile.method_11016().method_10079(this.tile.getDirection(), (int)this.tile.data.audioOffset), (class_2374)class_310.method_1551().field_1724.method_30950(WaterFrames.deltaFrames()));
        if (min > max) {
            int temp = max;
            max = min;
            min = temp;
        }
        if (distance > (double)min) {
            int n = volume = distance > (double)(max + 1) ? 0 : (int)((double)volume * (1.0 - (distance - (double)min) / (double)(1 + max - min)));
        }
        if (DisplaysConfig.useMasterVolume()) {
            volume = (int)((float)volume * class_310.method_1551().field_1690.method_1630(class_3419.field_15250));
        }
        return volume;
    }

    public static enum Mode {
        VIDEO,
        PICTURE,
        AUDIO;

    }
}

