/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.rendering;

import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.textures.GpuTexture;
import me.srrapero720.waterframes.client.rendering.ExternalGlTexture;
import me.srrapero720.watervision.WaterVision;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.watermedia.api.image.ImageRenderer;

@OnlyIn(value=Dist.CLIENT)
public class RendererWrapper
extends AbstractTexture {
    private final ImageRenderer renderer;
    private final GlTexture[] glTextures;

    public RendererWrapper(ImageRenderer imageRenderer) {
        this.renderer = imageRenderer;
        this.glTextures = new GlTexture[this.renderer.textures.length];
        for (int i = 0; i < this.glTextures.length; ++i) {
            this.glTextures[i] = new ExternalGlTexture(this.renderer.width, this.renderer.height, this.renderer.texture(i));
        }
        this.texture = this.glTextures[0];
    }

    public void setFilter(boolean p_117961_, boolean p_117962_) {
        this.getTexture();
        super.setFilter(p_117961_, p_117962_);
    }

    public void setClamp(boolean p_377282_) {
        this.getTexture();
        super.setClamp(p_377282_);
    }

    public void setBlurMipmap(boolean blur, boolean mipmap) {
        this.getTexture();
        super.setBlurMipmap(blur, mipmap);
    }

    @NotNull
    public GpuTexture getTexture() {
        int id = this.renderer.texture(WaterVision.getTicks(), WaterVision.deltaFrames(), true);
        for (int i = 0; i < this.renderer.textures.length; ++i) {
            if (this.glTextures[i].glId() != id) continue;
            this.texture = this.glTextures[i];
            return this.texture;
        }
        this.texture = this.glTextures[0];
        return this.texture;
    }

    public void close() {
    }
}

