/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block;

import java.util.function.Supplier;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.item.RemoteControl;
import me.srrapero720.waterframes.common.item.data.RemoteData;
import me.srrapero720.waterframes.common.screens.DisplayScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.BlockGuiCreator;
import team.creative.creativecore.common.gui.creator.GuiCreator;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public abstract class DisplayBlock
extends BaseEntityBlock
implements BlockGuiCreator,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty VISIBLE = BooleanProperty.create((String)"frame");
    public static final EnumProperty<Direction> ATTACHED_FACE = EnumProperty.create((String)"attached_face", Direction.class, (Enum[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});
    protected static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().strength(1.0f).sound(SoundType.METAL).noOcclusion().forceSolidOff().isSuffocating(Blocks::never).isViewBlocking(Blocks::never).requiresCorrectToolForDrops();

    protected DisplayBlock(ResourceKey<Block> resourceKey) {
        super(PROPERTIES.get().setId(resourceKey));
    }

    protected DisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract EnumProperty<Direction> getFacing();

    public PermissionNode<Boolean> getPermissionNode() {
        return DisplaysRegistry.PERM_DISPLAYS_INTERACT;
    }

    public GuiLayer create(CompoundTag tag, Level level, BlockPos blockPos, BlockState blockState, Player player) {
        DisplayScreen displayScreen;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            displayScreen = new DisplayScreen(tile);
        } else {
            displayScreen = null;
        }
        return displayScreen;
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction p_60542_, BlockPos p_60546_, BlockState p_60543_, RandomSource p_374120_) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, p_60542_, p_60546_, p_60543_, p_374120_);
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        RemoteData data = (RemoteData)stack.get(DisplaysRegistry.REMOTE_DATA);
        Item item = stack.getItem();
        if (item instanceof RemoteControl) {
            RemoteControl control = (RemoteControl)item;
            if (data != null) {
                BlockEntity blockEntity;
                boolean matchDim = control.getDimension(data).equals(level.dimension().location().toString());
                int[] position = control.getPosition(data);
                if (position.length == 0) {
                    return InteractionResult.FAIL;
                }
                boolean matchPos = new BlockPos(position[0], position[1], position[2]).equals((Object)pos);
                if (matchDim && matchPos && (blockEntity = level.getBlockEntity(pos)) instanceof DisplayTile) {
                    DisplayTile tile = (DisplayTile)blockEntity;
                    if (level.isClientSide) {
                        tile.setPause(true, !tile.data.paused);
                    }
                    Vec3 vec = Vec3.atCenterOf((Vec3i)pos);
                    DustParticleOptions opts = new DustParticleOptions(ChatFormatting.AQUA.getColor().intValue(), 1.3f);
                    int i = 0;
                    do {
                        level.addParticle((ParticleOptions)opts, vec.x + this.randomNegative(Math.random()) / 4.0, vec.y, vec.z + this.randomNegative(Math.random()) / 4.0, this.randomNegative(Math.random()), Math.random() * 3.0, this.randomNegative(Math.random()));
                    } while (++i < 4);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (!level.isClientSide && DisplaysConfig.canInteractBlock(player, this)) {
            GuiCreator.BLOCK_OPENER.open(player, pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide && DisplaysConfig.canInteractBlock(player, this)) {
            GuiCreator.BLOCK_OPENER.open(player, pos);
        }
        return InteractionResult.SUCCESS;
    }

    private double randomNegative(double v) {
        return Math.random() > 0.5 ? -v : v;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.getValue(this.getFacing()) == direction;
    }

    public void registerDefaultState(BlockState state) {
        super.registerDefaultState((BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{this.getFacing(), ATTACHED_FACE, POWERED, WATERLOGGED}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction current = context.getHorizontalDirection();
        Player player = context.getPlayer();
        return (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHED_FACE, (Comparable)context.getClickedFace())).setValue(this.getFacing(), (Comparable)(player != null && player.isCrouching() ? current.getOpposite() : current));
    }

    public RenderShape getRenderShape(BlockState state) {
        return state.hasProperty((Property)VISIBLE) ? (((Boolean)state.getValue((Property)VISIBLE)).booleanValue() ? RenderShape.MODEL : RenderShape.INVISIBLE) : RenderShape.MODEL;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getShape(state, level, pos, null);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return (l, pos, state, be) -> {
            if (be instanceof DisplayTile) {
                DisplayTile tile = (DisplayTile)be;
                tile.tick(state);
            }
        };
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, block, orientation, isMoving);
        if (!DisplaysConfig.useRedstone() || !((blockEntity = level.getBlockEntity(pos)) instanceof DisplayTile)) {
            return;
        }
        DisplayTile tile = (DisplayTile)blockEntity;
        boolean signal = level.hasNeighborSignal(pos);
        if ((Boolean)state.getValue((Property)POWERED) != signal) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(signal)), 3);
            if (!level.isClientSide) {
                tile.setPause(false, signal);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            n = tile.getAnalogOutput();
        } else {
            n = 0;
        }
        return n;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            n = tile.getLightLevel();
        } else {
            n = 0;
        }
        return n;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.0f;
    }

    public boolean isCollisionShapeFullBlock(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return false;
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.DESTROY;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(true) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return this.rotate(state, rotation);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(this.getFacing(), (Comparable)rotation.rotate((Direction)state.getValue(this.getFacing())));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(this.getFacing(), (Comparable)mirror.mirror((Direction)state.getValue(this.getFacing())));
    }
}

