/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.data.DisplayData;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.server.command.EnumArgument;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.api.image.ImageAPI;

public class WaterFramesCommand {
    private static final Marker IT = MarkerManager.getMarker((String)"Commands");
    public static final Component ACTIVATED = Component.translatable((String)"waterframes.common.activated");
    public static final Component DEACTIVATED = Component.translatable((String)"waterframes.common.deactivated");
    public static ItemInput[] DEFAULT_INPUTS = new ItemInput[0];

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder waterframes = (LiteralArgumentBuilder)Commands.literal((String)"waterframes").requires(WaterFramesCommand::hasPermissions);
        RequiredArgumentBuilder edit = Commands.argument((String)"blockpos", (ArgumentType)BlockPosArgument.blockPos());
        edit.then(Commands.literal((String)"url").then(Commands.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(c -> WaterFramesCommand.setUrl(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getStr((CommandContext<CommandSourceStack>)c, "url")))));
        LiteralArgumentBuilder position = (LiteralArgumentBuilder)Commands.literal((String)"position").then(((RequiredArgumentBuilder)Commands.argument((String)"vertical", (ArgumentType)EnumArgument.enumArgument(PositionVertical.class)).executes(c -> WaterFramesCommand.setPosition(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getEnum((CommandContext<CommandSourceStack>)c, "vertical", PositionVertical.class), null))).then(Commands.argument((String)"horizontal", (ArgumentType)EnumArgument.enumArgument(PositionHorizontal.class)).executes(c -> WaterFramesCommand.setPosition(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getEnum((CommandContext<CommandSourceStack>)c, "vertical", PositionVertical.class), WaterFramesCommand.getEnum((CommandContext<CommandSourceStack>)c, "horizontal", PositionHorizontal.class)))));
        edit.then((ArgumentBuilder)position);
        edit.then(Commands.literal((String)"size").then(((RequiredArgumentBuilder)Commands.argument((String)"width", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(c -> WaterFramesCommand.setSize(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getFloat((CommandContext<CommandSourceStack>)c, "width"), -1.0f))).then(Commands.argument((String)"height", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(c -> WaterFramesCommand.setSize(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getFloat((CommandContext<CommandSourceStack>)c, "width"), WaterFramesCommand.getFloat((CommandContext<CommandSourceStack>)c, "height"))))));
        edit.then(Commands.literal((String)"rotation").then(Commands.argument((String)"rotation", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)360.0f)).executes(c -> WaterFramesCommand.setRotation(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getFloat((CommandContext<CommandSourceStack>)c, "rotation")))));
        edit.then(Commands.literal((String)"alpha").then(Commands.argument((String)"alpha", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(c -> WaterFramesCommand.setAlpha(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "alpha")))));
        edit.then(Commands.literal((String)"brightness").then(Commands.argument((String)"brightness", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(c -> WaterFramesCommand.setBrightness(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "brightness")))));
        edit.then(Commands.literal((String)"renderDistance").then(Commands.argument((String)"render_distance", (ArgumentType)IntegerArgumentType.integer((int)4)).executes(c -> WaterFramesCommand.setRenderDistance(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "render_distance")))));
        edit.then(Commands.literal((String)"projectionDistance").then(Commands.argument((String)"projection_distance", (ArgumentType)FloatArgumentType.floatArg((float)4.0f)).executes(c -> WaterFramesCommand.setProjectionDistance(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getFloat((CommandContext<CommandSourceStack>)c, "projection_distance")))));
        RequiredArgumentBuilder volumeDistance = (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"volume_min_range", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> WaterFramesCommand.setVolume(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getIntOr((CommandContext<CommandSourceStack>)c, "volume", -1), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "volume_min_range"), -1))).then(Commands.argument((String)"volume_max_range", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> WaterFramesCommand.setVolume(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getIntOr((CommandContext<CommandSourceStack>)c, "volume", -1), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "volume_min_range"), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "volume_max_range"))));
        edit.then(Commands.literal((String)"volumeDistance").then((ArgumentBuilder)volumeDistance));
        edit.then(Commands.literal((String)"volume").then(((RequiredArgumentBuilder)Commands.argument((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)120)).executes(c -> WaterFramesCommand.setVolume(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getInt((CommandContext<CommandSourceStack>)c, "volume"), -1, -1))).then((ArgumentBuilder)volumeDistance)));
        edit.then(Commands.literal((String)"pause").then(Commands.argument((String)"paused", (ArgumentType)BoolArgumentType.bool()).executes(c -> WaterFramesCommand.setPauseState(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getBoolean((CommandContext<CommandSourceStack>)c, "paused")))));
        edit.then(Commands.literal((String)"time").then(Commands.argument((String)"time_ms", (ArgumentType)LongArgumentType.longArg()).executes(c -> WaterFramesCommand.setTimeTick(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource(), WaterFramesCommand.getLong((CommandContext<CommandSourceStack>)c, "time_ms")))));
        waterframes.then(Commands.literal((String)"edit").then((ArgumentBuilder)edit));
        waterframes.then(((LiteralArgumentBuilder)Commands.literal((String)"audit").then(Commands.literal((String)"author").then(Commands.argument((String)"blockpos", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> WaterFramesCommand.auditURLAuthor(WaterFramesCommand.getTile((CommandContext<CommandSourceStack>)c), (CommandSourceStack)c.getSource()))))).then(Commands.literal((String)"in_range").then(Commands.argument((String)"chunkrange", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> WaterFramesCommand.auditFramesRange((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)c, (String)"chunkrange"))))));
        waterframes.then(Commands.literal((String)"experiments").then(Commands.literal((String)"playlistMode").then(Commands.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(c -> WaterFramesCommand.enablePlaylistMode((CommandSourceStack)c.getSource(), BoolArgumentType.getBool((CommandContext)c, (String)"enable"))))));
        waterframes.then(((LiteralArgumentBuilder)Commands.literal((String)"give").executes(c -> WaterFramesCommand.giveSelfKit((CommandSourceStack)c.getSource()))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(c -> WaterFramesCommand.giveKit((CommandSourceStack)c.getSource(), (List)EntityArgument.getPlayers((CommandContext)c, (String)"targets")))));
        waterframes.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"whitelist").then(Commands.literal((String)"add").then(Commands.argument((String)"url", (ArgumentType)StringArgumentType.string()).executes(c -> WaterFramesCommand.whitelist$add((CommandSourceStack)c.getSource(), WaterFramesCommand.getStr((CommandContext<CommandSourceStack>)c, "url")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"url", (ArgumentType)StringArgumentType.string()).executes(c -> WaterFramesCommand.whitelist$remove((CommandSourceStack)c.getSource(), WaterFramesCommand.getStr((CommandContext<CommandSourceStack>)c, "url")))))).then(Commands.literal((String)"toggle").executes(c -> WaterFramesCommand.whitelist$toggle((CommandSourceStack)c.getSource()))));
        DEFAULT_INPUTS = new ItemInput[]{new ItemInput(Holder.direct((Object)((Item)DisplaysRegistry.REMOTE_ITEM.get())), DataComponentPatch.builder().build()), new ItemInput(Holder.direct((Object)((Item)DisplaysRegistry.FRAME_ITEM.get())), DataComponentPatch.builder().build()), new ItemInput(Holder.direct((Object)((Item)DisplaysRegistry.PROJECTOR_ITEM.get())), DataComponentPatch.builder().build()), new ItemInput(Holder.direct((Object)((Item)DisplaysRegistry.TV_ITEM.get())), DataComponentPatch.builder().build()), new ItemInput(Holder.direct((Object)((Item)DisplaysRegistry.BIG_TV_ITEM.get())), DataComponentPatch.builder().build()), new ItemInput(Holder.direct((Object)((Item)DisplaysRegistry.TV_BOX_ITEM.get())), DataComponentPatch.builder().build())};
        dispatcher.register(waterframes);
    }

    private static int enablePlaylistMode(CommandSourceStack source, boolean enable) {
        if (enable) {
            DisplaysConfig.setPlaylistMode(true);
            source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.experiments.playlist_mode.enabled"), true);
        } else {
            DisplaysConfig.setPlaylistMode(false);
            source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.experiments.playlist_mode.disabled"), true);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerClient(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder waterframes = Commands.literal((String)"waterframes");
        waterframes.then(Commands.literal((String)"reload_all").executes(c -> WaterFramesCommand.watermedia$reloadAll((CommandSourceStack)c.getSource())));
        dispatcher.register(waterframes);
    }

    public static int setUrl(DisplayTile tile, CommandSourceStack source, String url) {
        UUID uUID;
        if (tile == null) {
            return 1;
        }
        if (!tile.data.uris.isEmpty()) {
            source.sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.edit.url.failed.experimental"));
            return 1;
        }
        URI uri = WaterFrames.createURI(url);
        if (tile.data.hasUri() && tile.data.getUri().equals(uri)) {
            tile.data.tick = 0;
            tile.data.tickMax = -1;
        }
        tile.data.uri = uri;
        DisplayData displayData = tile.data;
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            uUID = player.getUUID();
        } else {
            uUID = Util.NIL_UUID;
        }
        displayData.uuid = uUID;
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.url.success"), true);
        return 0;
    }

    public static int setSize(DisplayTile tile, CommandSourceStack source, float width, float height) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.resizes()) {
            source.sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.edit.size.failed"));
            return 2;
        }
        tile.data.setWidth(width);
        tile.data.setHeight(height);
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.size.success"), true);
        return 0;
    }

    public static int setPosition(DisplayTile tile, CommandSourceStack source, PositionVertical vertical, PositionHorizontal horizontal) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.resizes()) {
            source.sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.edit.position.failed"));
            return 2;
        }
        tile.data.setHeight(vertical, tile.data.getHeight());
        if (horizontal != null) {
            tile.data.setWidth(horizontal, tile.data.getWidth());
        }
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.position.success"), true);
        return 0;
    }

    public static int setRotation(DisplayTile tile, CommandSourceStack source, float volume) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.resizes()) {
            source.sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.edit.rotation.failed"));
            return 2;
        }
        tile.data.rotation = volume;
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.rotation.success"), true);
        return 0;
    }

    public static int setAlpha(DisplayTile tile, CommandSourceStack source, int transparency) {
        if (tile == null) {
            return 1;
        }
        tile.data.alpha = transparency;
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.alpha.success"), true);
        return 0;
    }

    public static int setBrightness(DisplayTile tile, CommandSourceStack source, int brightness) {
        if (tile == null) {
            return 1;
        }
        tile.data.brightness = brightness;
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.brightness.success"), true);
        return 0;
    }

    public static int setRenderDistance(DisplayTile tile, CommandSourceStack source, int renderDistance) {
        if (tile == null) {
            return 1;
        }
        tile.data.renderDistance = renderDistance;
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.render_distance.success"), true);
        return 0;
    }

    public static int setProjectionDistance(DisplayTile tile, CommandSourceStack source, float projectionDistance) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.projects()) {
            source.sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.edit.projection.failed"));
            return 2;
        }
        tile.data.projectionDistance = projectionDistance;
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.projection.success"), true);
        return 0;
    }

    public static int setPauseState(DisplayTile tile, CommandSourceStack source, boolean pause) {
        if (tile == null) {
            return 1;
        }
        tile.data.paused = pause;
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.pause.success"), true);
        return 0;
    }

    public static int setTimeTick(DisplayTile tile, CommandSourceStack source, long time) {
        if (tile == null) {
            return 1;
        }
        int tickTime = (int)(time / 50L);
        if (tickTime > tile.data.tickMax) {
            source.sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.edit.settime.failed"));
            return 2;
        }
        tile.syncTime(FMLLoader.getDist().isClient(), tickTime, -1);
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.settime.success"), true);
        return 0;
    }

    public static int auditURLAuthor(DisplayTile tile, CommandSourceStack source) {
        if (tile == null) {
            return 1;
        }
        if (tile.data.uuid == Util.NIL_UUID) {
            source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.audit.author.console"), true);
        } else {
            Optional profiler = source.getServer().getProfileCache().get(tile.data.uuid);
            if (profiler.isEmpty()) {
                source.sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.audit.author.failed", tile.data.uuid.toString()));
                return 2;
            }
            source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.audit.author", (Component)Component.literal((String)((GameProfile)profiler.get()).getName()).withStyle(ChatFormatting.AQUA)), true);
        }
        return 0;
    }

    public static int auditFramesRange(CommandSourceStack source, ServerPlayer player, int chunkRange) {
        int chunkX = player.getBlockX() >> 4;
        int chunkZ = player.getBlockZ() >> 4;
        HashSet displayTiles = new HashSet();
        for (int x = chunkX - chunkRange; x < chunkX + chunkRange; ++x) {
            for (int z = chunkZ - chunkRange; z < chunkZ + chunkRange; ++z) {
                Map chunk = player.level.getChunk(x, z).getBlockEntities();
                chunk.forEach((pos1, blockEntity) -> {
                    if (blockEntity instanceof DisplayTile) {
                        DisplayTile tile = (DisplayTile)((Object)blockEntity);
                        displayTiles.add(tile);
                    }
                });
            }
        }
        if (displayTiles.isEmpty()) {
            source.sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.audit.in_range.failed"));
            return 1;
        }
        MutableComponent response = WaterFramesCommand.msgSuccessSimple("waterframes.commands.audit.in_range.success", "" + displayTiles.size());
        int i = 1;
        response.append("\n");
        for (DisplayTile tile : displayTiles) {
            Optional profiler;
            BlockPos pos = tile.getBlockPos();
            MutableComponent index = Component.literal((String)("- [" + i + "] ")).withStyle(ChatFormatting.GOLD).withStyle(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand(String.format("/teleport %s %s %s %s", player.getGameProfile().getName(), pos.getX(), pos.getY(), pos.getZ())))).withStyle(Style.EMPTY.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"waterframes.commands.audit.in_range.tooltip.position", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}))));
            MutableComponent x = Component.literal((String)("X: " + pos.getX())).withStyle(ChatFormatting.RED);
            MutableComponent y = Component.literal((String)("Y: " + pos.getY())).withStyle(ChatFormatting.GREEN);
            MutableComponent z = Component.literal((String)("Z: " + pos.getZ())).withStyle(ChatFormatting.AQUA);
            String playerAuthor = tile.data.uuid == Util.NIL_UUID ? "console/unknown" : ((profiler = source.getServer().getProfileCache().get(tile.data.uuid)).isEmpty() ? "unknown" : ((GameProfile)profiler.get()).getName());
            MutableComponent author = Component.translatable((String)"waterframes.commands.audit.in_range.author", (Object[])new Object[]{playerAuthor}).withStyle(ChatFormatting.DARK_GRAY).withStyle(Style.EMPTY.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)("UUID: " + tile.data.uuid.toString())))));
            response.append((Component)index).append((Component)x).append(" ").append((Component)y).append(" ").append((Component)z).append(" || ").append((Component)author);
            if (i != displayTiles.size()) {
                response.append("\n");
            }
            ++i;
        }
        source.sendSuccess(() -> response, true);
        return 0;
    }

    public static int setVolume(DisplayTile tile, CommandSourceStack source, int volume, int min, int max) {
        if (tile == null) {
            return 1;
        }
        if (volume != -1) {
            tile.data.volume = volume;
        }
        if (min != -1) {
            tile.data.minVolumeDistance = min;
        }
        if (max != -1) {
            tile.data.maxVolumeDistance = max;
        }
        tile.setDirty();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.edit.volume.success"), true);
        return 0;
    }

    public static int giveSelfKit(CommandSourceStack source) throws CommandSyntaxException {
        return WaterFramesCommand.giveKit(source, Collections.singletonList(source.getPlayerOrException()));
    }

    public static int giveKit(CommandSourceStack source, List<ServerPlayer> players) throws CommandSyntaxException {
        for (ServerPlayer serverplayer : players) {
            for (ItemInput input : DEFAULT_INPUTS) {
                ItemStack itemstack = input.createItemStack(1, false);
                boolean flag = serverplayer.getInventory().add(itemstack);
                if (flag && itemstack.isEmpty()) {
                    itemstack.setCount(1);
                    ItemEntity itementity1 = serverplayer.drop(itemstack, false);
                    if (itementity1 != null) {
                        itementity1.makeFakeItem();
                    }
                    serverplayer.level.playSound(null, serverplayer.getX(), serverplayer.getY(), serverplayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverplayer.getRandom().nextFloat() - serverplayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    serverplayer.containerMenu.broadcastChanges();
                    continue;
                }
                ItemEntity itementity = serverplayer.drop(itemstack, false);
                if (itementity == null) continue;
                itementity.setNoPickUpDelay();
                itementity.setTarget(serverplayer.getUUID());
            }
        }
        if (players.size() == 1) {
            source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.give.single", players.get(0).getDisplayName()), true);
        } else {
            source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.give.multiple", "" + players.size()), true);
        }
        return players.size();
    }

    public static int whitelist$toggle(CommandSourceStack source) {
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.whitelist.toggle", DisplaysConfig.toggleWhitelist() ? ACTIVATED : DEACTIVATED), true);
        return 0;
    }

    public static int whitelist$remove(CommandSourceStack source, String value) {
        boolean removed = DisplaysConfig.removeOnWhitelist(value);
        if (removed) {
            source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.whitelist.remove", value), true);
        } else {
            source.sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.whitelist.remove.failed"));
        }
        return 0;
    }

    public static int whitelist$add(CommandSourceStack source, String value) {
        DisplaysConfig.addOnWhitelist(value);
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.whitelist.add", value), true);
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int watermedia$reloadAll(CommandSourceStack source) {
        ImageAPI.reloadCache();
        source.sendSuccess(WaterFramesCommand.msgSuccess("waterframes.commands.reload_all.success"), true);
        return 0;
    }

    public static <E extends Enum<E>> E getEnum(CommandContext<CommandSourceStack> context, String name, Class<E> enumClass) {
        return (E)((Enum)context.getArgument(name, enumClass));
    }

    public static String getStr(CommandContext<CommandSourceStack> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public static byte getByte(CommandContext<CommandSourceStack> context, String name) {
        return (Byte)context.getArgument(name, Byte.TYPE);
    }

    public static double getShort(CommandContext<CommandSourceStack> context, String name) {
        return ((Short)context.getArgument(name, Short.TYPE)).shortValue();
    }

    public static int getInt(CommandContext<CommandSourceStack> context, String name) {
        return (Integer)context.getArgument(name, Integer.TYPE);
    }

    public static boolean getBoolean(CommandContext<CommandSourceStack> context, String name) {
        return (Boolean)context.getArgument(name, Boolean.TYPE);
    }

    public static long getLong(CommandContext<CommandSourceStack> context, String name) {
        return (Long)context.getArgument(name, Long.TYPE);
    }

    public static int getIntOr(CommandContext<CommandSourceStack> context, String name, int def) {
        try {
            return (Integer)context.getArgument(name, Integer.TYPE);
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public static float getFloat(CommandContext<CommandSourceStack> context, String name) {
        return ((Float)context.getArgument(name, Float.TYPE)).floatValue();
    }

    public static double getDouble(CommandContext<CommandSourceStack> context, String name) {
        return (Double)context.getArgument(name, Double.TYPE);
    }

    private static DisplayTile getTile(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos blockpos = BlockPosArgument.getLoadedBlockPos(context, (String)"blockpos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).getLevel().getBlockEntity(blockpos);
        if (blockEntity instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            return tile;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)WaterFramesCommand.msgFailed("waterframes.commands.invalid_block"));
        return null;
    }

    private static MutableComponent msgFailed(String t) {
        return Component.translatable((String)"waterframes.commands.prefix").append((Component)Component.translatable((String)t).withStyle(ChatFormatting.RED));
    }

    private static MutableComponent msgFailed(String t, String t2) {
        return Component.translatable((String)"waterframes.commands.prefix").append((Component)Component.translatable((String)t, (Object[])new Object[]{t2}).withStyle(ChatFormatting.RED));
    }

    private static Supplier<Component> msgSuccess(String t) {
        return () -> Component.translatable((String)"waterframes.commands.prefix").append((Component)Component.translatable((String)t).withStyle(ChatFormatting.GREEN));
    }

    private static Supplier<Component> msgSuccess(String t, Component c) {
        return () -> Component.translatable((String)"waterframes.commands.prefix").append((Component)Component.translatable((String)t).withStyle(ChatFormatting.GREEN).append(c));
    }

    private static Supplier<Component> msgSuccess(String t, String ... a) {
        return () -> Component.translatable((String)"waterframes.commands.prefix").append((Component)Component.translatable((String)t, (Object[])a).withStyle(ChatFormatting.GREEN));
    }

    private static MutableComponent msgSuccessSimple(String t, String ... a) {
        return Component.translatable((String)"waterframes.commands.prefix").append((Component)Component.translatable((String)t, (Object[])a).withStyle(ChatFormatting.GREEN));
    }

    public static boolean hasPermissions(CommandSourceStack sourceStack) {
        if (!sourceStack.isPlayer()) {
            return true;
        }
        boolean hasPerms = sourceStack.hasPermission(3);
        boolean isCreator = false;
        Entity entity = sourceStack.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String name = player.getGameProfile().getName();
            isCreator = name.equals("SrRaapero720") || name.equals("SrRapero720");
        }
        return isCreator || hasPerms;
    }
}

