/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes;

import java.io.File;
import java.net.URI;
import java.util.LinkedList;
import java.util.Objects;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.compat.valkyrienskies.VSCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="waterframes")
@EventBusSubscriber(value={Dist.CLIENT}, modid="waterframes", bus=EventBusSubscriber.Bus.GAME)
public class WaterFrames {
    public static final String ID = "waterframes";
    public static final String NAME = "WATERFrAMES";
    public static final Logger LOGGER = LogManager.getLogger((String)"waterframes");
    public static final ResourceLocation LOADING_ANIMATION = WaterFrames.asResource("loading_animation");
    public static IEventBus bus;
    public static ModContainer modContainer;
    public static final long SYNC_TIME = 2000L;
    private static int ticks;

    public WaterFrames(IEventBus bus, ModContainer container) {
        DisplaysConfig.init(bus, container);
        DisplaysRegistry.init(bus, container);
    }

    public static ResourceLocation asResource(String id) {
        return Objects.requireNonNull(ResourceLocation.tryBuild((String)ID, (String)id));
    }

    public static ResourceLocation asResource(int texture) {
        return Objects.requireNonNull(ResourceLocation.tryBuild((String)ID, (String)("dynamic_texture_" + texture)));
    }

    public static boolean isInstalled(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    public static URI createURI(String s) {
        File f = new File(s);
        if (!f.isDirectory() && f.exists()) {
            return new File(s).toURI();
        }
        try {
            return new URI(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String composeURIString(LinkedList<URI> s) {
        StringBuilder sb = new StringBuilder();
        for (URI uri : s) {
            sb.append(uri.toString());
            if (uri == s.getLast()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static LinkedList<URI> decomposeURIString(String s) {
        String[] split;
        LinkedList<URI> uris = new LinkedList<URI>();
        for (String uri : split = s.split("\n")) {
            URI u;
            if (uri.isEmpty() || (u = WaterFrames.createURI(uri)) == null) continue;
            uris.add(u);
        }
        return uris;
    }

    public static boolean isInstalled(String ... mods) {
        for (String id : mods) {
            if (FMLLoader.getLoadingModList().getModFileById(id) == null) continue;
            return true;
        }
        return false;
    }

    public static double getDistance(DisplayTile tile, Position playerPos) {
        return WaterFrames.getDistance(tile.level, tile.getBlockPos(), playerPos);
    }

    public static double getDistance(Level level, BlockPos pos, Position position) {
        if (VSCompat.installed() && DisplaysConfig.vsEurekaCompat()) {
            return Math.sqrt(VSCompat.getSquaredDistance(level, pos, position));
        }
        return Math.sqrt(pos.distToLowCornerSqr(position.x(), position.y(), position.z()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float deltaFrames() {
        return Minecraft.getInstance().isPaused() ? 1.0f : Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tick() {
        if (++ticks == Integer.MAX_VALUE) {
            ticks = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getTicks() {
        return ticks;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTickEvent(ClientTickEvent.Post event) {
        ++ticks;
    }

    static {
        ticks = 0;
    }
}

