/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block.entity;

import java.net.URI;
import java.util.concurrent.Executor;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.Display;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.data.DisplayCaps;
import me.srrapero720.waterframes.common.block.data.DisplayData;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.ActivePacket;
import me.srrapero720.waterframes.common.network.packets.LoopPacket;
import me.srrapero720.waterframes.common.network.packets.MutePacket;
import me.srrapero720.waterframes.common.network.packets.NextPacket;
import me.srrapero720.waterframes.common.network.packets.PausePacket;
import me.srrapero720.waterframes.common.network.packets.PositionPacket;
import me.srrapero720.waterframes.common.network.packets.PreviousPacket;
import me.srrapero720.waterframes.common.network.packets.TimePacket;
import me.srrapero720.waterframes.common.network.packets.VolumePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageCache;
import org.watermedia.api.math.MathAPI;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;

@EventBusSubscriber(modid="waterframes", bus=EventBusSubscriber.Bus.GAME)
public class DisplayTile
extends BlockEntity {
    private static int lagTickTime;
    private static int lagTickCompensate;
    public final DisplayData data;
    public final DisplayCaps caps;
    @OnlyIn(value=Dist.CLIENT)
    public ImageCache imageCache;
    @OnlyIn(value=Dist.CLIENT)
    public Display display;
    @OnlyIn(value=Dist.CLIENT)
    private boolean isReleased;
    private int lightLevel = 0;
    private int analogRedstoneLevel = 0;

    public DisplayTile(DisplayData data, DisplayCaps caps, BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.data = data;
        this.caps = caps;
    }

    public static void setLagTickTime(long ltt) {
        if (ltt < 60000L) {
            lagTickTime = (int)(ltt / 50L);
        } else {
            WaterFrames.LOGGER.warn("Rejected tick correction of {}ms, overpass watchdog time", (Object)ltt);
        }
    }

    public static void clearLagTickTime() {
        lagTickCompensate += lagTickTime;
        lagTickTime = 0;
    }

    @SubscribeEvent
    public static void onTickLast(ServerTickEvent.Post e) {
        DisplayTile.clearLagTickTime();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Display activeDisplay() {
        return this.display;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Display requestDisplay() {
        if (!this.data.active || !this.data.hasUri() && this.display != null) {
            this.cleanDisplay();
            return null;
        }
        if (this.isReleased) {
            this.imageCache = null;
            return null;
        }
        if (this.imageCache == null && !this.data.hasUri()) {
            this.cleanDisplay();
            return null;
        }
        if (this.imageCache == null || this.data.hasUri() && !this.imageCache.uri.equals(this.data.getUri())) {
            this.imageCache = ImageAPI.getCache((URI)this.data.getUri(), (Executor)Minecraft.getInstance());
            this.cleanDisplay();
        }
        switch (this.imageCache.getStatus()) {
            case LOADING: 
            case FAILED: 
            case READY: {
                if (this.display != null) {
                    return this.display;
                }
                this.display = new Display(this);
                return this.display;
            }
            case WAITING: {
                this.cleanDisplay();
                this.imageCache.load();
                return this.display;
            }
            case FORGOTTEN: {
                WaterFrames.LOGGER.warn("Cached picture is forgotten, cleaning and reloading");
                this.imageCache = null;
                return null;
            }
        }
        WaterFrames.LOGGER.warn("WATERMeDIA Behavior is modified, this shouldn't be executed");
        return null;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        this.data.save(nbt, this);
        super.saveAdditional(nbt, registries);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        this.data.load(nbt, this);
        super.loadAdditional(nbt, registries);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cleanDisplay() {
        if (this.display != null) {
            this.display.release();
            this.display = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void release() {
        this.cleanDisplay();
        this.isReleased = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AlignedBox getRenderBox() {
        return this.caps.getBox(this, this.getDirection(), this.getAttachedFace(), true);
    }

    public void setRemoved() {
        if (this.isClient()) {
            this.release();
        }
        super.setRemoved();
    }

    public void onChunkUnloaded() {
        if (this.isClient()) {
            this.release();
        }
        super.onChunkUnloaded();
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public int getAnalogOutput() {
        return this.analogRedstoneLevel;
    }

    private int getLightLevel$internal() {
        return !this.data.hasUri() ? 0 : (int)((float)this.data.brightness / 255.0f * (float)this.level.getMaxLightLevel());
    }

    private int getAnalogOutput$internal() {
        if (this.data.tickMax > 0 && this.data.active) {
            return Math.round((float)this.data.tick / (float)this.data.tickMax * 14.0f) + 1;
        }
        return 0;
    }

    public void setActive(boolean clientSide, boolean mode) {
        if (clientSide) {
            DisplayNetwork.sendServer(new ActivePacket(this.getBlockPos(), mode, true));
        } else {
            DisplayNetwork.sendClient(new ActivePacket(this.getBlockPos(), mode, true), this);
        }
    }

    public void setMute(boolean clientSide, boolean mode) {
        if (clientSide) {
            DisplayNetwork.sendServer(new MutePacket(this.getBlockPos(), mode, true));
        } else {
            DisplayNetwork.sendClient(new MutePacket(this.getBlockPos(), mode, true), this);
        }
    }

    public void setPause(boolean clientSide, boolean pause) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PausePacket(this.getBlockPos(), pause, this.data.tick, true));
        } else {
            DisplayNetwork.sendClient(new PausePacket(this.getBlockPos(), pause, this.data.tick, true), this);
        }
    }

    public void setStop(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PausePacket(this.getBlockPos(), true, 0, true));
        } else {
            DisplayNetwork.sendClient(new PausePacket(this.getBlockPos(), true, 0, true), this);
        }
    }

    public void volumeUp(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new VolumePacket(this.getBlockPos(), this.data.volume + 5, true));
        } else {
            DisplayNetwork.sendClient(new VolumePacket(this.getBlockPos(), this.data.volume + 5, true), this);
        }
    }

    public void volumeDown(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new VolumePacket(this.getBlockPos(), this.data.volume - 5, true));
        } else {
            DisplayNetwork.sendClient(new VolumePacket(this.getBlockPos(), this.data.volume - 5, true), this);
        }
    }

    public void fastFoward(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new TimePacket(this.getBlockPos(), Math.min(this.data.tick + MathAPI.msToTick((long)5000L), this.data.tickMax), this.data.tickMax, true));
        } else {
            DisplayNetwork.sendClient(new TimePacket(this.getBlockPos(), Math.min(this.data.tick + 100, this.data.tickMax), this.data.tickMax, true), this);
        }
    }

    public void rewind(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new TimePacket(this.getBlockPos(), Math.max(this.data.tick - MathAPI.msToTick((long)5000L), 0), this.data.tickMax, true));
        } else {
            DisplayNetwork.sendClient(new TimePacket(this.getBlockPos(), Math.max(this.data.tick - 100, 0), this.data.tickMax, true), this);
        }
    }

    public void nextUri(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new NextPacket(this.getBlockPos(), true));
        } else {
            DisplayNetwork.sendClient(new NextPacket(this.getBlockPos(), true), this);
        }
    }

    public void prevUri(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PreviousPacket(this.getBlockPos(), true));
        } else {
            DisplayNetwork.sendClient(new PreviousPacket(this.getBlockPos(), true), this);
        }
    }

    public void syncTime(boolean clientSide, int tick, int maxTick) {
        if (clientSide) {
            DisplayNetwork.sendServer(new TimePacket(this.getBlockPos(), tick, maxTick, true));
        } else {
            DisplayNetwork.sendClient(new TimePacket(this.getBlockPos(), tick, maxTick, true), this);
        }
    }

    public void loop(boolean clientSide, boolean loop) {
        if (clientSide) {
            DisplayNetwork.sendServer(new LoopPacket(this.getBlockPos(), loop, true));
        } else {
            DisplayNetwork.sendClient(new LoopPacket(this.getBlockPos(), loop, true), this);
        }
    }

    public void position(boolean clientSide, PositionHorizontal horizontal, PositionVertical vertical) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PositionPacket(this.getBlockPos(), horizontal, vertical, true));
        } else {
            DisplayNetwork.sendClient(new PositionPacket(this.getBlockPos(), horizontal, vertical, true), this);
        }
    }

    public void tick(BlockState state) {
        Display display;
        if (this.data.tickMax == -1 || this.data.tick < 0) {
            this.data.tick = 0;
        }
        if (!this.data.paused && this.data.active) {
            if (this.data.tick < this.data.tickMax) {
                if (lagTickCompensate <= 0) {
                    ++this.data.tick;
                } else {
                    --lagTickCompensate;
                }
                if (lagTickTime != 0 && this.isServer()) {
                    int ticks;
                    for (ticks = this.data.tick + lagTickTime; ticks > this.data.tickMax; ticks -= this.data.tickMax) {
                    }
                    this.data.tick = ticks;
                    this.setDirty();
                }
            } else {
                if (this.data.loop || this.data.tickMax == -1) {
                    this.data.tick = 0;
                }
                if (!this.data.loop && this.data.tickMax != -1) {
                    this.data.nextUri();
                }
            }
        }
        boolean refresh = false;
        int redstoneLevel = this.getAnalogOutput$internal();
        if (this.analogRedstoneLevel != redstoneLevel) {
            this.analogRedstoneLevel = redstoneLevel;
            refresh = true;
        }
        boolean lightOnPlay = DisplaysConfig.forceLightOnPlay() || DisplaysConfig.useLightOnPlay() && this.data.lit;
        int calculatedLight = this.getLightLevel$internal();
        if (lightOnPlay && this.lightLevel != calculatedLight) {
            this.lightLevel = calculatedLight;
            refresh = true;
        }
        if (refresh) {
            this.level.getChunkSource().getLightEngine().checkBlock(this.getBlockPos());
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        }
        if (this.isClient() && (display = this.requestDisplay()) != null && display.canTick()) {
            display.tick();
        }
    }

    public boolean isClient() {
        return this.level != null && this.level.isClientSide;
    }

    public boolean isServer() {
        return this.level != null && !this.level.isClientSide;
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)this.getDisplayBlock().getFacing());
    }

    public Direction getAttachedFace() {
        return (Direction)this.getBlockState().getValue((Property)DisplayBlock.ATTACHED_FACE);
    }

    public boolean canHideModel() {
        return this.getBlockState().hasProperty((Property)DisplayBlock.VISIBLE);
    }

    public boolean isVisible() {
        return (Boolean)this.getBlockState().getValue((Property)DisplayBlock.VISIBLE);
    }

    public void setVisibility(boolean visible) {
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)DisplayBlock.VISIBLE, (Comparable)Boolean.valueOf(visible)), 2);
    }

    public DisplayBlock getDisplayBlock() {
        return (DisplayBlock)this.getBlockState().getBlock();
    }

    public boolean isPowered() {
        return (Boolean)this.getBlockState().getValue((Property)DisplayBlock.POWERED);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.data.load(tag, this);
        this.setDirty();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return super.saveWithFullMetadata(pRegistries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setDirty() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public static AlignedBox getBasicBox(DisplayTile tile) {
        Facing facing = Facing.get((Direction)tile.getDirection());
        AlignedBox box = new AlignedBox();
        if (facing.positive) {
            box.setMax(facing.axis, tile.data.projectionDistance);
        } else {
            box.setMin(facing.axis, 1.0f - tile.data.projectionDistance);
        }
        Axis one = facing.one();
        Axis two = facing.two();
        if (facing.axis != Axis.Z) {
            one = facing.two();
            two = facing.one();
        }
        box.setMin(one, tile.data.min.x);
        box.setMax(one, tile.data.max.x);
        box.setMin(two, tile.data.min.y);
        box.setMax(two, tile.data.max.y);
        if (tile.caps.projects() && (facing.toVanilla() == Direction.NORTH || facing.toVanilla() == Direction.EAST)) {
            switch (tile.data.getPosX()) {
                case LEFT: {
                    box.setMin(one, 1.0f - tile.data.getWidth());
                    box.setMax(one, 1.0f);
                    break;
                }
                case RIGHT: {
                    box.setMax(one, tile.data.getWidth());
                    box.setMin(one, 0.0f);
                }
            }
        }
        if (!(tile.caps.projects() || facing.toVanilla() != Direction.WEST && facing.toVanilla() != Direction.SOUTH)) {
            switch (tile.data.getPosX()) {
                case LEFT: {
                    box.setMin(one, 1.0f - tile.data.getWidth());
                    box.setMax(one, 1.0f);
                    break;
                }
                case RIGHT: {
                    box.setMax(one, tile.data.getWidth());
                    box.setMin(one, 0.0f);
                }
            }
        }
        return box;
    }
}

