/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import java.net.URI;
import java.util.LinkedList;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import me.srrapero720.waterframes.common.screens.styles.ScreenStyles;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;

public class WidgetPlaylistEntry
extends GuiParent {
    public final URI uri;
    public final LinkedList<URI> list;
    public final DisplayTile tile;
    private final GuiButtonIcon reload;
    private boolean added = false;

    public WidgetPlaylistEntry(DisplayTile tile, LinkedList<URI> list, URI uri) {
        super("experimental_element_" + uri.toString());
        this.uri = uri;
        this.tile = tile;
        this.list = list;
        this.setDim(0, 40);
        this.setSpacing(4);
        this.setExpandableX();
        this.setVAlign(VAlign.CENTER);
        this.reload = new GuiButtonIcon("reload", IconStyles.RELOAD, mouse -> {
            if (mouse != 0) {
                return;
            }
            tile.imageCache.reload();
        });
        list.add(uri);
        this.add(new GuiParent("").setDim(4, 1));
        this.add(new GuiLabel("name").setTitle((Component)Component.literal((String)uri.toString().substring(uri.toString().indexOf(uri.getScheme())))).setExpandableX());
        this.add(this.checkReload(), () -> this.reload.setDim(12, 12));
        this.add((GuiControl)new GuiButtonIcon("remove", IconStyles.REMOVE, mouse -> {
            if (mouse != 0) {
                return;
            }
            ((GuiParent)this.getParent()).remove((GuiControl)this);
            list.remove(uri);
            this.getParent().reflow();
        }).setDim(12, 12));
        this.add(new GuiParent("").setDim(4, 1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return this.tile.data.hasUri() && this.tile.data.getUri().equals(this.uri) ? ScreenStyles.DARK_BLUE_HIGHLIGHT : ScreenStyles.DARK_BLUE_BACKGROUND;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double x, double y, int button) {
        if (button == 1) {
            Util.getPlatform().openUri(this.uri);
        }
        return super.mouseClicked(x, y, button);
    }

    public void tick() {
        super.tick();
        if (!this.isClient()) {
            return;
        }
        this.reload.setEnabled(this.checkReload());
        this.reload.setVisible(this.reload.enabled);
    }

    private boolean checkReload() {
        return this.tile.data.hasUri() && this.tile.data.getUri().equals(this.uri);
    }
}

