/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block.entity;

import java.net.URI;
import java.util.concurrent.Executor;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.Display;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.data.DisplayCaps;
import me.srrapero720.waterframes.common.block.data.DisplayData;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.ActivePacket;
import me.srrapero720.waterframes.common.network.packets.LoopPacket;
import me.srrapero720.waterframes.common.network.packets.MutePacket;
import me.srrapero720.waterframes.common.network.packets.NextPacket;
import me.srrapero720.waterframes.common.network.packets.PausePacket;
import me.srrapero720.waterframes.common.network.packets.PositionPacket;
import me.srrapero720.waterframes.common.network.packets.PreviousPacket;
import me.srrapero720.waterframes.common.network.packets.TimePacket;
import me.srrapero720.waterframes.common.network.packets.VolumePacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientBlockEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageCache;
import org.watermedia.api.math.MathAPI;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;

public class DisplayTile
extends class_2586 {
    private static int lagTickTime;
    private static int lagTickCompensate;
    public final DisplayData data;
    public final DisplayCaps caps;
    @Environment(value=EnvType.CLIENT)
    public ImageCache imageCache;
    @Environment(value=EnvType.CLIENT)
    public Display display;
    @Environment(value=EnvType.CLIENT)
    private boolean isReleased;
    private int analogRedstoneLevel = 0;

    public DisplayTile(DisplayData data, DisplayCaps caps, class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        this.data = data;
        this.caps = caps;
    }

    public static void setLagTickTime(long ltt) {
        if (ltt < 60000L) {
            lagTickTime = (int)(ltt / 50L);
        } else {
            WaterFrames.LOGGER.warn("Rejected tick correction of {}ms, overpass watchdog time", (Object)ltt);
        }
    }

    public static void clearLagTickTime() {
        lagTickCompensate += lagTickTime;
        lagTickTime = 0;
    }

    @Environment(value=EnvType.CLIENT)
    public Display activeDisplay() {
        return this.display;
    }

    @Environment(value=EnvType.CLIENT)
    public Display requestDisplay() {
        if (!this.data.active || !this.data.hasUri() && this.display != null) {
            this.cleanDisplay();
            return null;
        }
        if (this.isReleased) {
            this.imageCache = null;
            return null;
        }
        if (this.imageCache == null && !this.data.hasUri()) {
            this.cleanDisplay();
            return null;
        }
        if (this.imageCache == null || this.data.hasUri() && !this.imageCache.uri.equals(this.data.getUri())) {
            this.imageCache = ImageAPI.getCache((URI)this.data.getUri(), (Executor)class_310.method_1551());
            this.cleanDisplay();
        }
        switch (this.imageCache.getStatus()) {
            case LOADING: 
            case FAILED: 
            case READY: {
                if (this.display != null) {
                    return this.display;
                }
                this.display = new Display(this);
                return this.display;
            }
            case WAITING: {
                this.cleanDisplay();
                this.imageCache.load();
                return this.display;
            }
            case FORGOTTEN: {
                WaterFrames.LOGGER.warn("Cached picture is forgotten, cleaning and reloading");
                this.imageCache = null;
                return null;
            }
        }
        WaterFrames.LOGGER.warn("WATERMeDIA Behavior is modified, this shouldn't be executed");
        return null;
    }

    public void method_11007(class_2487 nbt) {
        this.data.save(nbt, this);
        super.method_11007(nbt);
    }

    public void method_11014(class_2487 nbt) {
        this.data.load(nbt, this);
        super.method_11014(nbt);
        this.setDirty();
    }

    @Environment(value=EnvType.CLIENT)
    private void cleanDisplay() {
        if (this.display != null) {
            this.display.release();
            this.display = null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void release() {
        this.cleanDisplay();
        this.isReleased = true;
    }

    @Environment(value=EnvType.CLIENT)
    public AlignedBox getRenderBox() {
        return this.caps.getBox(this, this.getDirection(), this.getAttachedFace(), true);
    }

    @Environment(value=EnvType.CLIENT)
    public class_238 getRenderBoundingBox() {
        return this.getRenderBox().getBB(this.method_11016());
    }

    public void method_11012() {
        if (this.isClient()) {
            this.release();
        }
        super.method_11012();
    }

    public class_2818 getChunk() {
        return this.field_11863.method_8500(this.method_11016());
    }

    public int getAnalogOutput() {
        return this.analogRedstoneLevel;
    }

    private int getLightLevel$internal() {
        return !this.data.hasUri() ? 0 : (int)((float)this.data.brightness / 255.0f * (float)this.field_11863.method_8315());
    }

    private int getAnalogOutput$internal() {
        if (this.data.tickMax > 0 && this.data.active) {
            return Math.round((float)this.data.tick / (float)this.data.tickMax * 14.0f) + 1;
        }
        return 0;
    }

    public void setActive(boolean clientSide, boolean mode) {
        if (clientSide) {
            DisplayNetwork.sendServer(new ActivePacket(this.method_11016(), mode, true));
        } else {
            DisplayNetwork.sendClient(new ActivePacket(this.method_11016(), mode, true), this);
        }
    }

    public void setMute(boolean clientSide, boolean mode) {
        if (clientSide) {
            DisplayNetwork.sendServer(new MutePacket(this.method_11016(), mode, true));
        } else {
            DisplayNetwork.sendClient(new MutePacket(this.method_11016(), mode, true), this);
        }
    }

    public void setPause(boolean clientSide, boolean pause) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PausePacket(this.method_11016(), pause, this.data.tick, true));
        } else {
            DisplayNetwork.sendClient(new PausePacket(this.method_11016(), pause, this.data.tick, true), this);
        }
    }

    public void setStop(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PausePacket(this.method_11016(), true, 0, true));
        } else {
            DisplayNetwork.sendClient(new PausePacket(this.method_11016(), true, 0, true), this);
        }
    }

    public void volumeUp(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new VolumePacket(this.method_11016(), this.data.volume + 5, true));
        } else {
            DisplayNetwork.sendClient(new VolumePacket(this.method_11016(), this.data.volume + 5, true), this);
        }
    }

    public void volumeDown(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new VolumePacket(this.method_11016(), this.data.volume - 5, true));
        } else {
            DisplayNetwork.sendClient(new VolumePacket(this.method_11016(), this.data.volume - 5, true), this);
        }
    }

    public void fastFoward(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new TimePacket(this.method_11016(), Math.min(this.data.tick + MathAPI.msToTick((long)5000L), this.data.tickMax), this.data.tickMax, true));
        } else {
            DisplayNetwork.sendClient(new TimePacket(this.method_11016(), Math.min(this.data.tick + 100, this.data.tickMax), this.data.tickMax, true), this);
        }
    }

    public void rewind(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new TimePacket(this.method_11016(), Math.max(this.data.tick - MathAPI.msToTick((long)5000L), 0), this.data.tickMax, true));
        } else {
            DisplayNetwork.sendClient(new TimePacket(this.method_11016(), Math.max(this.data.tick - 100, 0), this.data.tickMax, true), this);
        }
    }

    public void nextUri(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new NextPacket(this.method_11016(), true));
        } else {
            DisplayNetwork.sendClient(new NextPacket(this.method_11016(), true), this);
        }
    }

    public void prevUri(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PreviousPacket(this.method_11016(), true));
        } else {
            DisplayNetwork.sendClient(new PreviousPacket(this.method_11016(), true), this);
        }
    }

    public void syncTime(boolean clientSide, int tick, int maxTick) {
        if (clientSide) {
            DisplayNetwork.sendServer(new TimePacket(this.method_11016(), tick, maxTick, true));
        } else {
            DisplayNetwork.sendClient(new TimePacket(this.method_11016(), tick, maxTick, true), this);
        }
    }

    public void loop(boolean clientSide, boolean loop) {
        if (clientSide) {
            DisplayNetwork.sendServer(new LoopPacket(this.method_11016(), loop, true));
        } else {
            DisplayNetwork.sendClient(new LoopPacket(this.method_11016(), loop, true), this);
        }
    }

    public void position(boolean clientSide, PositionHorizontal horizontal, PositionVertical vertical) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PositionPacket(this.method_11016(), horizontal, vertical, true));
        } else {
            DisplayNetwork.sendClient(new PositionPacket(this.method_11016(), horizontal, vertical, true), this);
        }
    }

    public void tick(class_2680 state) {
        Display display;
        if (this.data.tickMax == -1 || this.data.tick < 0) {
            this.data.tick = 0;
        }
        if (!this.data.paused && this.data.active) {
            if (this.data.tick < this.data.tickMax) {
                if (lagTickCompensate <= 0) {
                    ++this.data.tick;
                } else {
                    --lagTickCompensate;
                }
                if (lagTickTime != 0 && this.isServer()) {
                    int ticks;
                    for (ticks = this.data.tick + lagTickTime; ticks > this.data.tickMax; ticks -= this.data.tickMax) {
                    }
                    this.data.tick = ticks;
                    this.setDirty();
                }
            } else {
                if (this.data.loop || this.data.tickMax == -1) {
                    this.data.tick = 0;
                }
                if (!this.data.loop && this.data.tickMax != -1) {
                    this.data.nextUri();
                }
            }
        }
        boolean refresh = false;
        int redstoneLevel = this.getAnalogOutput$internal();
        if (this.analogRedstoneLevel != redstoneLevel) {
            this.analogRedstoneLevel = redstoneLevel;
            refresh = true;
        }
        boolean lightOnPlay = DisplaysConfig.forceLightOnPlay() || DisplaysConfig.useLightOnPlay() && this.data.lit;
        int calculatedLight = this.getLightLevel$internal();
        int currentLight = (Integer)state.method_11654((class_2769)DisplayBlock.LIGHT_LEVEL);
        if (lightOnPlay && currentLight != calculatedLight) {
            state = (class_2680)state.method_11657((class_2769)DisplayBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(calculatedLight));
            refresh = true;
        }
        if (refresh) {
            this.field_11863.method_8652(this.method_11016(), state, 3);
            this.field_11863.method_8452(this.method_11016(), this.method_11010().method_26204());
        }
        if (this.isClient() && (display = this.requestDisplay()) != null && display.canTick()) {
            display.tick();
        }
    }

    public boolean isClient() {
        return this.field_11863 != null && this.field_11863.field_9236;
    }

    public boolean isServer() {
        return this.field_11863 != null && !this.field_11863.field_9236;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)this.getDisplayBlock().getFacing());
    }

    public class_2350 getAttachedFace() {
        return (class_2350)this.method_11010().method_11654((class_2769)DisplayBlock.ATTACHED_FACE);
    }

    public boolean canHideModel() {
        return this.method_11010().method_28498((class_2769)DisplayBlock.VISIBLE);
    }

    public boolean isVisible() {
        return (Boolean)this.method_11010().method_11654((class_2769)DisplayBlock.VISIBLE);
    }

    public void setVisibility(boolean visible) {
        this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)DisplayBlock.VISIBLE, (Comparable)Boolean.valueOf(visible)), 2);
    }

    public DisplayBlock getDisplayBlock() {
        return (DisplayBlock)this.method_11010().method_26204();
    }

    public boolean isPowered() {
        return (Boolean)this.method_11010().method_11654((class_2769)DisplayBlock.POWERED);
    }

    public class_2487 method_16887() {
        return this.method_38242();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void setDirty() {
        if (this.field_11863 != null) {
            this.field_11863.method_8524(this.method_11016());
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public static AlignedBox getBasicBox(DisplayTile tile) {
        Facing facing = Facing.get((class_2350)tile.getDirection());
        AlignedBox box = new AlignedBox();
        if (facing.positive) {
            box.setMax(facing.axis, tile.data.projectionDistance);
        } else {
            box.setMin(facing.axis, 1.0f - tile.data.projectionDistance);
        }
        Axis one = facing.one();
        Axis two = facing.two();
        if (facing.axis != Axis.Z) {
            one = facing.two();
            two = facing.one();
        }
        box.setMin(one, tile.data.min.x);
        box.setMax(one, tile.data.max.x);
        box.setMin(two, tile.data.min.y);
        box.setMax(two, tile.data.max.y);
        if (tile.caps.projects() && (facing.toVanilla() == class_2350.field_11043 || facing.toVanilla() == class_2350.field_11034)) {
            switch (tile.data.getPosX()) {
                case LEFT: {
                    box.setMin(one, 1.0f - tile.data.getWidth());
                    box.setMax(one, 1.0f);
                    break;
                }
                case RIGHT: {
                    box.setMax(one, tile.data.getWidth());
                    box.setMin(one, 0.0f);
                }
            }
        }
        if (!(tile.caps.projects() || facing.toVanilla() != class_2350.field_11039 && facing.toVanilla() != class_2350.field_11035)) {
            switch (tile.data.getPosX()) {
                case LEFT: {
                    box.setMin(one, 1.0f - tile.data.getWidth());
                    box.setMax(one, 1.0f);
                    break;
                }
                case RIGHT: {
                    box.setMax(one, tile.data.getWidth());
                    box.setMin(one, 0.0f);
                }
            }
        }
        return box;
    }

    public static void initCommon() {
        ServerTickEvents.END_SERVER_TICK.register(server -> DisplayTile.clearLagTickTime());
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((blockEntity, world) -> {
            if (blockEntity instanceof DisplayTile) {
                DisplayTile tile = (DisplayTile)blockEntity;
                tile.release();
            }
        });
    }
}

