/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.data.DisplayData;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.commands.arguments.EnumArgument;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2290;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.api.image.ImageAPI;

public class WaterFramesCommand {
    private static final Marker IT = MarkerManager.getMarker((String)"Commands");
    public static final class_2561 ACTIVATED = class_2561.method_43471((String)"waterframes.common.activated");
    public static final class_2561 DEACTIVATED = class_2561.method_43471((String)"waterframes.common.deactivated");
    public static class_2290[] DEFAULT_INPUTS = new class_2290[0];

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder waterframes = (LiteralArgumentBuilder)class_2170.method_9247((String)"waterframes").requires(WaterFramesCommand::hasPermissions);
        RequiredArgumentBuilder edit = class_2170.method_9244((String)"blockpos", (ArgumentType)class_2262.method_9698());
        edit.then(class_2170.method_9247((String)"url").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(c -> WaterFramesCommand.setUrl(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getStr((CommandContext<class_2168>)c, "url")))));
        LiteralArgumentBuilder position = (LiteralArgumentBuilder)class_2170.method_9247((String)"position").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"vertical", EnumArgument.enumArgument(PositionVertical.class)).executes(c -> WaterFramesCommand.setPosition(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getEnum((CommandContext<class_2168>)c, "vertical", PositionVertical.class), null))).then(class_2170.method_9244((String)"horizontal", EnumArgument.enumArgument(PositionHorizontal.class)).executes(c -> WaterFramesCommand.setPosition(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getEnum((CommandContext<class_2168>)c, "vertical", PositionVertical.class), WaterFramesCommand.getEnum((CommandContext<class_2168>)c, "horizontal", PositionHorizontal.class)))));
        edit.then((ArgumentBuilder)position);
        edit.then(class_2170.method_9247((String)"size").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"width", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(c -> WaterFramesCommand.setSize(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getFloat((CommandContext<class_2168>)c, "width"), -1.0f))).then(class_2170.method_9244((String)"height", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(c -> WaterFramesCommand.setSize(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getFloat((CommandContext<class_2168>)c, "width"), WaterFramesCommand.getFloat((CommandContext<class_2168>)c, "height"))))));
        edit.then(class_2170.method_9247((String)"rotation").then(class_2170.method_9244((String)"rotation", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)360.0f)).executes(c -> WaterFramesCommand.setRotation(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getFloat((CommandContext<class_2168>)c, "rotation")))));
        edit.then(class_2170.method_9247((String)"alpha").then(class_2170.method_9244((String)"alpha", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(c -> WaterFramesCommand.setAlpha(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getInt((CommandContext<class_2168>)c, "alpha")))));
        edit.then(class_2170.method_9247((String)"brightness").then(class_2170.method_9244((String)"brightness", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(c -> WaterFramesCommand.setBrightness(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getInt((CommandContext<class_2168>)c, "brightness")))));
        edit.then(class_2170.method_9247((String)"renderDistance").then(class_2170.method_9244((String)"render_distance", (ArgumentType)IntegerArgumentType.integer((int)4)).executes(c -> WaterFramesCommand.setRenderDistance(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getInt((CommandContext<class_2168>)c, "render_distance")))));
        edit.then(class_2170.method_9247((String)"projectionDistance").then(class_2170.method_9244((String)"projection_distance", (ArgumentType)FloatArgumentType.floatArg((float)4.0f)).executes(c -> WaterFramesCommand.setProjectionDistance(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getFloat((CommandContext<class_2168>)c, "projection_distance")))));
        RequiredArgumentBuilder volumeDistance = (RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"volume_min_range", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> WaterFramesCommand.setVolume(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getIntOr((CommandContext<class_2168>)c, "volume", -1), WaterFramesCommand.getInt((CommandContext<class_2168>)c, "volume_min_range"), -1))).then(class_2170.method_9244((String)"volume_max_range", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> WaterFramesCommand.setVolume(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getIntOr((CommandContext<class_2168>)c, "volume", -1), WaterFramesCommand.getInt((CommandContext<class_2168>)c, "volume_min_range"), WaterFramesCommand.getInt((CommandContext<class_2168>)c, "volume_max_range"))));
        edit.then(class_2170.method_9247((String)"volumeDistance").then((ArgumentBuilder)volumeDistance));
        edit.then(class_2170.method_9247((String)"volume").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)120)).executes(c -> WaterFramesCommand.setVolume(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource(), WaterFramesCommand.getInt((CommandContext<class_2168>)c, "volume"), -1, -1))).then((ArgumentBuilder)volumeDistance)));
        waterframes.then(class_2170.method_9247((String)"edit").then((ArgumentBuilder)edit));
        waterframes.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"audit").then(class_2170.method_9247((String)"author").then(class_2170.method_9244((String)"blockpos", (ArgumentType)class_2262.method_9698()).executes(c -> WaterFramesCommand.auditURLAuthor(WaterFramesCommand.getTile((CommandContext<class_2168>)c), (class_2168)c.getSource()))))).then(class_2170.method_9247((String)"in_range").then(class_2170.method_9244((String)"chunkrange", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> WaterFramesCommand.auditFramesRange((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), IntegerArgumentType.getInteger((CommandContext)c, (String)"chunkrange"))))));
        waterframes.then(class_2170.method_9247((String)"experiments").then(class_2170.method_9247((String)"playlistMode").then(class_2170.method_9244((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(c -> WaterFramesCommand.enablePlaylistMode((class_2168)c.getSource(), BoolArgumentType.getBool((CommandContext)c, (String)"enable"))))));
        waterframes.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"give").executes(c -> WaterFramesCommand.giveSelfKit((class_2168)c.getSource()))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(c -> WaterFramesCommand.giveKit((class_2168)c.getSource(), (List)class_2186.method_9312((CommandContext)c, (String)"targets")))));
        waterframes.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"whitelist").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).executes(c -> WaterFramesCommand.whitelist$add((class_2168)c.getSource(), WaterFramesCommand.getStr((CommandContext<class_2168>)c, "url")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).executes(c -> WaterFramesCommand.whitelist$remove((class_2168)c.getSource(), WaterFramesCommand.getStr((CommandContext<class_2168>)c, "url")))))).then(class_2170.method_9247((String)"toggle").executes(c -> WaterFramesCommand.whitelist$toggle((class_2168)c.getSource()))));
        DEFAULT_INPUTS = new class_2290[]{new class_2290(class_6880.method_40223((Object)DisplaysRegistry.REMOTE_ITEM), null), new class_2290(class_6880.method_40223((Object)DisplaysRegistry.FRAME_ITEM), null), new class_2290(class_6880.method_40223((Object)DisplaysRegistry.PROJECTOR_ITEM), null), new class_2290(class_6880.method_40223((Object)DisplaysRegistry.TV_ITEM), null), new class_2290(class_6880.method_40223((Object)DisplaysRegistry.BIG_TV_ITEM), null), new class_2290(class_6880.method_40223((Object)DisplaysRegistry.TV_BOX_ITEM), null)};
        dispatcher.register(waterframes);
    }

    private static int enablePlaylistMode(class_2168 source, boolean enable) {
        if (enable) {
            DisplaysConfig.setPlaylistMode(true);
            source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.experiments.playlist_mode.enabled"), true);
        } else {
            DisplaysConfig.setPlaylistMode(false);
            source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.experiments.playlist_mode.disabled"), true);
        }
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder waterframes = ClientCommandManager.literal((String)"waterframesclient");
        waterframes.then(ClientCommandManager.literal((String)"reload_all").executes(c -> WaterFramesCommand.watermedia$reloadAll((FabricClientCommandSource)c.getSource())));
        dispatcher.register(waterframes);
    }

    public static int setUrl(DisplayTile tile, class_2168 source, String url) {
        UUID uUID;
        if (tile == null) {
            return 1;
        }
        if (!tile.data.uris.isEmpty()) {
            source.method_9213((class_2561)WaterFramesCommand.msgFailed("waterframes.commands.edit.url.failed.experimental"));
            return 1;
        }
        URI uri = WaterFrames.createURI(url);
        if (tile.data.hasUri() && tile.data.getUri().equals(uri)) {
            tile.data.tick = 0;
            tile.data.tickMax = -1;
        }
        tile.data.uri = uri;
        DisplayData displayData = tile.data;
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            uUID = player.method_5667();
        } else {
            uUID = class_156.field_25140;
        }
        displayData.uuid = uUID;
        tile.setDirty();
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.edit.url.success"), true);
        return 0;
    }

    public static int setSize(DisplayTile tile, class_2168 source, float width, float height) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.resizes()) {
            source.method_9213((class_2561)WaterFramesCommand.msgFailed("waterframes.commands.edit.size.failed"));
            return 2;
        }
        tile.data.setWidth(width);
        tile.data.setHeight(height);
        tile.setDirty();
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.edit.size.success"), true);
        return 0;
    }

    public static int setPosition(DisplayTile tile, class_2168 source, PositionVertical vertical, PositionHorizontal horizontal) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.resizes()) {
            source.method_9213((class_2561)WaterFramesCommand.msgFailed("waterframes.commands.edit.position.failed"));
            return 2;
        }
        tile.data.setHeight(vertical, tile.data.getHeight());
        if (horizontal != null) {
            tile.data.setWidth(horizontal, tile.data.getWidth());
        }
        tile.setDirty();
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.edit.position.success"), true);
        return 0;
    }

    public static int setRotation(DisplayTile tile, class_2168 source, float volume) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.resizes()) {
            source.method_9213((class_2561)WaterFramesCommand.msgFailed("waterframes.commands.edit.rotation.failed"));
            return 2;
        }
        tile.data.rotation = volume;
        tile.setDirty();
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.edit.rotation.success"), true);
        return 0;
    }

    public static int setAlpha(DisplayTile tile, class_2168 source, int transparency) {
        if (tile == null) {
            return 1;
        }
        tile.data.alpha = transparency;
        tile.setDirty();
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.edit.alpha.success"), true);
        return 0;
    }

    public static int setBrightness(DisplayTile tile, class_2168 source, int brightness) {
        if (tile == null) {
            return 1;
        }
        tile.data.brightness = brightness;
        tile.setDirty();
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.edit.brightness.success"), true);
        return 0;
    }

    public static int setRenderDistance(DisplayTile tile, class_2168 source, int renderDistance) {
        if (tile == null) {
            return 1;
        }
        tile.data.renderDistance = renderDistance;
        tile.setDirty();
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.edit.render_distance.success"), true);
        return 0;
    }

    public static int setProjectionDistance(DisplayTile tile, class_2168 source, float projectionDistance) {
        if (tile == null) {
            return 1;
        }
        if (!tile.caps.projects()) {
            source.method_9213((class_2561)WaterFramesCommand.msgFailed("waterframes.commands.edit.projection.failed"));
            return 2;
        }
        tile.data.projectionDistance = projectionDistance;
        tile.setDirty();
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.edit.projection.success"), true);
        return 0;
    }

    public static int auditURLAuthor(DisplayTile tile, class_2168 source) {
        if (tile == null) {
            return 1;
        }
        if (tile.data.uuid == class_156.field_25140) {
            source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.audit.author.console"), true);
        } else {
            Optional profiler = source.method_9211().method_3793().method_14512(tile.data.uuid);
            if (profiler.isEmpty()) {
                source.method_9213((class_2561)WaterFramesCommand.msgFailed("waterframes.commands.audit.author.failed", tile.data.uuid.toString()));
                return 2;
            }
            source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.audit.author", (class_2561)class_2561.method_43470((String)((GameProfile)profiler.get()).getName()).method_27692(class_124.field_1075)), true);
        }
        return 0;
    }

    public static int auditFramesRange(class_2168 source, class_3222 player, int chunkRange) {
        int chunkX = player.method_31477() >> 4;
        int chunkZ = player.method_31479() >> 4;
        HashSet displayTiles = new HashSet();
        for (int x = chunkX - chunkRange; x < chunkX + chunkRange; ++x) {
            for (int z = chunkZ - chunkRange; z < chunkZ + chunkRange; ++z) {
                Map chunk = player.field_6002.method_8497(x, z).method_12214();
                chunk.forEach((pos1, blockEntity) -> {
                    if (blockEntity instanceof DisplayTile) {
                        DisplayTile tile = (DisplayTile)((Object)blockEntity);
                        displayTiles.add(tile);
                    }
                });
            }
        }
        if (displayTiles.isEmpty()) {
            source.method_9213((class_2561)WaterFramesCommand.msgFailed("waterframes.commands.audit.in_range.failed"));
            return 1;
        }
        class_5250 response = WaterFramesCommand.msgSuccessSimple("waterframes.commands.audit.in_range.success", "" + displayTiles.size());
        int i = 1;
        response.method_27693("\n");
        for (DisplayTile tile : displayTiles) {
            Optional profiler;
            class_2338 pos = tile.method_11016();
            class_5250 index = class_2561.method_43470((String)("- [" + i + "] ")).method_27692(class_124.field_1065).method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11745, String.format("/teleport %s %s %s %s", player.method_7334().getName(), pos.method_10263(), pos.method_10264(), pos.method_10260())))).method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"waterframes.commands.audit.in_range.tooltip.position", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}))));
            class_5250 x = class_2561.method_43470((String)("X: " + pos.method_10263())).method_27692(class_124.field_1061);
            class_5250 y = class_2561.method_43470((String)("Y: " + pos.method_10264())).method_27692(class_124.field_1060);
            class_5250 z = class_2561.method_43470((String)("Z: " + pos.method_10260())).method_27692(class_124.field_1075);
            String playerAuthor = tile.data.uuid == class_156.field_25140 ? "console/unknown" : ((profiler = source.method_9211().method_3793().method_14512(tile.data.uuid)).isEmpty() ? "unknown" : ((GameProfile)profiler.get()).getName());
            class_5250 author = class_2561.method_43469((String)"waterframes.commands.audit.in_range.author", (Object[])new Object[]{playerAuthor}).method_27692(class_124.field_1063).method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("UUID: " + tile.data.uuid.toString())))));
            response.method_10852((class_2561)index).method_10852((class_2561)x).method_27693(" ").method_10852((class_2561)y).method_27693(" ").method_10852((class_2561)z).method_27693(" || ").method_10852((class_2561)author);
            if (i != displayTiles.size()) {
                response.method_27693("\n");
            }
            ++i;
        }
        source.method_9226(() -> response, true);
        return 0;
    }

    public static int setVolume(DisplayTile tile, class_2168 source, int volume, int min, int max) {
        if (tile == null) {
            return 1;
        }
        if (volume != -1) {
            tile.data.volume = volume;
        }
        if (min != -1) {
            tile.data.minVolumeDistance = min;
        }
        if (max != -1) {
            tile.data.maxVolumeDistance = max;
        }
        tile.setDirty();
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.edit.volume.success"), true);
        return 0;
    }

    public static int giveSelfKit(class_2168 source) throws CommandSyntaxException {
        return WaterFramesCommand.giveKit(source, Collections.singletonList(source.method_9207()));
    }

    public static int giveKit(class_2168 source, List<class_3222> players) throws CommandSyntaxException {
        for (class_3222 serverplayer : players) {
            for (class_2290 input : DEFAULT_INPUTS) {
                class_1799 itemstack = input.method_9781(1, false);
                boolean flag = serverplayer.method_31548().method_7394(itemstack);
                if (flag && itemstack.method_7960()) {
                    itemstack.method_7939(1);
                    class_1542 itementity1 = serverplayer.method_7328(itemstack, false);
                    if (itementity1 != null) {
                        itementity1.method_6987();
                    }
                    serverplayer.field_6002.method_43128(null, serverplayer.method_23317(), serverplayer.method_23318(), serverplayer.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((serverplayer.method_6051().method_43057() - serverplayer.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
                    serverplayer.field_7512.method_7623();
                    continue;
                }
                class_1542 itementity = serverplayer.method_7328(itemstack, false);
                if (itementity == null) continue;
                itementity.method_6975();
                itementity.method_48349(serverplayer.method_5667());
            }
        }
        if (players.size() == 1) {
            source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.give.single", players.get(0).method_5476()), true);
        } else {
            source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.give.multiple", "" + players.size()), true);
        }
        return players.size();
    }

    public static int whitelist$toggle(class_2168 source) {
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.whitelist.toggle", DisplaysConfig.toggleWhitelist() ? ACTIVATED : DEACTIVATED), true);
        return 0;
    }

    public static int whitelist$remove(class_2168 source, String value) {
        boolean removed = DisplaysConfig.removeOnWhitelist(value);
        if (removed) {
            source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.whitelist.remove", value), true);
        } else {
            source.method_9213((class_2561)WaterFramesCommand.msgFailed("waterframes.commands.whitelist.remove.failed"));
        }
        return 0;
    }

    public static int whitelist$add(class_2168 source, String value) {
        DisplaysConfig.addOnWhitelist(value);
        source.method_9226(WaterFramesCommand.msgSuccess("waterframes.commands.whitelist.add", value), true);
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static int watermedia$reloadAll(FabricClientCommandSource source) {
        ImageAPI.reloadCache();
        source.sendFeedback(WaterFramesCommand.msgSuccess("waterframes.commands.reload_all.success").get());
        return 0;
    }

    public static <E extends Enum<E>> E getEnum(CommandContext<class_2168> context, String name, Class<E> enumClass) {
        return (E)((Enum)context.getArgument(name, enumClass));
    }

    public static String getStr(CommandContext<class_2168> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public static byte getByte(CommandContext<class_2168> context, String name) {
        return (Byte)context.getArgument(name, Byte.TYPE);
    }

    public static double getShort(CommandContext<class_2168> context, String name) {
        return ((Short)context.getArgument(name, Short.TYPE)).shortValue();
    }

    public static int getInt(CommandContext<class_2168> context, String name) {
        return (Integer)context.getArgument(name, Integer.TYPE);
    }

    public static int getIntOr(CommandContext<class_2168> context, String name, int def) {
        try {
            return (Integer)context.getArgument(name, Integer.TYPE);
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public static float getFloat(CommandContext<class_2168> context, String name) {
        return ((Float)context.getArgument(name, Float.TYPE)).floatValue();
    }

    public static double getDouble(CommandContext<class_2168> context, String name) {
        return (Double)context.getArgument(name, Double.TYPE);
    }

    private static DisplayTile getTile(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 blockpos = class_2262.method_9696(context, (String)"blockpos");
        class_2586 blockEntity = ((class_2168)context.getSource()).method_9225().method_8321(blockpos);
        if (blockEntity instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            return tile;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)WaterFramesCommand.msgFailed("waterframes.commands.invalid_block"));
        return null;
    }

    private static class_5250 msgFailed(String t) {
        return class_2561.method_43471((String)"waterframes.commands.prefix").method_10852((class_2561)class_2561.method_43471((String)t).method_27692(class_124.field_1061));
    }

    private static class_5250 msgFailed(String t, String t2) {
        return class_2561.method_43471((String)"waterframes.commands.prefix").method_10852((class_2561)class_2561.method_43469((String)t, (Object[])new Object[]{t2}).method_27692(class_124.field_1061));
    }

    private static Supplier<class_2561> msgSuccess(String t) {
        return () -> class_2561.method_43471((String)"waterframes.commands.prefix").method_10852((class_2561)class_2561.method_43471((String)t).method_27692(class_124.field_1060));
    }

    private static Supplier<class_2561> msgSuccess(String t, class_2561 c) {
        return () -> class_2561.method_43471((String)"waterframes.commands.prefix").method_10852((class_2561)class_2561.method_43471((String)t).method_27692(class_124.field_1060).method_10852(c));
    }

    private static Supplier<class_2561> msgSuccess(String t, String ... a) {
        return () -> class_2561.method_43471((String)"waterframes.commands.prefix").method_10852((class_2561)class_2561.method_43469((String)t, (Object[])a).method_27692(class_124.field_1060));
    }

    private static class_5250 msgSuccessSimple(String t, String ... a) {
        return class_2561.method_43471((String)"waterframes.commands.prefix").method_10852((class_2561)class_2561.method_43469((String)t, (Object[])a).method_27692(class_124.field_1060));
    }

    public static boolean hasPermissions(class_2168 sourceStack) {
        if (!sourceStack.method_43737()) {
            return true;
        }
        boolean hasPerms = sourceStack.method_9259(3);
        boolean isCreator = false;
        class_1297 class_12972 = sourceStack.method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            String name = player.method_7334().getName();
            isCreator = name.equals("SrRaapero720") || name.equals("SrRapero720");
        }
        return isCreator || hasPerms;
    }
}

