/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block.data;

import java.net.URI;
import java.util.LinkedList;
import java.util.UUID;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.data.types.AudioPosition;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.DisplayScreen;
import me.srrapero720.waterframes.common.screens.PlayListScreen;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2769;
import org.joml.Vector2f;

public class DisplayData {
    public static final String URL = "url";
    public static final String URI_LIST = "uri_list";
    public static final String URI_INDEX = "uri_index";
    public static final String PLAYER_UUID = "player_uuid";
    public static final String ACTIVE = "active";
    public static final String MIN_X = "min_x";
    public static final String MIN_Y = "min_y";
    public static final String MAX_X = "max_x";
    public static final String MAX_Y = "max_y";
    public static final String FLIP_X = "flip_x";
    public static final String FLIP_Y = "flip_y";
    public static final String ROTATION = "rotation";
    public static final String ALPHA = "alpha";
    public static final String BRIGHTNESS = "brightness";
    public static final String RENDER_DISTANCE = "render_distance";
    public static final String VOLUME = "volume";
    public static final String VOL_RANGE_MIN = "volume_min_range";
    public static final String VOL_RANGE_MAX = "volume_max_range";
    public static final String LOOP = "loop";
    public static final String PAUSED = "paused";
    public static final String MUTED = "muted";
    public static final String TICK = "tick";
    public static final String TIME = "time_ms";
    public static final String TICK_MAX = "tick_max";
    public static final String LIT = "lit";
    public static final String DATA_V = "data_v";
    public static final String RENDER_BOTH_SIDES = "render_both";
    public static final String PROJECTION_DISTANCE = "projection_distance";
    public static final String AUDIO_OFFSET = "audio_offset";
    public static final short V = 2;
    public URI uri = null;
    public LinkedList<URI> uris = new LinkedList();
    public int uri_index;
    public UUID uuid = class_156.field_25140;
    public boolean active = true;
    public Vector2f min = new Vector2f(0.0f, 0.0f);
    public Vector2f max = new Vector2f(1.0f, 1.0f);
    public boolean flipX = false;
    public boolean flipY = false;
    public float rotation = 0.0f;
    public int alpha = 255;
    public int brightness = 255;
    public int renderDistance = DisplaysConfig.maxRenDis(32);
    public int volume = DisplaysConfig.maxVol();
    public int maxVolumeDistance = DisplaysConfig.maxVolDis(20);
    public int minVolumeDistance = Math.min(5, this.maxVolumeDistance);
    public boolean loop = true;
    public boolean paused = false;
    public boolean muted = false;
    public boolean lit = true;
    public int tick = 0;
    public int tickMax = -1;
    public boolean renderBothSides = false;
    public float projectionDistance = DisplaysConfig.maxProjDis(8.0f);
    public float audioOffset = 0.0f;

    public boolean nextUri() {
        if (this.uris.isEmpty()) {
            return false;
        }
        ++this.uri_index;
        if (this.uri_index >= this.uris.size()) {
            this.uri_index = 0;
        }
        this.uri = this.uris.get(this.uri_index);
        this.tick = 0;
        this.tickMax = -1;
        return true;
    }

    public boolean prevUri() {
        if (this.uris.isEmpty()) {
            return false;
        }
        --this.uri_index;
        if (this.uri_index < 0) {
            this.uri_index = this.uris.size() - 1;
        }
        this.uri = this.uris.get(this.uri_index);
        this.tick = 0;
        this.tickMax = -1;
        return true;
    }

    public boolean hasUri() {
        return this.uri != null || !this.uris.isEmpty();
    }

    public URI getUri() {
        return this.uris.isEmpty() ? this.uri : this.uris.get(this.uri_index);
    }

    public PositionHorizontal getPosX() {
        return this.min.x == 0.0f ? PositionHorizontal.LEFT : (this.max.x == 1.0f ? PositionHorizontal.RIGHT : PositionHorizontal.CENTER);
    }

    public PositionVertical getPosY() {
        return this.min.y == 0.0f ? PositionVertical.TOP : (this.max.y == 1.0f ? PositionVertical.BOTTOM : PositionVertical.CENTER);
    }

    public float getWidth() {
        return this.max.x - this.min.x;
    }

    public float getHeight() {
        return this.max.y - this.min.y;
    }

    public void save(class_2487 nbt, DisplayTile tile) {
        nbt.method_10582(URL, !this.hasUri() ? "" : this.getUri().toString());
        nbt.method_10582(URI_LIST, WaterFrames.composeURIString(this.uris));
        nbt.method_10569(URI_INDEX, this.uri_index);
        nbt.method_25927(PLAYER_UUID, this.uuid);
        nbt.method_10556(ACTIVE, this.active);
        if (tile.caps.resizes()) {
            nbt.method_10548(MIN_X, this.min.x);
            nbt.method_10548(MIN_Y, this.min.y);
            nbt.method_10548(MAX_X, this.max.x);
            nbt.method_10548(MAX_Y, this.max.y);
            nbt.method_10548(ROTATION, this.rotation);
        }
        nbt.method_10569(RENDER_DISTANCE, this.renderDistance);
        nbt.method_10556(FLIP_X, this.flipX);
        nbt.method_10556(FLIP_Y, this.flipY);
        nbt.method_10569(ALPHA, this.alpha);
        nbt.method_10569(BRIGHTNESS, this.brightness);
        nbt.method_10569(VOLUME, this.volume);
        nbt.method_10569(VOL_RANGE_MIN, this.minVolumeDistance);
        nbt.method_10569(VOL_RANGE_MAX, this.maxVolumeDistance);
        nbt.method_10556(PAUSED, this.paused);
        nbt.method_10556(MUTED, this.muted);
        nbt.method_10556(LIT, this.lit);
        nbt.method_10544(TICK, (long)this.tick);
        nbt.method_10544(TICK_MAX, (long)this.tickMax);
        nbt.method_10556(LOOP, this.loop);
        if (tile.caps.renderBehind()) {
            nbt.method_10556(RENDER_BOTH_SIDES, this.renderBothSides);
        }
        if (tile.caps.projects()) {
            nbt.method_10548(PROJECTION_DISTANCE, this.projectionDistance);
            nbt.method_10548(AUDIO_OFFSET, this.audioOffset);
        }
        nbt.method_10575(DATA_V, (short)2);
    }

    public void load(class_2487 nbt, DisplayTile tile) {
        String url = nbt.method_10558(URL);
        this.uri = url.isEmpty() ? null : WaterFrames.createURI(nbt.method_10558(URL));
        this.uris = WaterFrames.decomposeURIString(nbt.method_10558(URI_LIST));
        this.uri_index = nbt.method_10550(URI_INDEX);
        this.uuid = nbt.method_10545(PLAYER_UUID) ? nbt.method_25926(PLAYER_UUID) : this.uuid;
        boolean bl = this.active = nbt.method_10545(ACTIVE) ? nbt.method_10577(ACTIVE) : this.active;
        if (tile.caps.resizes()) {
            this.min.x = nbt.method_10583(MIN_X);
            this.min.y = nbt.method_10583(MIN_Y);
            this.max.x = nbt.method_10583(MAX_X);
            this.max.y = nbt.method_10583(MAX_Y);
            this.rotation = nbt.method_10583(ROTATION);
        }
        this.renderDistance = DisplaysConfig.maxRenDis(nbt.method_10550(RENDER_DISTANCE));
        this.flipX = nbt.method_10577(FLIP_X);
        this.flipY = nbt.method_10577(FLIP_Y);
        this.alpha = nbt.method_10545(ALPHA) ? nbt.method_10550(ALPHA) : this.alpha;
        this.brightness = nbt.method_10545(BRIGHTNESS) ? nbt.method_10550(BRIGHTNESS) : this.alpha;
        this.volume = nbt.method_10545(VOLUME) ? DisplaysConfig.maxVol(nbt.method_10550(VOLUME)) : this.volume;
        this.maxVolumeDistance = nbt.method_10545(VOL_RANGE_MAX) ? DisplaysConfig.maxVolDis(nbt.method_10550(VOL_RANGE_MAX)) : this.maxVolumeDistance;
        this.minVolumeDistance = nbt.method_10545(VOL_RANGE_MIN) ? Math.min(nbt.method_10550(VOL_RANGE_MIN), this.maxVolumeDistance) : this.minVolumeDistance;
        this.paused = nbt.method_10577(PAUSED);
        this.muted = nbt.method_10577(MUTED);
        this.lit = !nbt.method_10545(LIT) || nbt.method_10577(LIT);
        this.tick = nbt.method_10550(TICK);
        this.tickMax = nbt.method_10545(TICK_MAX) ? nbt.method_10550(TICK_MAX) : this.tickMax;
        this.loop = nbt.method_10577(LOOP);
        if (tile.caps.renderBehind()) {
            this.renderBothSides = nbt.method_10577(RENDER_BOTH_SIDES);
        }
        if (tile.caps.projects()) {
            this.projectionDistance = nbt.method_10545(PROJECTION_DISTANCE) ? DisplaysConfig.maxProjDis(nbt.method_10583(PROJECTION_DISTANCE)) : this.projectionDistance;
            this.audioOffset = nbt.method_10545(AUDIO_OFFSET) ? nbt.method_10583(AUDIO_OFFSET) : this.audioOffset;
        }
        switch (nbt.method_10568(DATA_V)) {
            case 1: {
                this.alpha = (int)(nbt.method_10583(ALPHA) * 255.0f);
                this.brightness = (int)(nbt.method_10583(BRIGHTNESS) * 255.0f);
                break;
            }
            default: {
                if (!nbt.method_10545("maxx")) {
                    return;
                }
                this.min.x = nbt.method_10583("minx");
                this.min.y = nbt.method_10583("miny");
                this.max.x = nbt.method_10583("maxx");
                this.max.y = nbt.method_10583("maxy");
                this.flipX = nbt.method_10577("flipX");
                this.flipY = nbt.method_10577("flipY");
                this.maxVolumeDistance = DisplaysConfig.maxVolDis((int)nbt.method_10583("max"));
                this.minVolumeDistance = Math.min((int)nbt.method_10583("min"), this.maxVolumeDistance);
                this.renderDistance = nbt.method_10550("render");
                if (tile.canHideModel()) {
                    tile.setVisibility(nbt.method_10577("visibleFrame"));
                }
                if (!tile.caps.renderBehind()) break;
                this.renderBothSides = nbt.method_10577("bothSides");
            }
        }
        this.restrictWidth();
        this.restrictHeight();
    }

    public void setAudioPosition(AudioPosition position) {
        this.audioOffset = switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case AudioPosition.BLOCK -> 0.0f;
            case AudioPosition.PROJECTION -> this.projectionDistance;
            case AudioPosition.CENTER -> this.projectionDistance / 2.0f;
        };
    }

    public AudioPosition getAudioPosition() {
        return this.audioOffset == 0.0f ? AudioPosition.BLOCK : (this.audioOffset == this.projectionDistance ? AudioPosition.PROJECTION : AudioPosition.CENTER);
    }

    public void setWidth(float width) {
        this.setWidth(this.getPosX(), width);
    }

    public void setWidth(PositionHorizontal position, float width) {
        switch (position) {
            case LEFT: {
                this.min.x = 0.0f;
                this.max.x = width;
                break;
            }
            case RIGHT: {
                this.min.x = 1.0f - width;
                this.max.x = 1.0f;
                break;
            }
            default: {
                float middle = width / 2.0f;
                this.min.x = 0.5f - middle;
                this.max.x = 0.5f + middle;
            }
        }
    }

    public void setHeight(float height) {
        this.setHeight(this.getPosY(), height);
    }

    public void setHeight(PositionVertical position, float height) {
        switch (position) {
            case TOP: {
                this.min.y = 0.0f;
                this.max.y = height;
                break;
            }
            case BOTTOM: {
                this.min.y = 1.0f - height;
                this.max.y = 1.0f;
                break;
            }
            default: {
                float middle = height / 2.0f;
                this.min.y = 0.5f - middle;
                this.max.y = 0.5f + middle;
            }
        }
    }

    private void restrictWidth() {
        float maxWidth = DisplaysConfig.maxWidth();
        if (this.getWidth() > maxWidth) {
            switch (this.getPosX()) {
                case LEFT: {
                    this.min.x = 0.0f;
                    this.max.x = maxWidth;
                    break;
                }
                case RIGHT: {
                    this.min.x = 1.0f - maxWidth;
                    this.max.x = 1.0f;
                    break;
                }
                default: {
                    float middle = maxWidth / 2.0f;
                    this.min.x = 0.5f - middle;
                    this.max.x = 0.5f + middle;
                }
            }
        }
    }

    public DisplayData setProjectionDistance(float projectionDistance) {
        this.projectionDistance = projectionDistance;
        return this;
    }

    private void restrictHeight() {
        float maxHeight = DisplaysConfig.maxHeight();
        if (this.getHeight() > maxHeight) {
            switch (this.getPosY()) {
                case TOP: {
                    this.min.y = 0.0f;
                    this.max.y = maxHeight;
                    break;
                }
                case BOTTOM: {
                    this.min.y = 1.0f - maxHeight;
                    this.max.y = 1.0f;
                    break;
                }
                default: {
                    float middle = maxHeight / 2.0f;
                    this.min.y = 0.5f - middle;
                    this.max.y = 0.5f + middle;
                }
            }
        }
    }

    public static class_2487 build(PlayListScreen screen, DisplayTile tile) {
        class_2487 nbt = new class_2487();
        nbt.method_10582(URI_LIST, WaterFrames.composeURIString(screen.getUris()));
        nbt.method_10569(URI_INDEX, 0);
        return nbt;
    }

    public static class_2487 build(DisplayScreen screen, DisplayTile tile) {
        class_2487 nbt = new class_2487();
        nbt.method_10582(URL, screen.url.getText());
        nbt.method_10556(ACTIVE, true);
        if (tile.caps.resizes()) {
            nbt.method_10548("width", Math.max(0.1f, (float)screen.widthField.getValue()));
            nbt.method_10548("height", Math.max(0.1f, (float)screen.heightField.getValue()));
            nbt.method_10569("pos_x", screen.pos_view.getX().ordinal());
            nbt.method_10569("pos_y", screen.pos_view.getY().ordinal());
            nbt.method_10548(ROTATION, (float)screen.rotation.getValue());
        }
        nbt.method_10556(FLIP_X, screen.flip_x.value);
        nbt.method_10556(FLIP_Y, screen.flip_y.value);
        nbt.method_10569(ALPHA, screen.alpha.getIntValue());
        nbt.method_10569(BRIGHTNESS, screen.brightness.getIntValue());
        nbt.method_10569(RENDER_DISTANCE, screen.render_distance.getIntValue());
        nbt.method_10569(VOLUME, screen.volume.getIntValue());
        nbt.method_10569(VOL_RANGE_MIN, screen.volume_min.getIntValue());
        nbt.method_10569(VOL_RANGE_MAX, screen.volume_max.getIntValue());
        if (tile.method_11010().method_28498((class_2769)DisplayBlock.VISIBLE)) {
            nbt.method_10556("visible", screen.show_model.value);
        }
        nbt.method_10556(LIT, screen.lit.value);
        if (tile.caps.renderBehind()) {
            nbt.method_10556(RENDER_BOTH_SIDES, screen.mirror.value);
        }
        if (tile.caps.projects()) {
            nbt.method_10548(PROJECTION_DISTANCE, (float)screen.projection_distance.getValue());
            nbt.method_10569(AUDIO_OFFSET, screen.audio_offset.getState());
        }
        return nbt;
    }

    public static void syncList(DisplayTile tile, class_1657 player, class_2487 tag) {
        tile.data.uris = WaterFrames.decomposeURIString(tag.method_10558(URI_LIST));
        tile.data.uri_index = tag.method_10550(URI_INDEX);
        if (tile.data.uris.isEmpty()) {
            tile.data.uri = null;
        }
        tile.setDirty();
    }

    public static void sync(DisplayTile tile, class_1657 player, class_2487 nbt) {
        String url = nbt.method_10558(URL);
        if (DisplaysConfig.canSave(player, url)) {
            URI uri = WaterFrames.createURI(url);
            if (!tile.data.hasUri() || !tile.data.getUri().equals(uri)) {
                tile.data.tick = 0;
                tile.data.tickMax = -1;
            }
            tile.data.uri = uri;
            tile.data.uuid = tile.data.hasUri() ? player.method_5667() : class_156.field_25140;
            tile.data.active = nbt.method_10577(ACTIVE);
            if (tile.caps.resizes()) {
                float width = DisplaysConfig.maxWidth(nbt.method_10583("width"));
                float height = DisplaysConfig.maxHeight(nbt.method_10583("height"));
                int posX = nbt.method_10550("pos_x");
                int posY = nbt.method_10550("pos_y");
                tile.data.setWidth(PositionHorizontal.VALUES[posX], width);
                tile.data.setHeight(PositionVertical.VALUES[posY], height);
                tile.data.rotation = nbt.method_10583(ROTATION);
            }
            tile.data.flipX = nbt.method_10577(FLIP_X);
            tile.data.flipY = nbt.method_10577(FLIP_Y);
            tile.data.alpha = nbt.method_10550(ALPHA);
            tile.data.brightness = nbt.method_10550(BRIGHTNESS);
            tile.data.renderDistance = DisplaysConfig.maxRenDis(nbt.method_10550(RENDER_DISTANCE));
            tile.data.volume = DisplaysConfig.maxVol(nbt.method_10550(VOLUME));
            tile.data.maxVolumeDistance = DisplaysConfig.maxVolDis(nbt.method_10550(VOL_RANGE_MAX));
            tile.data.minVolumeDistance = Math.min(nbt.method_10550(VOL_RANGE_MIN), tile.data.maxVolumeDistance);
            if (tile.data.minVolumeDistance > tile.data.maxVolumeDistance) {
                tile.data.maxVolumeDistance = tile.data.minVolumeDistance;
            }
            if (tile.canHideModel()) {
                tile.setVisibility(nbt.method_10577("visible"));
            }
            tile.data.lit = nbt.method_10577(LIT);
            if (tile.caps.renderBehind()) {
                tile.data.renderBothSides = nbt.method_10577(RENDER_BOTH_SIDES);
            }
            if (tile.caps.projects()) {
                int mode = nbt.method_10550(AUDIO_OFFSET);
                tile.data.projectionDistance = DisplaysConfig.maxProjDis(nbt.method_10583(PROJECTION_DISTANCE));
                tile.data.setAudioPosition(AudioPosition.VALUES[mode]);
            }
        }
        tile.setDirty();
    }
}

