/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.entity.TVBoxTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;

public class TVBoxBlock
extends DisplayBlock {
    public static final MapCodec<TVBoxBlock> CODEC = TVBoxBlock.simpleCodec(TVBoxBlock::new);
    private static final AlignedBox STATIC_BOX = new AlignedBox();
    protected static final Supplier<BlockBehaviour.Properties> TV_BOX_PROPERTIES = () -> BlockBehaviour.Properties.of().strength(1.0f).sound(SoundType.WOOD);

    public TVBoxBlock(ResourceKey<Block> resourceKey) {
        super(TV_BOX_PROPERTIES.get().setId(resourceKey));
    }

    public TVBoxBlock(BlockBehaviour.Properties p) {
        super(p);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public EnumProperty<Direction> getFacing() {
        return BlockStateProperties.HORIZONTAL_FACING;
    }

    @Override
    public PermissionNode<Boolean> getPermissionNode() {
        return DisplaysRegistry.PERM_DISPLAYS_INTERACT_TV;
    }

    public static AlignedBox box(Direction direction, boolean renderMode) {
        if (!renderMode) {
            return STATIC_BOX;
        }
        Facing facing = Facing.get((Direction)direction.getOpposite());
        AlignedBox box = new AlignedBox();
        if (facing.positive) {
            box.setMin(facing.axis, 0.0625f);
        } else {
            box.setMax(facing.axis, 0.9375f);
        }
        Axis one = facing.one();
        Axis two = facing.two();
        if (facing.axis != Axis.Z) {
            one = facing.two();
            two = facing.one();
        }
        box.setMin(two, 0.375f);
        box.setMax(two, 0.875f);
        box.setMin(one, 0.125f);
        box.setMax(one, 0.875f);
        return box;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState st = super.getStateForPlacement(context);
        return (BlockState)st.setValue(this.getFacing(), (Comparable)((Direction)st.getValue(this.getFacing())).getOpposite());
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.block();
    }

    @Override
    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isCollisionShapeFullBlock(level, pos) ? 0.2f : 1.0f;
    }

    @Override
    public boolean isCollisionShapeFullBlock(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    @Override
    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.NORMAL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TVBoxTile(pos, state);
    }
}

