/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block.data;

import java.net.URI;
import java.util.LinkedList;
import java.util.UUID;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.data.types.AudioPosition;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.DisplayScreen;
import me.srrapero720.waterframes.common.screens.PlayListScreen;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector2f;

public class DisplayData {
    public static final String URL = "url";
    public static final String URI_LIST = "uri_list";
    public static final String URI_INDEX = "uri_index";
    public static final String PLAYER_UUID = "player_uuid";
    public static final String ACTIVE = "active";
    public static final String MIN_X = "min_x";
    public static final String MIN_Y = "min_y";
    public static final String MAX_X = "max_x";
    public static final String MAX_Y = "max_y";
    public static final String FLIP_X = "flip_x";
    public static final String FLIP_Y = "flip_y";
    public static final String ROTATION = "rotation";
    public static final String ALPHA = "alpha";
    public static final String BRIGHTNESS = "brightness";
    public static final String RENDER_DISTANCE = "render_distance";
    public static final String VOLUME = "volume";
    public static final String VOL_RANGE_MIN = "volume_min_range";
    public static final String VOL_RANGE_MAX = "volume_max_range";
    public static final String LOOP = "loop";
    public static final String PAUSED = "paused";
    public static final String MUTED = "muted";
    public static final String TICK = "tick";
    public static final String TICK_MAX = "tick_max";
    public static final String LIT = "lit";
    public static final String DATA_V = "data_v";
    public static final String RENDER_BOTH_SIDES = "render_both";
    public static final String PROJECTION_DISTANCE = "projection_distance";
    public static final String AUDIO_OFFSET = "audio_offset";
    public static final short V = 2;
    public URI uri = null;
    public LinkedList<URI> uris = new LinkedList();
    public int uri_index;
    public UUID uuid = Util.NIL_UUID;
    public boolean active = true;
    public Vector2f min = new Vector2f(0.0f, 0.0f);
    public Vector2f max = new Vector2f(1.0f, 1.0f);
    public boolean flipX = false;
    public boolean flipY = false;
    public float rotation = 0.0f;
    public int alpha = 255;
    public int brightness = 255;
    public int renderDistance = DisplaysConfig.maxRenDis(32);
    public int volume = DisplaysConfig.maxVol();
    public int maxVolumeDistance = DisplaysConfig.maxVolDis(20);
    public int minVolumeDistance = Math.min(5, this.maxVolumeDistance);
    public boolean loop = true;
    public boolean paused = false;
    public boolean muted = false;
    public boolean lit = true;
    public int tick = 0;
    public int tickMax = -1;
    public boolean renderBothSides = false;
    public float projectionDistance = DisplaysConfig.maxProjDis(8.0f);
    public float audioOffset = 0.0f;

    public boolean nextUri() {
        if (this.uris.isEmpty()) {
            return false;
        }
        ++this.uri_index;
        if (this.uri_index >= this.uris.size()) {
            this.uri_index = 0;
        }
        this.uri = this.uris.get(this.uri_index);
        this.tick = 0;
        this.tickMax = -1;
        return true;
    }

    public boolean prevUri() {
        if (this.uris.isEmpty()) {
            return false;
        }
        --this.uri_index;
        if (this.uri_index < 0) {
            this.uri_index = this.uris.size() - 1;
        }
        this.uri = this.uris.get(this.uri_index);
        this.tick = 0;
        this.tickMax = -1;
        return true;
    }

    public boolean hasUri() {
        return this.uri != null || !this.uris.isEmpty();
    }

    public URI getUri() {
        return this.uris.isEmpty() ? this.uri : this.uris.get(this.uri_index);
    }

    public PositionHorizontal getPosX() {
        return this.min.x == 0.0f ? PositionHorizontal.LEFT : (this.max.x == 1.0f ? PositionHorizontal.RIGHT : PositionHorizontal.CENTER);
    }

    public PositionVertical getPosY() {
        return this.min.y == 0.0f ? PositionVertical.TOP : (this.max.y == 1.0f ? PositionVertical.BOTTOM : PositionVertical.CENTER);
    }

    public float getWidth() {
        return this.max.x - this.min.x;
    }

    public float getHeight() {
        return this.max.y - this.min.y;
    }

    public void save(CompoundTag nbt, DisplayTile tile) {
        nbt.putString(URL, !this.hasUri() ? "" : this.getUri().toString());
        nbt.putString(URI_LIST, WaterFrames.composeURIString(this.uris));
        nbt.putInt(URI_INDEX, this.uri_index);
        nbt.store(PLAYER_UUID, UUIDUtil.CODEC, (Object)this.uuid);
        nbt.putBoolean(ACTIVE, this.active);
        if (tile.caps.resizes()) {
            nbt.putFloat(MIN_X, this.min.x);
            nbt.putFloat(MIN_Y, this.min.y);
            nbt.putFloat(MAX_X, this.max.x);
            nbt.putFloat(MAX_Y, this.max.y);
            nbt.putFloat(ROTATION, this.rotation);
        }
        nbt.putInt(RENDER_DISTANCE, this.renderDistance);
        nbt.putBoolean(FLIP_X, this.flipX);
        nbt.putBoolean(FLIP_Y, this.flipY);
        nbt.putInt(ALPHA, this.alpha);
        nbt.putInt(BRIGHTNESS, this.brightness);
        nbt.putInt(VOLUME, this.volume);
        nbt.putInt(VOL_RANGE_MIN, this.minVolumeDistance);
        nbt.putInt(VOL_RANGE_MAX, this.maxVolumeDistance);
        nbt.putBoolean(PAUSED, this.paused);
        nbt.putBoolean(MUTED, this.muted);
        nbt.putBoolean(LIT, this.lit);
        nbt.putLong(TICK, (long)this.tick);
        nbt.putLong(TICK_MAX, (long)this.tickMax);
        nbt.putBoolean(LOOP, this.loop);
        if (tile.caps.renderBehind()) {
            nbt.putBoolean(RENDER_BOTH_SIDES, this.renderBothSides);
        }
        if (tile.caps.projects()) {
            nbt.putFloat(PROJECTION_DISTANCE, this.projectionDistance);
            nbt.putFloat(AUDIO_OFFSET, this.audioOffset);
        }
        nbt.putShort(DATA_V, (short)2);
    }

    public void load(CompoundTag nbt, DisplayTile tile) {
        String url = nbt.getStringOr(URL, "");
        this.uri = url.isEmpty() ? null : WaterFrames.createURI(url);
        this.uris = WaterFrames.decomposeURIString(nbt.getStringOr(URI_LIST, ""));
        this.uri_index = nbt.getIntOr(URI_INDEX, 0);
        this.uuid = nbt.read(PLAYER_UUID, UUIDUtil.CODEC).orElse(this.uuid);
        this.active = nbt.getBooleanOr(ACTIVE, this.active);
        if (tile.caps.resizes()) {
            this.min.x = nbt.getFloatOr(MIN_X, 0.0f);
            this.min.y = nbt.getFloatOr(MIN_Y, 0.0f);
            this.max.x = nbt.getFloatOr(MAX_X, 1.0f);
            this.max.y = nbt.getFloatOr(MAX_Y, 1.0f);
            this.rotation = nbt.getFloatOr(ROTATION, 0.0f);
        }
        this.renderDistance = DisplaysConfig.maxRenDis(nbt.getIntOr(RENDER_DISTANCE, this.renderDistance));
        this.flipX = nbt.getBooleanOr(FLIP_X, this.flipX);
        this.flipY = nbt.getBooleanOr(FLIP_Y, this.flipY);
        this.alpha = nbt.getIntOr(ALPHA, this.alpha);
        this.brightness = nbt.getIntOr(BRIGHTNESS, this.brightness);
        this.volume = DisplaysConfig.maxVol(nbt.getIntOr(VOLUME, this.volume));
        this.maxVolumeDistance = DisplaysConfig.maxVolDis(nbt.getIntOr(VOL_RANGE_MAX, this.maxVolumeDistance));
        this.minVolumeDistance = Math.min(nbt.getIntOr(VOL_RANGE_MIN, this.maxVolumeDistance), this.maxVolumeDistance);
        this.paused = nbt.getBooleanOr(PAUSED, this.paused);
        this.muted = nbt.getBooleanOr(MUTED, this.muted);
        this.lit = nbt.getBooleanOr(LIT, this.lit);
        this.tick = nbt.getIntOr(TICK, 0);
        this.tickMax = nbt.getIntOr(TICK_MAX, this.tickMax);
        this.loop = nbt.getBooleanOr(LOOP, this.loop);
        if (tile.caps.renderBehind()) {
            this.renderBothSides = nbt.getBooleanOr(RENDER_BOTH_SIDES, this.renderBothSides);
        }
        if (tile.caps.projects()) {
            this.projectionDistance = DisplaysConfig.maxProjDis(nbt.getFloatOr(PROJECTION_DISTANCE, this.projectionDistance));
            this.audioOffset = nbt.getFloatOr(AUDIO_OFFSET, this.audioOffset);
        }
        this.restrictWidth();
        this.restrictHeight();
    }

    public void setAudioPosition(AudioPosition position) {
        this.audioOffset = switch (position) {
            default -> throw new MatchException(null, null);
            case AudioPosition.BLOCK -> 0.0f;
            case AudioPosition.PROJECTION -> this.projectionDistance;
            case AudioPosition.CENTER -> this.projectionDistance / 2.0f;
        };
    }

    public AudioPosition getAudioPosition() {
        return this.audioOffset == 0.0f ? AudioPosition.BLOCK : (this.audioOffset == this.projectionDistance ? AudioPosition.PROJECTION : AudioPosition.CENTER);
    }

    public void setWidth(float width) {
        this.setWidth(this.getPosX(), width);
    }

    public void setWidth(PositionHorizontal position, float width) {
        switch (position) {
            case LEFT: {
                this.min.x = 0.0f;
                this.max.x = width;
                break;
            }
            case RIGHT: {
                this.min.x = 1.0f - width;
                this.max.x = 1.0f;
                break;
            }
            default: {
                float middle = width / 2.0f;
                this.min.x = 0.5f - middle;
                this.max.x = 0.5f + middle;
            }
        }
    }

    public void setHeight(float height) {
        this.setHeight(this.getPosY(), height);
    }

    public void setHeight(PositionVertical position, float height) {
        switch (position) {
            case TOP: {
                this.min.y = 0.0f;
                this.max.y = height;
                break;
            }
            case BOTTOM: {
                this.min.y = 1.0f - height;
                this.max.y = 1.0f;
                break;
            }
            default: {
                float middle = height / 2.0f;
                this.min.y = 0.5f - middle;
                this.max.y = 0.5f + middle;
            }
        }
    }

    private void restrictWidth() {
        float maxWidth = DisplaysConfig.maxWidth();
        if (this.getWidth() > maxWidth) {
            switch (this.getPosX()) {
                case LEFT: {
                    this.min.x = 0.0f;
                    this.max.x = maxWidth;
                    break;
                }
                case RIGHT: {
                    this.min.x = 1.0f - maxWidth;
                    this.max.x = 1.0f;
                    break;
                }
                default: {
                    float middle = maxWidth / 2.0f;
                    this.min.x = 0.5f - middle;
                    this.max.x = 0.5f + middle;
                }
            }
        }
    }

    public DisplayData setProjectionDistance(float projectionDistance) {
        this.projectionDistance = projectionDistance;
        return this;
    }

    private void restrictHeight() {
        float maxHeight = DisplaysConfig.maxHeight();
        if (this.getHeight() > maxHeight) {
            switch (this.getPosY()) {
                case TOP: {
                    this.min.y = 0.0f;
                    this.max.y = maxHeight;
                    break;
                }
                case BOTTOM: {
                    this.min.y = 1.0f - maxHeight;
                    this.max.y = 1.0f;
                    break;
                }
                default: {
                    float middle = maxHeight / 2.0f;
                    this.min.y = 0.5f - middle;
                    this.max.y = 0.5f + middle;
                }
            }
        }
    }

    public static CompoundTag build(PlayListScreen screen, DisplayTile tile) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString(URI_LIST, WaterFrames.composeURIString(screen.getUris()));
        nbt.putInt(URI_INDEX, 0);
        return nbt;
    }

    public static CompoundTag build(DisplayScreen screen, DisplayTile tile) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString(URL, screen.url.getText());
        nbt.putBoolean(ACTIVE, true);
        if (tile.caps.resizes()) {
            nbt.putFloat("width", Math.max(0.1f, (float)screen.widthField.getValue()));
            nbt.putFloat("height", Math.max(0.1f, (float)screen.heightField.getValue()));
            nbt.putInt("pos_x", screen.pos_view.getX().ordinal());
            nbt.putInt("pos_y", screen.pos_view.getY().ordinal());
            nbt.putFloat(ROTATION, (float)screen.rotation.getValue());
        }
        nbt.putBoolean(FLIP_X, screen.flip_x.value);
        nbt.putBoolean(FLIP_Y, screen.flip_y.value);
        nbt.putInt(ALPHA, screen.alpha.getIntValue());
        nbt.putInt(BRIGHTNESS, screen.brightness.getIntValue());
        nbt.putInt(RENDER_DISTANCE, screen.render_distance.getIntValue());
        nbt.putInt(VOLUME, screen.volume.getIntValue());
        nbt.putInt(VOL_RANGE_MIN, screen.volume_min.getIntValue());
        nbt.putInt(VOL_RANGE_MAX, screen.volume_max.getIntValue());
        if (tile.getBlockState().hasProperty((Property)DisplayBlock.VISIBLE)) {
            nbt.putBoolean("visible", screen.show_model.value);
        }
        nbt.putBoolean(LIT, screen.lit.value);
        if (tile.caps.renderBehind()) {
            nbt.putBoolean(RENDER_BOTH_SIDES, screen.mirror.value);
        }
        if (tile.caps.projects()) {
            nbt.putFloat(PROJECTION_DISTANCE, (float)screen.projection_distance.getValue());
            nbt.putInt(AUDIO_OFFSET, screen.audio_offset.getState());
        }
        return nbt;
    }

    public static void syncList(DisplayTile tile, Player player, CompoundTag tag) {
        tile.data.uris = WaterFrames.decomposeURIString(tag.getStringOr(URI_LIST, ""));
        tile.data.uri_index = tag.getIntOr(URI_INDEX, 0);
        if (tile.data.uris.isEmpty()) {
            tile.data.uri = null;
        }
        tile.setDirty();
    }

    public static void sync(DisplayTile tile, Player player, CompoundTag nbt) {
        String url = nbt.getStringOr(URL, "");
        if (DisplaysConfig.canSave(player, url)) {
            URI uri = WaterFrames.createURI(url);
            if (!tile.data.hasUri() || !tile.data.getUri().equals(uri)) {
                tile.data.tick = 0;
                tile.data.tickMax = -1;
            }
            tile.data.uri = uri;
            tile.data.uuid = tile.data.hasUri() ? player.getUUID() : Util.NIL_UUID;
            tile.data.active = nbt.getBooleanOr(ACTIVE, true);
            if (tile.caps.resizes()) {
                float width = DisplaysConfig.maxWidth(nbt.getFloatOr("width", 1.0f));
                float height = DisplaysConfig.maxHeight(nbt.getFloatOr("height", 1.0f));
                int posX = nbt.getIntOr("pos_x", PositionHorizontal.LEFT.ordinal());
                int posY = nbt.getIntOr("pos_y", PositionVertical.TOP.ordinal());
                tile.data.setWidth(PositionHorizontal.VALUES[posX], width);
                tile.data.setHeight(PositionVertical.VALUES[posY], height);
                tile.data.rotation = nbt.getFloatOr(ROTATION, 0.0f);
            }
            tile.data.flipX = nbt.getBooleanOr(FLIP_X, false);
            tile.data.flipY = nbt.getBooleanOr(FLIP_Y, false);
            tile.data.alpha = nbt.getIntOr(ALPHA, 255);
            tile.data.brightness = nbt.getIntOr(BRIGHTNESS, 255);
            tile.data.renderDistance = DisplaysConfig.maxRenDis(nbt.getIntOr(RENDER_DISTANCE, 4));
            tile.data.volume = DisplaysConfig.maxVol(nbt.getIntOr(VOLUME, 100));
            tile.data.maxVolumeDistance = DisplaysConfig.maxVolDis(nbt.getIntOr(VOL_RANGE_MAX, 20));
            tile.data.minVolumeDistance = Math.min(nbt.getIntOr(VOL_RANGE_MIN, 4), tile.data.maxVolumeDistance);
            if (tile.data.minVolumeDistance > tile.data.maxVolumeDistance) {
                tile.data.maxVolumeDistance = tile.data.minVolumeDistance;
            }
            if (tile.canHideModel()) {
                tile.setVisibility(nbt.getBooleanOr("visible", true));
            }
            tile.data.lit = nbt.getBooleanOr(LIT, true);
            if (tile.caps.renderBehind()) {
                tile.data.renderBothSides = nbt.getBooleanOr(RENDER_BOTH_SIDES, false);
            }
            if (tile.caps.projects()) {
                int mode = nbt.getIntOr(AUDIO_OFFSET, AudioPosition.BLOCK.ordinal());
                tile.data.projectionDistance = DisplaysConfig.maxProjDis(nbt.getFloatOr(PROJECTION_DISTANCE, 8.0f));
                tile.data.setAudioPosition(AudioPosition.VALUES[mode]);
            }
        }
        tile.setDirty();
    }
}

