/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.item;

import java.util.function.Consumer;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.DisplaysRegistry;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.item.data.RemoteData;
import me.srrapero720.waterframes.common.screens.RemoteControlScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.gui.creator.ItemGuiCreator;

public class RemoteControl
extends Item
implements ItemGuiCreator {
    private static final String POSITION = "position";
    private static final String DIMENSION = "dimension";
    private static final Marker IT = MarkerManager.getMarker((String)RemoteControl.class.getSimpleName());

    public RemoteControl(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        if (!DisplaysConfig.canInteractRemote(player)) {
            this.sendFatal(player, Component.translatable((String)"waterframes.common.access.denied"));
            return InteractionResult.FAIL;
        }
        RemoteData data = (RemoteData)stack.get(DisplaysRegistry.REMOTE_DATA);
        if (data == null) {
            this.sendFailed(player, Component.translatable((String)"waterframes.remote.bound.failed"));
            return InteractionResult.PASS;
        }
        if (player.isCrouching()) {
            stack.set(DisplaysRegistry.REMOTE_DATA, null);
            this.sendSuccess(player, Component.translatable((String)"waterframes.remote.unbound.success"));
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = new BlockPos(data.x(), data.y(), data.z());
        ResourceLocation dimension = ResourceLocation.parse((String)data.dimension());
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            double distance = WaterFrames.getDistance(tile, (Position)player.position());
            if (level.dimension().location().equals((Object)dimension) && distance < (double)DisplaysConfig.maxRcDis()) {
                CompoundTag tag = new CompoundTag();
                tag.putString(DIMENSION, data.dimension());
                tag.putIntArray(POSITION, data.getPos());
                GuiCreator.ITEM_OPENER.open(tag, player, hand);
                return InteractionResult.SUCCESS;
            }
            this.sendFailed(player, Component.translatable((String)"waterframes.remote.distance.failed"));
            return InteractionResult.FAIL;
        }
        player.getItemInHand(hand).set(DisplaysRegistry.REMOTE_DATA, null);
        this.sendFailed(player, Component.translatable((String)"waterframes.remote.display.failed"));
        return InteractionResult.FAIL;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        RemoteData data = (RemoteData)context.getItemInHand().get(DisplaysRegistry.REMOTE_DATA);
        if (player == null || context.getHand() == InteractionHand.OFF_HAND || data != null || !player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (!DisplaysConfig.canBindRemote(player)) {
            this.sendFatal(player, Component.translatable((String)"waterframes.common.access.denied"));
            return InteractionResult.FAIL;
        }
        if (level.getBlockEntity(pos) instanceof DisplayTile) {
            ItemStack item = context.getItemInHand();
            item.set(DisplaysRegistry.REMOTE_DATA, (Object)new RemoteData(level.dimension().location().toString(), pos.getX(), pos.getY(), pos.getZ()));
            this.sendSuccess(player, Component.translatable((String)"waterframes.remote.bound.success"));
            return InteractionResult.SUCCESS;
        }
        this.sendFailed(player, Component.translatable((String)"waterframes.remote.display.invalid"));
        return InteractionResult.FAIL;
    }

    private void sendSuccess(Player player, MutableComponent component) {
        if (player.level.isClientSide) {
            player.displayClientMessage((Component)component.withStyle(ChatFormatting.AQUA), true);
            player.playSound((SoundEvent)NoteBlockInstrument.BELL.getSoundEvent().value(), 1.0f, 1.25f);
        }
    }

    private void sendFailed(Player player, MutableComponent component) {
        if (player.level.isClientSide) {
            player.displayClientMessage((Component)component.withStyle(ChatFormatting.RED), true);
            player.playSound((SoundEvent)NoteBlockInstrument.HARP.getSoundEvent().value(), 1.0f, 0.75f);
        }
    }

    private void sendFatal(Player player, MutableComponent component) {
        if (player.level.isClientSide) {
            player.displayClientMessage((Component)component.withStyle(ChatFormatting.DARK_RED), true);
            player.playSound((SoundEvent)NoteBlockInstrument.HARP.getSoundEvent().value(), 1.0f, 0.5f);
        }
    }

    public boolean hasPosition(CompoundTag tag) {
        return tag.contains(POSITION);
    }

    public boolean hasDimension(CompoundTag tag) {
        return tag.contains(DIMENSION);
    }

    public int[] getPosition(CompoundTag data) {
        return data.getIntArray(POSITION).orElse(null);
    }

    public int[] getPosition(RemoteData data) {
        return data.getPos();
    }

    public String getDimension(RemoteData data) {
        return data.dimension();
    }

    public void setPosition(CompoundTag tag, BlockPos pos) {
        tag.putIntArray(POSITION, new int[]{pos.getX(), pos.getY(), pos.getZ()});
    }

    public void setDimension(CompoundTag tag, Level level) {
        tag.putString(DIMENSION, level.dimension().location().toString());
    }

    public GuiLayer create(CompoundTag tag, Player player) {
        int[] pos = this.getPosition(tag);
        BlockPos blockPos = new BlockPos(pos[0], pos[1], pos[2]);
        return new RemoteControlScreen(player, (DisplayTile)player.level.getBlockEntity(blockPos), tag, this);
    }

    public Component getHighlightTip(ItemStack item, Component displayName) {
        return Component.literal((String)displayName.getString()).withStyle(ChatFormatting.AQUA);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, TooltipDisplay tooltipDisplay, Consumer<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, tooltipDisplay, pTooltipComponents, pTooltipFlag);
        Options opts = Minecraft.getInstance().options;
        pTooltipComponents.accept((Component)Component.translatable((String)"waterframes.remote.description.1", (Object[])new Object[]{opts.keyShift.getKey().getDisplayName(), opts.keyUse.getKey().getDisplayName()}));
    }

    public boolean isFoil(ItemStack pStack) {
        return pStack.get(DisplaysRegistry.REMOTE_DATA) != null;
    }

    public boolean canDestroyBlock(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, LivingEntity pPlayer) {
        return false;
    }
}

