package me.eigenraven.lwjgl3ify.relauncher;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class SettingsDialog {

    public JComboBox<String> comboJavaExecutable;
    public JButton buttonRefreshJavas;
    public JButton buttonAddJava;
    public JTabbedPane tabbedPane1;
    public JSlider optMinMemory;
    public JComboBox<RelauncherConfig.GCOption> optGC;
    public JTextPane optCustom;
    public JButton buttonRun;
    public JCheckBox optHideOnFutureLaunches;
    public JCheckBox optRfbDumpClasses;
    public JCheckBox optRfbDumpTransformers;
    public JCheckBox optDebugAgent;
    public JCheckBox optDebugSuspend;
    public JCheckBox optForwardLogs;
    public JSlider optMaxMemory;
    public JCheckBox optMixinDebug;
    public JCheckBox optMixinExport;
    public JCheckBox optMixinCount;
    public JCheckBox optFmlDebugAts;
    public JPanel rootPanel;
    public JLabel labelMinJavaVer;
    public JLabel lblHeader;
    public JLabel lblJavaExecutable;
    public JLabel lblJavaOptions;
    public JPanel panelBasic;
    public JPanel panelAdvanced;
    public JLabel lblMinMemory;
    public JLabel lblMaxMemory;
    public JLabel lblGarbageCollector;
    public JLabel lblCustomOptions;
    public JButton buttonPreviewJavaOpts;

    public final ResourceBundle translations;

    public SettingsDialog() {
        translations = ResourceBundle.getBundle("me.eigenraven.lwjgl3ify.relauncher.TranslationsBundle");
    }

    public void loadTranslations() {
        lblHeader.setText(translations.getString(TranslationsBundle.KEY_SETTINGS_HEADER));
        buttonRefreshJavas.setText(translations.getString(TranslationsBundle.KEY_REFRESH));
        buttonAddJava.setText(translations.getString(TranslationsBundle.KEY_ADD_JAVA));
        buttonRun.setText(translations.getString(TranslationsBundle.KEY_RUN_GAME));
        lblJavaExecutable.setText(translations.getString(TranslationsBundle.KEY_JAVA_EXECUTABLE));
        labelMinJavaVer.setText(String.format(translations.getString(TranslationsBundle.KEY_MIN_MOD_JAVA), 17));
        tabbedPane1.setTitleAt(0, translations.getString(TranslationsBundle.KEY_TAB_BASIC));
        tabbedPane1.setTitleAt(1, translations.getString(TranslationsBundle.KEY_TAB_ADVANCED));
        lblMinMemory.setText(translations.getString(TranslationsBundle.KEY_MIN_MEMORY_MB));
        lblMaxMemory.setText(translations.getString(TranslationsBundle.KEY_MAX_MEMORY_MB));
        lblGarbageCollector.setText(translations.getString(TranslationsBundle.KEY_GARBAGE_COLLECTOR));
        lblCustomOptions.setText(translations.getString(TranslationsBundle.KEY_CUSTOM_OPTIONS));
        lblJavaOptions.setText(translations.getString(TranslationsBundle.KEY_JAVA_OPTIONS));
        optHideOnFutureLaunches.setText(translations.getString(TranslationsBundle.KEY_SKIP_IN_FUTURE));
        buttonPreviewJavaOpts.setText(translations.getString(TranslationsBundle.KEY_PREVIEW_JAVA_OPTS));

        optForwardLogs.setText(translations.getString(TranslationsBundle.KEY_FORWARD_LOGS));
        optDebugAgent.setText(translations.getString(TranslationsBundle.KEY_ALLOW_DEBUGGER));
        optDebugSuspend.setText(translations.getString(TranslationsBundle.KEY_WAIT_FOR_DEBUGGER));
        optMixinDebug.setText(translations.getString(TranslationsBundle.KEY_MIXIN_DEBUG));
        optMixinExport.setText(translations.getString(TranslationsBundle.KEY_MIXIN_EXPORT_CLASSES));
        optMixinCount.setText(translations.getString(TranslationsBundle.KEY_MIXIN_COUNT_INJECTIONS));
        optFmlDebugAts.setText(translations.getString(TranslationsBundle.KEY_FML_DEBUG_AT));
        optRfbDumpClasses.setText(translations.getString(TranslationsBundle.KEY_RFB_DUMP_CLASSES));
        optRfbDumpTransformers.setText(translations.getString(TranslationsBundle.KEY_RFB_DUMP_CLASSES_PER_TRANSFORMER));

        optForwardLogs.setToolTipText(translations.getString(TranslationsBundle.KEY_FORWARD_LOGS_TIP));
    }

    {
        // GUI initializer generated by IntelliJ IDEA GUI Designer
        // >>> IMPORTANT!! <<<
        // DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer >>> IMPORTANT!! <<< DO NOT edit this method OR call it in your
     * code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        rootPanel = new JPanel();
        rootPanel.setLayout(new GridBagLayout());
        final JPanel spacer1 = new JPanel();
        GridBagConstraints gbc;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        rootPanel.add(spacer1, gbc);
        lblHeader = new JLabel();
        Font lblHeaderFont = this.$$$getFont$$$(null, Font.BOLD, -1, lblHeader.getFont());
        if (lblHeaderFont != null) lblHeader.setFont(lblHeaderFont);
        lblHeader.setHorizontalAlignment(0);
        lblHeader.setHorizontalTextPosition(0);
        lblHeader.setText("KEY_SETTINGS_HEADER");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        rootPanel.add(lblHeader, gbc);
        lblJavaExecutable = new JLabel();
        lblJavaExecutable.setText("KEY_JAVA_EXECUTABLE");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = GridBagConstraints.WEST;
        rootPanel.add(lblJavaExecutable, gbc);
        comboJavaExecutable = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        rootPanel.add(comboJavaExecutable, gbc);
        buttonRefreshJavas = new JButton();
        buttonRefreshJavas.setText("KEY_REFRESH");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        rootPanel.add(buttonRefreshJavas, gbc);
        final JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        rootPanel.add(spacer2, gbc);
        buttonAddJava = new JButton();
        buttonAddJava.setText("KEY_ADD_JAVA");
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        rootPanel.add(buttonAddJava, gbc);
        labelMinJavaVer = new JLabel();
        labelMinJavaVer.setText("KEY_MIN_MOD_JAVA");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = GridBagConstraints.WEST;
        rootPanel.add(labelMinJavaVer, gbc);
        lblJavaOptions = new JLabel();
        lblJavaOptions.setText("KEY_JAVA_OPTIONS");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = GridBagConstraints.WEST;
        rootPanel.add(lblJavaOptions, gbc);
        tabbedPane1 = new JTabbedPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.fill = GridBagConstraints.BOTH;
        rootPanel.add(tabbedPane1, gbc);
        panelBasic = new JPanel();
        panelBasic.setLayout(new GridBagLayout());
        tabbedPane1.addTab("KEY_TAB_BASIC", panelBasic);
        panelBasic.setBorder(
            BorderFactory.createTitledBorder(
                BorderFactory.createEtchedBorder(),
                null,
                TitledBorder.DEFAULT_JUSTIFICATION,
                TitledBorder.DEFAULT_POSITION,
                null,
                null));
        lblMinMemory = new JLabel();
        lblMinMemory.setText("KEY_MIN_MEMORY_MB");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.EAST;
        panelBasic.add(lblMinMemory, gbc);
        optMinMemory = new JSlider();
        optMinMemory.setMajorTickSpacing(1024);
        optMinMemory.setMaximum(8192);
        optMinMemory.setMinorTickSpacing(256);
        optMinMemory.setPaintLabels(true);
        optMinMemory.setPaintTicks(true);
        optMinMemory.setSnapToTicks(true);
        optMinMemory.setValueIsAdjusting(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panelBasic.add(optMinMemory, gbc);
        lblMaxMemory = new JLabel();
        lblMaxMemory.setText("KEY_MAX_MEMORY_MB");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = GridBagConstraints.EAST;
        panelBasic.add(lblMaxMemory, gbc);
        optMaxMemory = new JSlider();
        optMaxMemory.setMajorTickSpacing(1024);
        optMaxMemory.setMaximum(8192);
        optMaxMemory.setMinorTickSpacing(256);
        optMaxMemory.setPaintLabels(true);
        optMaxMemory.setPaintTicks(true);
        optMaxMemory.setSnapToTicks(true);
        optMaxMemory.setValueIsAdjusting(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panelBasic.add(optMaxMemory, gbc);
        lblGarbageCollector = new JLabel();
        lblGarbageCollector.setText("KEY_GARBAGE_COLLECTOR");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = GridBagConstraints.EAST;
        panelBasic.add(lblGarbageCollector, gbc);
        optGC = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panelBasic.add(optGC, gbc);
        lblCustomOptions = new JLabel();
        lblCustomOptions.setText("KEY_CUSTOM_OPTIONS");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = GridBagConstraints.WEST;
        panelBasic.add(lblCustomOptions, gbc);
        final JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.insets = new Insets(4, 4, 4, 4);
        panelBasic.add(scrollPane1, gbc);
        optCustom = new JTextPane();
        optCustom.setMinimumSize(new Dimension(256, 128));
        scrollPane1.setViewportView(optCustom);
        panelAdvanced = new JPanel();
        panelAdvanced.setLayout(new GridBagLayout());
        tabbedPane1.addTab("KEY_TAB_ADVANCED", panelAdvanced);
        panelAdvanced.setBorder(
            BorderFactory.createTitledBorder(
                BorderFactory.createEtchedBorder(),
                null,
                TitledBorder.DEFAULT_JUSTIFICATION,
                TitledBorder.DEFAULT_POSITION,
                null,
                null));
        optRfbDumpClasses = new JCheckBox();
        optRfbDumpClasses.setText("KEY_RFB_DUMP_CLASSES");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(4, 0, 0, 0);
        panelAdvanced.add(optRfbDumpClasses, gbc);
        final JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.weightx = 1.0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panelAdvanced.add(spacer3, gbc);
        final JPanel spacer4 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.weighty = 1.0;
        gbc.fill = GridBagConstraints.VERTICAL;
        panelAdvanced.add(spacer4, gbc);
        optRfbDumpTransformers = new JCheckBox();
        optRfbDumpTransformers.setText("KEY_RFB_DUMP_CLASSES_PER_TRANSFORMER");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(4, 0, 0, 0);
        panelAdvanced.add(optRfbDumpTransformers, gbc);
        optDebugAgent = new JCheckBox();
        optDebugAgent.setText("KEY_ALLOW_DEBUGGER");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(4, 0, 0, 0);
        panelAdvanced.add(optDebugAgent, gbc);
        optDebugSuspend = new JCheckBox();
        optDebugSuspend.setText("KEY_WAIT_FOR_DEBUGGER");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(4, 0, 0, 0);
        panelAdvanced.add(optDebugSuspend, gbc);
        optForwardLogs = new JCheckBox();
        optForwardLogs.setEnabled(true);
        optForwardLogs.setSelected(false);
        optForwardLogs.setText("KEY_FORWARD_LOGS");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(4, 0, 0, 0);
        panelAdvanced.add(optForwardLogs, gbc);
        optMixinExport = new JCheckBox();
        optMixinExport.setText("KEY_MIXIN_EXPORT_CLASSES");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(4, 0, 0, 0);
        panelAdvanced.add(optMixinExport, gbc);
        optMixinDebug = new JCheckBox();
        optMixinDebug.setText("KEY_MIXIN_DEBUG");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(4, 0, 0, 0);
        panelAdvanced.add(optMixinDebug, gbc);
        optMixinCount = new JCheckBox();
        optMixinCount.setText("KEY_MIXIN_COUNT_INJECTIONS");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(4, 0, 0, 0);
        panelAdvanced.add(optMixinCount, gbc);
        optFmlDebugAts = new JCheckBox();
        optFmlDebugAts.setText("KEY_FML_DEBUG_AT");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(4, 0, 0, 0);
        panelAdvanced.add(optFmlDebugAts, gbc);
        buttonRun = new JButton();
        buttonRun.setText("KEY_RUN_GAME");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        rootPanel.add(buttonRun, gbc);
        optHideOnFutureLaunches = new JCheckBox();
        optHideOnFutureLaunches.setSelected(true);
        optHideOnFutureLaunches.setText("KEY_SKIP_IN_FUTURE");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 5;
        gbc.anchor = GridBagConstraints.WEST;
        rootPanel.add(optHideOnFutureLaunches, gbc);
        buttonPreviewJavaOpts = new JButton();
        buttonPreviewJavaOpts.setText("KEY_PREVIEW_JAVA_OPTS");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.anchor = GridBagConstraints.WEST;
        rootPanel.add(buttonPreviewJavaOpts, gbc);
    }

    /** @noinspection ALL */
    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        if (currentFont == null) return null;
        String resultName;
        if (fontName == null) {
            resultName = currentFont.getName();
        } else {
            Font testFont = new Font(fontName, Font.PLAIN, 10);
            if (testFont.canDisplay('a') && testFont.canDisplay('1')) {
                resultName = fontName;
            } else {
                resultName = currentFont.getName();
            }
        }
        Font font = new Font(
            resultName,
            style >= 0 ? style : currentFont.getStyle(),
            size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "")
            .toLowerCase(Locale.ENGLISH)
            .startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize())
            : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    /** @noinspection ALL */
    public JComponent $$$getRootComponent$$$() {
        return rootPanel;
    }

}
