/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap;

import com.gtnewhorizons.retrofuturabootstrap.Main;
import com.gtnewhorizons.retrofuturabootstrap.URLClassLoaderBase;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformerHandle;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.jar.Manifest;

public class URLClassLoaderWithUtilities
extends URLClassLoaderBase {
    public URLClassLoaderWithUtilities(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public URLClassLoaderWithUtilities(URL[] urls) {
        super(urls);
    }

    public URLClassLoaderWithUtilities(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public URLClassLoaderWithUtilities(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, parent);
    }

    public URLClassLoaderWithUtilities(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(name, urls, parent, factory);
    }

    public byte[] runRfbTransformers(Collection<RfbClassTransformerHandle> rfbTransformers, RfbClassTransformer.Context context, Manifest manifest, String className, byte[] basicClass) {
        if (rfbTransformers.isEmpty()) {
            return basicClass;
        }
        ExtensibleClassLoader self = (ExtensibleClassLoader)((Object)this);
        int xformerIndex = 0;
        ClassNodeHandle nodeHandle = new ClassNodeHandle(basicClass);
        byte[] previousBytes = basicClass;
        block2: for (RfbClassTransformerHandle handle : rfbTransformers) {
            for (String exclusion : handle.exclusions()) {
                if (!className.startsWith(exclusion)) continue;
                continue block2;
            }
            RfbClassTransformer xformer = handle.transformer();
            try {
                if (xformer.shouldTransformClass(self, context, manifest, className, nodeHandle)) {
                    xformer.transformClass(self, context, manifest, className, nodeHandle);
                    if (Main.cfgDumpLoadedClassesPerTransformer) {
                        byte[] newBytes = nodeHandle.computeBytes();
                        if (newBytes != null && !Arrays.equals(newBytes, previousBytes)) {
                            Main.dumpClass(this.getClassLoaderName(), String.format("%s__S%03d_%s", className, xformerIndex, handle.id().replace(':', '$')), newBytes);
                        }
                        previousBytes = newBytes;
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                if (e.getMessage().contains("requires ASM")) {
                    Main.logger.warn("ASM transformer {} encountered a newer classfile ({}) than supported: {}", new Object[]{xformer.getClass().getName(), className, e.getMessage()});
                    ++xformerIndex;
                    continue;
                }
                throw e;
            }
            ++xformerIndex;
        }
        return nodeHandle.computeBytes();
    }
}

