/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.api;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import me.eigenraven.lwjgl3ify.client.TextFieldHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class InputEvents {
    private static final ArrayList<KeyboardListener> keyboardListeners = new ArrayList();
    private static final ArrayList<WeakReference<KeyboardListener>> weakKeyboardListeners = new ArrayList();

    public static void addKeyboardListener(KeyboardListener listener) {
        keyboardListeners.add(listener);
    }

    public static void removeKeyboardListener(KeyboardListener listener) {
        keyboardListeners.remove(listener);
    }

    public static void addWeakKeyboardListener(KeyboardListener listener) {
        weakKeyboardListeners.add(new WeakReference<KeyboardListener>(listener));
    }

    public static void removeWeakKeyboardListener(KeyboardListener listener) {
        for (int i = 0; i < weakKeyboardListeners.size(); ++i) {
            if (weakKeyboardListeners.get(i).get() != listener) continue;
            weakKeyboardListeners.remove(i);
            return;
        }
    }

    public static void injectKeyEvent(KeyEvent ev) {
        int i;
        GuiScreen gui = Minecraft.getMinecraft().currentScreen;
        if (gui instanceof KeyboardListener) {
            KeyboardListener kl = (KeyboardListener)gui;
            kl.onKeyEvent(ev);
        }
        for (i = 0; i < keyboardListeners.size(); ++i) {
            KeyboardListener listener = keyboardListeners.get(i);
            listener.onKeyEvent(ev);
        }
        for (i = 0; i < weakKeyboardListeners.size(); ++i) {
            WeakReference<KeyboardListener> weak = weakKeyboardListeners.get(i);
            KeyboardListener strong = (KeyboardListener)weak.get();
            if (strong == null) {
                weakKeyboardListeners.remove(i);
                --i;
                continue;
            }
            strong.onKeyEvent(ev);
        }
    }

    public static void injectTextEvent(TextEvent ev) {
        int i;
        GuiScreen gui = Minecraft.getMinecraft().currentScreen;
        if (gui instanceof KeyboardListener) {
            KeyboardListener kl = (KeyboardListener)gui;
            kl.onTextEvent(ev);
        }
        for (i = 0; i < keyboardListeners.size(); ++i) {
            KeyboardListener listener = keyboardListeners.get(i);
            listener.onTextEvent(ev);
        }
        for (i = 0; i < weakKeyboardListeners.size(); ++i) {
            WeakReference<KeyboardListener> weak = weakKeyboardListeners.get(i);
            KeyboardListener strong = (KeyboardListener)weak.get();
            if (strong == null) {
                weakKeyboardListeners.remove(i);
                --i;
                continue;
            }
            strong.onTextEvent(ev);
        }
    }

    public static void beginTextInput() {
        TextFieldHandler.beginTextInput();
    }

    public static void endTextInput() {
        TextFieldHandler.endTextInput(null);
    }

    public static interface KeyboardListener {
        default public void onKeyEvent(KeyEvent event) {
        }

        default public void onTextEvent(TextEvent event) {
        }
    }

    public static class KeyEvent {
        public final int lwjgl2KeyCode;
        public final int lwjgl2ScanCode;
        public final int sdlKeyCode;
        public final int sdlScanCode;
        public final int sdlRawKeyCode;
        public final KeyAction action;
        public final short sdlKeyModifiers;
        public final long keyNamePointer;

        public KeyEvent(int lwjgl2KeyCode, int lwjgl2ScanCode, int sdlKeyCode, int sdlScanCode, int sdlRawKeyCode, KeyAction action, short sdlKeyModifiers, long keyNamePointer) {
            this.lwjgl2KeyCode = lwjgl2KeyCode;
            this.lwjgl2ScanCode = lwjgl2ScanCode;
            this.sdlKeyCode = sdlKeyCode;
            this.sdlScanCode = sdlScanCode;
            this.sdlRawKeyCode = sdlRawKeyCode;
            this.action = action;
            this.sdlKeyModifiers = sdlKeyModifiers;
            this.keyNamePointer = keyNamePointer;
        }
    }

    public static class TextEvent {
        public final String text;

        public TextEvent(String text) {
            this.text = text;
        }
    }

    public static enum KeyAction {
        PRESSED,
        REPEATED,
        RELEASED;

    }
}

