/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.client;

import com.google.common.base.Throwables;
import com.gtnewhorizons.retrofuturabootstrap.MainStartOnFirstThread;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.Platform;

public class MainThreadExec {
    public static final boolean IS_MACOS = Platform.get() == Platform.MACOSX;
    private static final ExecutorService executor = MainStartOnFirstThread.instance();
    private static final Thread mainThread;

    public static void ensureInitialised() {
    }

    public static boolean isMainThread() {
        return Thread.currentThread() == mainThread;
    }

    private static <R> Callable<R> bindClassloader(Callable<R> callable) {
        return new CallableWithClassLoader<R>(callable);
    }

    private static <V> V futureGet(Future<V> future) {
        while (true) {
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void runOnMainThread(Runnable r) {
        Objects.requireNonNull(r);
        if (MainThreadExec.isMainThread()) {
            r.run();
        } else {
            MainThreadExec.futureGet(executor.submit(MainThreadExec.bindClassloader(Executors.callable(r))));
        }
    }

    @Nullable
    public static <ReturnType> ReturnType runOnMainThread(Callable<@Nullable ReturnType> r) {
        Objects.requireNonNull(r);
        try {
            if (MainThreadExec.isMainThread()) {
                return r.call();
            }
            return MainThreadExec.futureGet(executor.submit(MainThreadExec.bindClassloader(r)));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static boolean runOnMainThread(BooleanSupplier r) {
        Objects.requireNonNull(r);
        if (MainThreadExec.isMainThread()) {
            return r.getAsBoolean();
        }
        return Objects.requireNonNull(MainThreadExec.runOnMainThread(() -> r.getAsBoolean()));
    }

    public static int runOnMainThread(IntSupplier r) {
        Objects.requireNonNull(r);
        if (MainThreadExec.isMainThread()) {
            return r.getAsInt();
        }
        return Objects.requireNonNull(MainThreadExec.runOnMainThread(() -> r.getAsInt()));
    }

    public static long runOnMainThread(LongSupplier r) {
        Objects.requireNonNull(r);
        if (MainThreadExec.isMainThread()) {
            return r.getAsLong();
        }
        return Objects.requireNonNull(MainThreadExec.runOnMainThread(() -> r.getAsLong()));
    }

    public static double runOnMainThread(DoubleSupplier r) {
        Objects.requireNonNull(r);
        if (MainThreadExec.isMainThread()) {
            return r.getAsDouble();
        }
        return Objects.requireNonNull(MainThreadExec.runOnMainThread(() -> r.getAsDouble()));
    }

    static {
        final AtomicReference mainThreadStorage = new AtomicReference();
        MainThreadExec.futureGet(executor.submit(new CallableWithClassLoader<Object>(new Callable<Object>(){

            @Override
            public Object call() {
                mainThreadStorage.set(Thread.currentThread());
                return null;
            }
        })));
        mainThread = Objects.requireNonNull((Thread)mainThreadStorage.get());
    }

    static class CallableWithClassLoader<Ret>
    implements Callable<Ret> {
        private final ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private final Callable<Ret> inner;

        public CallableWithClassLoader(Callable<Ret> inner) {
            this.inner = inner;
        }

        @Override
        public Ret call() throws Exception {
            ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.loader);
            try {
                Ret Ret = this.inner.call();
                return Ret;
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
    }
}

