/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.textures;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FastByteChannel
extends AbstractInterruptibleChannel
implements ReadableByteChannel {
    private final InputStream in;
    private static final int TRANSFER_SIZE = 8192;
    private byte[] buf = new byte[0];

    public FastByteChannel(InputStream in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int totalRead;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int len = dst.remaining();
        int bytesRead = 0;
        for (totalRead = 0; totalRead < len; totalRead += bytesRead) {
            int bytesToRead = Math.min(len - totalRead, 8192);
            if (this.buf.length < bytesToRead) {
                this.buf = new byte[bytesToRead];
            }
            if (totalRead > 0 && this.in.available() <= 0) break;
            try {
                this.begin();
                bytesRead = this.in.read(this.buf, 0, bytesToRead);
                this.end(bytesRead > 0);
            }
            catch (Throwable throwable) {
                this.end(bytesRead > 0);
                throw throwable;
            }
            if (bytesRead < 0) break;
            dst.put(this.buf, 0, bytesRead);
        }
        if (bytesRead < 0 && totalRead == 0) {
            return -1;
        }
        return totalRead;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.in.close();
    }
}

