/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.textures;

import cpw.mods.fml.common.ProgressManager;
import java.util.Iterator;
import me.eigenraven.lwjgl3ify.Lwjgl3ify;
import me.eigenraven.lwjgl3ify.api.Lwjgl3Aware;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.stb.STBRPContext;
import org.lwjgl.stb.STBRPNode;
import org.lwjgl.stb.STBRPRect;
import org.lwjgl.stb.STBRectPack;

@Lwjgl3Aware
public class StbStitcher {
    public static Pair<Integer, Integer> packRects(Stitcher.Holder[] holders) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Stitch setup", (int)((holders.length + 99) / 100));
        int holderSize = holders.length;
        try (STBRPRect.Buffer rectBuf = STBRPRect.malloc((int)holderSize);
             STBRPContext ctx = STBRPContext.malloc();){
            int sqSize = 0;
            int maxW = 16;
            int maxH = 16;
            for (int j = 0; j < holderSize; ++j) {
                Stitcher.Holder holder = holders[j];
                if (j % 100 == 0 && bar.getStep() < bar.getSteps()) {
                    bar.step(holder.getAtlasSprite().getIconName());
                }
                int width = holder.getWidth();
                int height = holder.getHeight();
                ((STBRPRect)rectBuf.get(j)).set(j, width, height, 0, 0, false);
                sqSize += width * height;
                maxW = Math.max(maxW, width);
                maxH = Math.max(maxH, height);
            }
            maxW = MathHelper.roundUpToPowerOfTwo((int)maxW);
            maxH = MathHelper.roundUpToPowerOfTwo((int)maxH);
            int guessedSqSide = MathHelper.roundUpToPowerOfTwo((int)((int)Math.ceil(Math.sqrt(sqSize))));
            int atlasWidth = Math.max(guessedSqSide, maxW * 2);
            int atlasHeight = Math.max(guessedSqSide, maxH * 2);
            boolean doubleX = true;
            for (int retries = 0; retries < 10; ++retries) {
                try (STBRPNode.Buffer nodes = STBRPNode.malloc((int)(atlasWidth + 32));){
                    STBRectPack.stbrp_init_target((STBRPContext)ctx, (int)atlasWidth, (int)atlasHeight, (STBRPNode.Buffer)nodes);
                    if (STBRectPack.stbrp_pack_rects((STBRPContext)ctx, (STBRPRect.Buffer)rectBuf) == 0) {
                        if (doubleX) {
                            atlasWidth *= 2;
                        } else {
                            atlasHeight *= 2;
                        }
                        doubleX = !doubleX;
                        continue;
                    }
                    for (STBRPRect rect : rectBuf) {
                        Stitcher.Holder holder = holders[rect.id()];
                        if (!rect.was_packed()) {
                            throw new StitcherException(holder, "Could not fit " + holder.getAtlasSprite().getIconName() + " into " + atlasWidth + "x" + atlasHeight + " atlas!");
                        }
                        holder.getAtlasSprite().initSprite(atlasWidth, atlasHeight, rect.x(), rect.y(), false);
                    }
                    while (bar.getStep() < bar.getSteps()) {
                        Lwjgl3ify.LOG.warn("Progressbar calculation was off");
                        bar.step("noop");
                    }
                    ProgressManager.pop((ProgressManager.ProgressBar)bar);
                    Iterator iterator = Pair.of((Object)atlasWidth, (Object)atlasHeight);
                    return iterator;
                }
            }
            throw new IllegalStateException("Could not fit all sprites into an atlas of size " + atlasWidth + "x" + atlasHeight);
        }
    }
}

