/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx;

import me.eigenraven.lwjgl3ify.Lwjgl3ify;
import me.eigenraven.lwjgl3ify.api.InputEvents;
import me.eigenraven.lwjgl3ify.client.MainThreadExec;
import me.eigenraven.lwjgl3ify.core.Config;
import org.lwjgl.sdl.SDLEvents;
import org.lwjgl.sdl.SDLInit;
import org.lwjgl.sdl.SDLKeyboard;
import org.lwjgl.sdl.SDLMouse;
import org.lwjgl.sdl.SDL_Event;
import org.lwjgl.sdl.SDL_KeyboardEvent;
import org.lwjgl.sdl.SDL_MouseButtonEvent;
import org.lwjgl.sdl.SDL_MouseMotionEvent;
import org.lwjgl.sdl.SDL_MouseWheelEvent;
import org.lwjgl.sdl.SDL_TextInputEvent;
import org.lwjgl.sdl.SDL_WindowEvent;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.input.KeyCodes;
import org.lwjglx.input.Keyboard;
import org.lwjglx.input.Mouse;
import org.lwjglx.opengl.Display;

public class Lwjgl3ifyEventLoop {
    public static final SDL_Event event = SDL_Event.calloc();
    public static final SDL_WindowEvent windowEvent = event.window();
    public static final SDL_KeyboardEvent keyEvent = event.key();
    public static final SDL_TextInputEvent textEvent = event.text();
    public static final SDL_MouseMotionEvent mouseMotionEvent = event.motion();
    public static final SDL_MouseButtonEvent mouseButtonEvent = event.button();
    public static final SDL_MouseWheelEvent mouseWheelEvent = event.wheel();

    public static void pumpEvents() {
        MainThreadExec.runOnMainThread(Lwjgl3ifyEventLoop::internalPumpEvents);
    }

    private static void internalPumpEvents() {
        if (!SDLInit.SDL_IsMainThread()) {
            throw new IllegalStateException("SDL Event pump called from a non-main thread " + Thread.currentThread());
        }
        block7: while (SDLEvents.SDL_PollEvent((SDL_Event)event)) {
            if (Display.lwjgl3ify$handleSdlEvent()) continue;
            switch (event.type()) {
                case 1024: {
                    if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                        Lwjgl3ify.LOG.info("[DEBUG-MOUSE] Motion ns:{} x:{} y:{} xrel:{} yrel:{}", new Object[]{mouseMotionEvent.timestamp(), Float.valueOf(mouseMotionEvent.x()), Float.valueOf(mouseMotionEvent.y()), Float.valueOf(mouseMotionEvent.xrel()), Float.valueOf(mouseMotionEvent.yrel())});
                    }
                    Mouse.addMoveEvent(mouseMotionEvent);
                    continue block7;
                }
                case 1025: 
                case 1026: {
                    if (Config.DEBUG_PRINT_MOUSE_EVENTS) {
                        Lwjgl3ify.LOG.info("[DEBUG-MOUSE] Press ns:{} button:{} press:{} clicks:{} x:{} y:{}", new Object[]{mouseButtonEvent.timestamp(), mouseButtonEvent.button(), mouseButtonEvent.down(), mouseButtonEvent.clicks(), Float.valueOf(mouseButtonEvent.x()), Float.valueOf(mouseButtonEvent.y())});
                    }
                    Mouse.addButtonEvent(Mouse.sdlToLwjglMouseButton(mouseButtonEvent.button()), event.type() == 1025);
                    continue block7;
                }
                case 1027: {
                    float xoffset = mouseWheelEvent.x();
                    float yoffset = mouseWheelEvent.y();
                    Mouse.addWheelEvent(yoffset == 0.0f ? (double)(Config.INPUT_INVERT_X_WHEEL ? -xoffset : xoffset) : (double)yoffset);
                    continue block7;
                }
                case 768: 
                case 769: {
                    Lwjgl3ifyEventLoop.handleKeyEvent();
                    continue block7;
                }
                case 771: {
                    Lwjgl3ifyEventLoop.handleTextEvent();
                    continue block7;
                }
            }
        }
        Mouse.sdlMouseButtonFlags = SDLMouse.nSDL_GetMouseState((long)0L, (long)0L);
    }

    private static char rawKeyCodeToChar(int rawKeyCode) {
        if (rawKeyCode < 65535) {
            return (char)rawKeyCode;
        }
        return '\u0000';
    }

    private static void handleKeyEvent() {
        long ns = keyEvent.timestamp();
        boolean isDown = keyEvent.down();
        boolean isRepeat = keyEvent.repeat();
        short kmods = keyEvent.mod();
        int keyCode = keyEvent.key();
        int scanCode = keyEvent.scancode();
        long keyNamePtr = SDLKeyboard.nSDL_GetKeyName((int)keyCode);
        int rawKeyCode = SDLKeyboard.SDL_GetKeyFromScancode((int)scanCode, (short)kmods, (boolean)false);
        int lwjgl2KeyCode = KeyCodes.sdlKeycodeToLwjgl(keyCode);
        int lwjgl2ScanCode = KeyCodes.sdlScancodeToLwjgl(keyCode);
        if (Config.DEBUG_PRINT_KEY_EVENTS) {
            Lwjgl3ify.LOG.info("[DEBUG-KEY] key ns:{} key:{} ({}) rawKey:{} scancode:{} isDown:{} {} mods:{} naive-char:{}", new Object[]{ns, keyCode, MemoryUtil.memUTF8Safe((long)keyNamePtr), rawKeyCode, scanCode, isDown ? "PRESS" : "RELEASE", isRepeat ? "REPEAT" : "", kmods, Character.valueOf(rawKeyCode >= 32 && rawKeyCode < 0xFFFFFF ? (char)rawKeyCode : (char)'?')});
        }
        InputEvents.KeyAction enumAction = isDown ? (isRepeat ? InputEvents.KeyAction.REPEATED : InputEvents.KeyAction.PRESSED) : InputEvents.KeyAction.RELEASED;
        InputEvents.injectKeyEvent(new InputEvents.KeyEvent(lwjgl2KeyCode, lwjgl2ScanCode, keyCode, scanCode, rawKeyCode, enumAction, kmods, keyNamePtr));
        if (rawKeyCode >= 32 && rawKeyCode <= 126) {
            boolean ctrlGraphicalMode;
            boolean isAltGr;
            boolean isAlt = (kmods & 0x300) != 0;
            boolean bl = isAltGr = (kmods & 0x200) != 0;
            if (isAlt) {
                ctrlGraphicalMode = isAltGr ? !Config.INPUT_ALTGR_ESCAPE_CODES : Config.INPUT_CTRL_ALT_TEXT;
                if (ctrlGraphicalMode) {
                    Keyboard.addSdlKeyEvent(keyCode, scanCode, enumAction, kmods, (char)(rawKeyCode & 0x1F), ns);
                }
            } else {
                ctrlGraphicalMode = false;
            }
            if ((0xC00 & kmods) != 0) {
                Keyboard.addSdlKeyEvent(keyCode, scanCode, enumAction, kmods, Lwjgl3ifyEventLoop.rawKeyCodeToChar(rawKeyCode), ns);
            } else if ((0xC0 & kmods) != 0 && !ctrlGraphicalMode) {
                if (Config.DEBUG_PRINT_KEY_EVENTS) {
                    Lwjgl3ify.LOG.info("[DEBUG-KEY] Handling key as escape code, skipping next char input. isAlt:{} isAltGr:{}", new Object[]{isAlt, isAltGr});
                }
                Keyboard.addSdlKeyEvent(keyCode, scanCode, enumAction, kmods, (char)(rawKeyCode & 0x1F), ns);
            } else {
                Keyboard.addSdlKeyEvent(keyCode, scanCode, enumAction, kmods, Lwjgl3ifyEventLoop.rawKeyCodeToChar(rawKeyCode), ns);
            }
        } else {
            Keyboard.addSdlKeyEvent(keyCode, scanCode, enumAction, kmods, Lwjgl3ifyEventLoop.rawKeyCodeToChar(rawKeyCode), ns);
        }
    }

    private static void handleTextEvent() {
        long ns = textEvent.timestamp();
        String text = textEvent.textString();
        if (text == null) {
            return;
        }
        if (Config.DEBUG_PRINT_KEY_EVENTS) {
            Lwjgl3ify.LOG.info("[DEBUG-KEY] ns:{} text:<{}>", new Object[]{ns, text});
        }
        InputEvents.injectTextEvent(new InputEvents.TextEvent(text));
        text.chars().forEachOrdered(c -> Keyboard.addCharEvent(0, c));
    }
}

