/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.opengl;

import me.eigenraven.lwjgl3ify.client.MainThreadExec;
import org.lwjgl.opengl.GL11;
import org.lwjgl.sdl.SDLVideo;
import org.lwjglx.LWJGLException;
import org.lwjglx.PointerBuffer;
import org.lwjglx.Sys;
import org.lwjglx.opengl.ContextAttribs;
import org.lwjglx.opengl.ContextGL;
import org.lwjglx.opengl.Display;
import org.lwjglx.opengl.DrawableLWJGL;
import org.lwjglx.opengl.GlobalLock;
import org.lwjglx.opengl.PeerInfo;
import org.lwjglx.opengl.PixelFormat;
import org.lwjglx.opengl.PixelFormatLWJGL;
import org.lwjglx.opengl.Util;

public class DrawableGL
implements DrawableLWJGL {
    protected PixelFormat pixel_format;
    protected PeerInfo peer_info;
    protected ContextGL context;

    protected DrawableGL() {
        this(Display.sdlWindow, Display.sdlMainGlContext, false);
    }

    protected DrawableGL(ContextGL gl) {
        this.context = gl;
    }

    protected DrawableGL(long window, long context, boolean shared) {
        this.context = new ContextGL(window, context, shared);
    }

    @Override
    public void setPixelFormat(PixelFormatLWJGL pf) throws LWJGLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPixelFormat(PixelFormatLWJGL pf, ContextAttribs attribs) throws LWJGLException {
        this.pixel_format = (PixelFormat)pf;
    }

    @Override
    public PixelFormatLWJGL getPixelFormat() {
        return this.pixel_format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContextGL getContext() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            return this.context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContextGL createSharedContext() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            return MainThreadExec.runOnMainThread(() -> {
                long prevCtx = SDLVideo.SDL_GL_GetCurrentContext();
                long prevWin = SDLVideo.SDL_GL_GetCurrentWindow();
                Sys.checkSdl(SDLVideo.SDL_GL_MakeCurrent((long)Display.sdlHiddenWindow, (long)Display.sdlCloneableGlContext));
                long newWin = Sys.checkSdl(SDLVideo.SDL_CreateWindow((CharSequence)("lwjgl3ify-sharedContext-" + Display.sdlMainGlContext), (int)1, (int)1, (long)10L));
                long newCtx = Sys.checkSdl(SDLVideo.SDL_GL_CreateContext((long)newWin));
                Sys.checkSdl(SDLVideo.SDL_GL_MakeCurrent((long)prevWin, (long)prevCtx));
                return new ContextGL(newWin, newCtx, true);
            });
        }
    }

    @Override
    public void checkGLError() {
        Util.checkGLError();
    }

    @Override
    public void setSwapInterval(int swap_interval) {
        ContextGL.setSwapInterval(swap_interval);
    }

    @Override
    public void swapBuffers() {
        ContextGL.swapBuffers();
    }

    @Override
    public void initContext(float r, float g, float b) {
        GL11.glClearColor((float)r, (float)g, (float)b, (float)0.0f);
        GL11.glClear((int)16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrent() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            this.checkDestroyed();
            return this.context.isCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeCurrent() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            this.checkDestroyed();
            this.context.makeCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseContext() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.context.isCurrent()) {
                this.context.releaseCurrent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            if (this.context == null) {
                return;
            }
            this.releaseContext();
            this.context.forceDestroy();
            this.context = null;
            if (this.peer_info != null) {
                this.peer_info.destroy();
                this.peer_info = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCLSharingProperties(PointerBuffer properties) {
        Object object = GlobalLock.lock;
        synchronized (object) {
            this.checkDestroyed();
            this.context.setCLSharingProperties(properties);
        }
    }

    protected final void checkDestroyed() {
        if (this.context == null) {
            throw new IllegalStateException("The Drawable has no context available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSdlWindowId() {
        Object object = GlobalLock.lock;
        synchronized (object) {
            return this.context.sdlWindow;
        }
    }
}

