/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.opengl;

import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjglx.PointerWrapperAbstract;

public class KHRDebugCallback
extends PointerWrapperAbstract
implements GLDebugMessageCallbackI {
    private static final int GL_DEBUG_SEVERITY_HIGH = 37190;
    private static final int GL_DEBUG_SEVERITY_MEDIUM = 37191;
    private static final int GL_DEBUG_SEVERITY_LOW = 37192;
    private static final int GL_DEBUG_SEVERITY_NOTIFICATION = 33387;
    private static final int GL_DEBUG_SOURCE_API = 33350;
    private static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
    private static final int GL_DEBUG_SOURCE_SHADER_COMPILER = 33352;
    private static final int GL_DEBUG_SOURCE_THIRD_PARTY = 33353;
    private static final int GL_DEBUG_SOURCE_APPLICATION = 33354;
    private static final int GL_DEBUG_SOURCE_OTHER = 33355;
    private static final int GL_DEBUG_TYPE_ERROR = 33356;
    private static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
    private static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
    private static final int GL_DEBUG_TYPE_PORTABILITY = 33359;
    private static final int GL_DEBUG_TYPE_PERFORMANCE = 33360;
    private static final int GL_DEBUG_TYPE_OTHER = 33361;
    private static final int GL_DEBUG_TYPE_MARKER = 33384;
    private static final long CALLBACK_POINTER;
    private final Handler handler;

    public KHRDebugCallback() {
        this(new Handler(){

            @Override
            public void handleMessage(int source, int type, int id, int severity, String message) {
                String string;
                String string2;
                String string3;
                System.err.println("[LWJGL] KHR_debug message");
                System.err.println("\tID: " + id);
                switch (source) {
                    case 33350: {
                        string3 = "API";
                        break;
                    }
                    case 33351: {
                        string3 = "WINDOW SYSTEM";
                        break;
                    }
                    case 33352: {
                        string3 = "SHADER COMPILER";
                        break;
                    }
                    case 33353: {
                        string3 = "THIRD PARTY";
                        break;
                    }
                    case 33354: {
                        string3 = "APPLICATION";
                        break;
                    }
                    case 33355: {
                        string3 = "OTHER";
                        break;
                    }
                    default: {
                        string3 = this.printUnknownToken(source);
                    }
                }
                String description = string3;
                System.err.println("\tSource: " + description);
                switch (type) {
                    case 33356: {
                        string2 = "ERROR";
                        break;
                    }
                    case 33357: {
                        string2 = "DEPRECATED BEHAVIOR";
                        break;
                    }
                    case 33358: {
                        string2 = "UNDEFINED BEHAVIOR";
                        break;
                    }
                    case 33359: {
                        string2 = "PORTABILITY";
                        break;
                    }
                    case 33360: {
                        string2 = "PERFORMANCE";
                        break;
                    }
                    case 33361: {
                        string2 = "OTHER";
                        break;
                    }
                    case 33384: {
                        string2 = "MARKER";
                        break;
                    }
                    default: {
                        string2 = this.printUnknownToken(type);
                    }
                }
                description = string2;
                System.err.println("\tType: " + description);
                switch (severity) {
                    case 37190: {
                        string = "HIGH";
                        break;
                    }
                    case 37191: {
                        string = "MEDIUM";
                        break;
                    }
                    case 37192: {
                        string = "LOW";
                        break;
                    }
                    case 33387: {
                        string = "NOTIFICATION";
                        break;
                    }
                    default: {
                        string = this.printUnknownToken(severity);
                    }
                }
                description = string;
                System.err.println("\tSeverity: " + description);
                System.err.println("\tMessage: " + message);
            }

            private String printUnknownToken(int token) {
                return "Unknown (0x" + Integer.toHexString(token).toUpperCase() + ")";
            }
        });
    }

    public KHRDebugCallback(Handler handler) {
        super(CALLBACK_POINTER);
        this.handler = handler;
    }

    Handler getHandler() {
        return this.handler;
    }

    public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
        if (this.handler == null) {
            return;
        }
        this.handler.handleMessage(source, type, id, severity, GLDebugMessageCallback.getMessage((int)length, (long)message));
    }

    @Override
    public long address() {
        return super.address();
    }

    static {
        long pointer = 0L;
        try {
            pointer = (Long)Class.forName("org.lwjgl.opengl.CallbackUtil").getDeclaredMethod("getDebugCallbackKHR", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CALLBACK_POINTER = pointer;
    }

    public static interface Handler {
        public void handleMessage(int var1, int var2, int var3, int var4, String var5);
    }
}

