/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.components.ClosableTabComponent;
import com.github.weisj.darklaf.components.TabEvent;
import com.github.weisj.darklaf.components.TabListener;
import com.github.weisj.darklaf.components.TabPropertyChangeEvent;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ClosableTabbedPane
extends JTabbedPane {
    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        if (this.notifyVetoableChangeListeners(new TabPropertyChangeEvent(this, TabEvent.Type.TAB_OPENED.getCommand(), null, component, index))) {
            return;
        }
        super.insertTab(title, icon, component, tip, index);
        this.setTabComponentAt(this.indexOfComponent(component), new ClosableTabComponent(this));
        this.notifyTabListeners(new TabEvent(this, TabEvent.Type.TAB_OPENED, index, component));
    }

    @Override
    public void removeTabAt(int index) {
        this.checkIndex(index);
        Component c = this.getComponentAt(index);
        if (this.notifyVetoableChangeListeners(new TabPropertyChangeEvent(this, TabEvent.Type.TAB_CLOSING.getCommand(), this.getComponentAt(index), null, index))) {
            return;
        }
        this.notifyTabListeners(new TabEvent(this, TabEvent.Type.TAB_CLOSING, index, c));
        super.removeTabAt(index);
        this.notifyTabListeners(new TabEvent(this, TabEvent.Type.TAB_CLOSED, index, c));
    }

    @Override
    public void setTabComponentAt(int index, Component component) {
        if (component instanceof ClosableTabComponent) {
            ((ClosableTabComponent)component).setTabbedPane(this);
            super.setTabComponentAt(index, component);
        } else {
            super.setTabComponentAt(index, new ClosableTabComponent(this, component));
        }
    }

    public ClosableTabComponent getClosableTabComponent(int index) {
        return DarkUIUtil.nullableCast(ClosableTabComponent.class, super.getTabComponentAt(index));
    }

    public void setTabClosable(int index, boolean closable) {
        ClosableTabComponent tab = this.getClosableTabComponent(index);
        if (tab != null) {
            tab.setClosable(closable);
        }
    }

    public boolean isTabClosable(int index) {
        ClosableTabComponent tab = this.getClosableTabComponent(index);
        return tab != null && tab.isClosable();
    }

    private void checkIndex(int index) {
        int tabCount = this.getTabCount();
        if (index < 0 || index >= tabCount) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Tab count: " + tabCount);
        }
    }

    private boolean notifyVetoableChangeListeners(TabPropertyChangeEvent e) {
        try {
            VetoableChangeListener[] listeners;
            for (VetoableChangeListener l : listeners = this.getVetoableChangeListeners()) {
                l.vetoableChange(e);
            }
        }
        catch (PropertyVetoException ex) {
            return true;
        }
        return false;
    }

    @Override
    public void setEnabledAt(int index, boolean enabled) {
        super.setEnabledAt(index, enabled);
    }

    private void notifyTabListeners(TabEvent event) {
        TabListener[] listeners = (TabListener[])this.listenerList.getListeners(TabListener.class);
        switch (event.getType()) {
            case TAB_CLOSED: {
                for (TabListener l : listeners) {
                    l.tabClosed(event);
                }
                break;
            }
            case TAB_OPENED: {
                for (TabListener l : listeners) {
                    l.tabOpened(event);
                }
                break;
            }
            case TAB_CLOSING: {
                for (TabListener l : listeners) {
                    l.tabClosing(event);
                }
                break;
            }
        }
    }

    public void addTabListener(TabListener listener) {
        this.listenerList.add(TabListener.class, listener);
    }

    public void removeTabListener(TabListener listener) {
        this.listenerList.remove(TabListener.class, listener);
    }
}

