/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.platform.windows.JNIDecorationsWindows;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public final class PointerUtil {
    private static final Logger LOGGER = LogUtil.getLogger(PointerUtil.class);

    public static WindowPointer getHWND(Component component) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        String javaLibPath = SystemInfo.JAVA_HOME != null ? SystemInfo.JAVA_HOME + "/bin/jawt.dll" : "jawt.dll";
        try {
            return new WindowPointer(JNIDecorationsWindows.getWindowHWND(window, javaLibPath));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Couldn't get HWND of window " + component, e);
            return new WindowPointer(0L);
        }
    }

    public static class WindowPointer {
        private final long hwnd;

        public WindowPointer(long hwnd) {
            this.hwnd = hwnd;
        }

        public boolean isValid() {
            return this.hwnd != 0L;
        }

        public long value() {
            return this.hwnd;
        }

        public String toString() {
            return String.valueOf(this.hwnd);
        }
    }
}

