/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.BlendMode;
import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.nodes.filter.BlendComposite;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={})
public final class FeBlend
extends FilterPrimitive {
    public static final String TAG = "feblend";
    private Object inputChannel2;
    private BlendComposite composite;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.inputChannel2 = attributeNode.getValue("in2");
        if (this.inputChannel2 == null) {
            this.inputChannel2 = DefaultFilterChannel.LastResult;
        }
        BlendMode blendMode = attributeNode.getEnum("mode", BlendMode.Normal);
        this.composite = new BlendComposite(blendMode);
    }

    @Override
    public void applyFilter(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull FilterContext filterContext) {
        Channel in = this.inputChannel(filterContext);
        Channel in2 = this.channel(this.inputChannel2, filterContext);
        BufferedImage dst = in.toBufferedImageNonAliased(context);
        Graphics2D imgGraphics = (Graphics2D)dst.getGraphics();
        imgGraphics.setComposite(this.composite);
        imgGraphics.drawImage(context.createImage(in2.producer()), null, context.targetComponent());
        imgGraphics.dispose();
        this.saveResult(new ImageProducerChannel(dst.getSource()), filterContext);
    }
}

