/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.mixins.early.fml;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Field;
import net.minecraft.init.Blocks;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(targets={"cpw.mods.fml.common.registry.ObjectHolderRef"}, remap=false)
public class ObjectHolderRef {
    @Shadow(remap=false)
    private Field field;
    @Shadow(remap=false)
    private String injectedObject;
    @Shadow(remap=false)
    private boolean isBlock;
    @Shadow(remap=false)
    private boolean isItem;

    @Overwrite(remap=false)
    public static void makeWritable(Field f) {
        try {
            f.setAccessible(true);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Overwrite(remap=false)
    public void apply() {
        Object thing;
        if (this.isBlock) {
            FMLControlledNamespacedRegistry registry = GameData.getBlockRegistry();
            thing = registry.getObject(this.injectedObject);
            if (thing == Blocks.air) {
                thing = null;
            }
        } else if (this.isItem) {
            FMLControlledNamespacedRegistry registry = GameData.getItemRegistry();
            thing = registry.getObject(this.injectedObject);
        } else {
            thing = null;
        }
        if (thing == null) {
            FMLLog.getLogger().log(Level.DEBUG, "Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", new Object[]{this.injectedObject, this.field});
            return;
        }
        try {
            this.field.set(null, thing);
            FMLLog.finer((String)("Set field " + this.field.toString() + " to " + thing), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.log((Level)Level.WARN, (Throwable)e, (String)"Unable to set %s with value %s (%s)", (Object[])new Object[]{this.field, thing, this.injectedObject});
        }
    }
}

