/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.treetable;

import com.github.weisj.darklaf.components.treetable.DefaultTreeTableCellRenderer;
import com.github.weisj.darklaf.components.treetable.TreeTableModelAdapter;
import com.github.weisj.darklaf.components.treetable.TreeTableTree;
import com.github.weisj.darklaf.components.treetable.model.AbstractTreeTableModel;
import com.github.weisj.darklaf.components.treetable.model.DefaultTreeTableSelectionModel;
import com.github.weisj.darklaf.components.treetable.model.TreeTableModel;
import com.github.weisj.darklaf.ui.cell.hint.CellHintPopupListener;
import com.github.weisj.darklaf.ui.tree.DarkTreeUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class JTreeTable
extends JTable
implements TreeSelectionListener {
    private final TreeTableTree tree;

    public JTreeTable(AbstractTreeTableModel treeTableModel) {
        Logger.getGlobal().warning("JTreeTable is unstable and an experimental component");
        DefaultTreeTableCellRenderer treeCellRenderer = new DefaultTreeTableCellRenderer(this, treeTableModel);
        this.tree = treeCellRenderer.getTree();
        this.add(this.tree);
        this.tree.putClientProperty("JComponent.isTableTree", true);
        DefaultTreeTableSelectionModel selectionModel = new DefaultTreeTableSelectionModel(this.tree);
        this.tree.setSelectionModel(selectionModel);
        this.setSelectionModel(selectionModel);
        this.tree.addTreeSelectionListener(this);
        this.setDefaultRenderer(TreeTableModel.class, treeCellRenderer);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        this.setShowHorizontalLines(false);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        int grid = this.getShowVerticalLines() ? this.getIntercellSpacing().width : 0;
        this.tree.setBounds(0, 0, this.getColumnModel().getColumn(0).getWidth() - grid, this.getHeight());
    }

    @Override
    public void repaint(Rectangle r) {
        super.repaint(r);
        SwingUtilities.invokeLater(() -> {
            CellHintPopupListener<JTree, ?> listener;
            DarkTreeUI ui = DarkUIUtil.getUIOfType(this.tree.getUI(), DarkTreeUI.class);
            if (ui != null && (listener = ui.getPopupListener()) != null) {
                listener.repaint();
            }
        });
    }

    @Override
    public int getComponentCount() {
        return 0;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof InputEvent) {
            if (e instanceof KeyEvent && this.getColumnModel().getSelectionModel().getLeadSelectionIndex() == 0 && !((KeyEvent)e).isShiftDown()) {
                this.tree.processEvent(e);
            }
            if (((InputEvent)e).isConsumed()) {
                return;
            }
        }
        super.processEvent(e);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!"none".equals(PropertyUtil.getString(this.tree, "JTree.lineStyle", ""))) {
            this.repaint(0, 0, this.getColumnModel().getColumn(0).getWidth(), this.getHeight());
        }
    }
}

