/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.parser;

import com.github.weisj.darklaf.properties.parser.ParseResult;
import com.github.weisj.darklaf.properties.parser.Parser;
import com.github.weisj.darklaf.properties.parser.ParserContext;
import com.github.weisj.darklaf.properties.parser.ParserUtil;
import com.github.weisj.darklaf.properties.parser.PropertyParser;

public class ReferenceParser
implements PropertyParser {
    private static final String REFERENCE_PREFIX = "%";

    @Override
    public ParseResult doParse(ParseResult parseResult, ParserContext context) {
        ParserUtil.stripPrefixFromKey(parseResult, REFERENCE_PREFIX);
        parseResult.save();
        if (ParserUtil.stripPrefixFromValue(parseResult, REFERENCE_PREFIX)) {
            ParserUtil.replaceIfNull(parseResult, parseResult.value, context.accumulator);
            ParserUtil.replaceIfNull(parseResult, parseResult.value, context.defaults);
            if (!parseResult.finished) {
                parseResult.warnings.add("Could not reference value '" + parseResult.value + "' while loading '" + parseResult.key + "'. Maybe it's a forward reference.");
                parseResult.restore();
            } else if (parseResult instanceof Parser.DebugParseResult) {
                ((Parser.DebugParseResult)parseResult).referenceKey = REFERENCE_PREFIX + parseResult.value;
            }
        }
        return parseResult;
    }
}

