/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public abstract class TabButtonContainer
extends JPanel
implements UIResource {
    protected final JButton button;
    protected final DarkTabbedPaneUI tabbedPaneUI;
    private final Insets borderInsets;

    protected TabButtonContainer(DarkTabbedPaneUI tabbedPaneUI) {
        this.tabbedPaneUI = tabbedPaneUI;
        this.borderInsets = UIManager.getInsets("TabbedPane.tabArea.buttonInsets");
        this.button = this.createButton();
        this.add(this.button);
        this.setOpaque(false);
        this.setLayout(null);
    }

    protected abstract JButton createButton();

    @Override
    public void doLayout() {
        Dimension b = this.button.getPreferredSize();
        int w = Math.min(this.getWidth(), b.width);
        int h = Math.min(this.getHeight(), b.height);
        int x = (this.getWidth() - w) / 2;
        int y = (this.getHeight() - h) / 2;
        this.button.setBounds(x, y, w, h);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.doLayout();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.tabbedPaneUI.paintTabAreaBorder(g, this.tabbedPaneUI.tabPane.getTabPlacement(), 0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return DarkUIUtil.addInsets(this.button.getPreferredSize(), this.getInsets());
    }

    @Override
    public Insets getInsets() {
        if (this.tabbedPaneUI.isHorizontalTabPlacement()) {
            return new Insets(0, this.borderInsets.left, 0, this.borderInsets.right);
        }
        return new Insets(this.borderInsets.top, 0, this.borderInsets.bottom, 0);
    }
}

