/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text.bridge;

import com.github.weisj.darklaf.ui.text.DarkTextUI;
import com.github.weisj.darklaf.ui.text.dummy.DummyEditorPane;
import com.github.weisj.darklaf.ui.text.dummy.DummyEditorPaneUI;
import com.github.weisj.darklaf.ui.text.dummy.DummyTextUIMethods;
import com.github.weisj.darklaf.util.value.WeakShared;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;

public abstract class DarkEditorPaneUIBridge
extends DarkTextUI {
    private static final WeakShared<DummyEditorPane> shareDummyEditorPane = new WeakShared<DummyEditorPane>(DummyEditorPane::new);
    private static final WeakShared<DummyTextUIMethods> sharedDummyUI = new WeakShared<DummyTextUIMethods>(DummyEditorPaneUI::new);
    private DummyEditorPane editorPane;
    private DummyTextUIMethods basicEditorPaneUI;
    private PropertyChangeListener propertyChangeListener;

    @Override
    public void installUI(JComponent c) {
        this.editorPane = this.createDummyEditorPane();
        this.basicEditorPaneUI = this.createDummyUI();
        this.editorPane.setEditorPane((JEditorPane)c);
        this.basicEditorPaneUI.installUI(this.editorPane);
        super.installUI(c);
        this.updateDisplayProperties();
    }

    protected DummyTextUIMethods createDummyUI() {
        return sharedDummyUI.get();
    }

    protected DummyEditorPane createDummyEditorPane() {
        return shareDummyEditorPane.get();
    }

    @Override
    protected void installListeners() {
        this.propertyChangeListener = this.editorPane.getPropertyChangeListener();
        super.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.cleanDisplayProperties(c);
        super.uninstallUI(c);
        this.editorPane.setEditorPane(null);
        this.editorPane.addPropertyChangeListener(null);
        this.editorPane = null;
        this.basicEditorPaneUI = null;
    }

    protected void updateDisplayProperties() {
        this.editorPane.setEditorPane((JEditorPane)this.editor);
        this.updateDisplayProperties((JEditorPane)this.getComponent(), new PropertyChangeEvent(this.editorPane, "font", this.editorPane.getFont(), this.editorPane.getFont()));
    }

    protected void updateDisplayProperties(JEditorPane c, PropertyChangeEvent event) {
        this.editorPane.setEditorPane(c);
        this.basicEditorPaneUI.propertyChange(event);
    }

    protected void cleanDisplayProperties(JComponent c) {
        this.editorPane.setEditorPane((JEditorPane)c);
        this.basicEditorPaneUI.uninstallUI(this.editorPane);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateActionMap();
    }

    protected void updateFocusAcceleratorBinding(PropertyChangeEvent event) {
        this.propertyChangeListener.propertyChange(event);
    }

    protected void updateActionMap() {
        this.editorPane.setActionMap(new ActionMap());
        this.editorPane.setEditorPane((JEditorPane)this.getComponent());
        this.basicEditorPaneUI.installKeyBoardActionsReal();
        ActionMap map = this.editorPane.getActionMap();
        SwingUtilities.replaceUIActionMap(this.getComponent(), map);
        this.installDarkKeyBoardActions();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String name = evt.getPropertyName();
        if ("editorKit".equals(name) || "editable".equals(name)) {
            this.editorPane.setEditorPane((JEditorPane)this.getComponent());
            this.basicEditorPaneUI.propertyChange(evt);
        } else if ("foreground".equals(name) || "font".equals(name) || "document".equals(name) || "JEditorPane.w3cLengthUnits".equals(name) || "JEditorPane.honorDisplayProperties".equals(name)) {
            this.updateDisplayProperties((JEditorPane)this.getComponent(), evt);
        } else if ("focusAccelerator".equals(name)) {
            this.updateFocusAcceleratorBinding(evt);
        }
    }

    @Override
    public EditorKit getEditorKit(JTextComponent tc) {
        JEditorPane pane = (JEditorPane)this.getComponent();
        return pane.getEditorKit();
    }
}

