/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.rfb;

import com.google.common.base.Throwables;
import com.gtnewhorizons.retrofuturabootstrap.api.PluginContext;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPlugin;
import java.awt.GraphicsEnvironment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.swing.JOptionPane;
import me.eigenraven.lwjgl3ify.rfb.transformers.ExtensibleEnumTransformer;
import me.eigenraven.lwjgl3ify.rfb.transformers.ForgePatchTransformer;
import me.eigenraven.lwjgl3ify.rfb.transformers.LwjglRedirectTransformer;
import me.eigenraven.lwjgl3ify.rfb.transformers.UnfinalizeObjectHoldersTransformer;
import net.minecraft.launchwrapper.Launch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Lwjgl3ifyRfbPlugin
implements RfbPlugin {
    public void onConstruction(@NotNull PluginContext ctx) {
        Launch.classLoader.addClassLoaderExclusion("me.eigenraven.lwjgl3ify.rfb.EarlyConfig");
        Launch.blackboard.put("lwjgl3ify:rfb-booted", Boolean.TRUE);
        try {
            Class<?> earlyConfig = Class.forName("me.eigenraven.lwjgl3ify.rfb.EarlyConfig");
            MethodHandles.lookup().findStatic(earlyConfig, "load", MethodType.methodType(Void.TYPE)).invokeExact();
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.verifyJavaVersion();
        Launch.classLoader.addClassLoaderExclusion("org.openjdk.nashorn");
        Launch.classLoader.addClassLoaderExclusion("jakarta.xml.bind.");
        Launch.classLoader.addClassLoaderExclusion("org.glassfish.jaxb.");
        Launch.classLoader.addClassLoaderExclusion("com.sun.istack.");
        Launch.classLoader.addTransformerExclusion("org.lwjgl.");
        Launch.classLoader.addTransformerExclusion("org.lwjglx.");
    }

    public @NotNull RfbClassTransformer @Nullable [] makeTransformers() {
        return new RfbClassTransformer[]{new LwjglRedirectTransformer(), new ExtensibleEnumTransformer(), new UnfinalizeObjectHoldersTransformer(), new ForgePatchTransformer()};
    }

    private void verifyJavaVersion() {
        String specVer;
        if (!Boolean.getBoolean("lwjgl3ify.skipjavacheck") && (specVer = System.getProperty("java.specification.version")).equals("17")) {
            try {
                Class<?> cRuntime = Class.forName("java.lang.Runtime");
                Class<?> cRuntimeVersion = Class.forName("java.lang.Runtime$Version");
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                MethodHandle mRuntimeVersion = lookup.findStatic(cRuntime, "version", MethodType.methodType(cRuntimeVersion));
                MethodHandle mVersionParse = lookup.findStatic(cRuntimeVersion, "parse", MethodType.methodType(cRuntimeVersion, String.class));
                MethodHandle mVersionCompareTo = lookup.findVirtual(cRuntimeVersion, "compareToIgnoreOptional", MethodType.methodType(Integer.TYPE, cRuntimeVersion));
                Object runtimeVersion = mRuntimeVersion.invoke();
                Object ver17_0_6 = mVersionParse.invoke("17.0.6");
                int cmpResult = mVersionCompareTo.invoke(runtimeVersion, ver17_0_6);
                if (cmpResult < 0) {
                    if (GraphicsEnvironment.isHeadless()) {
                        System.err.println("=================================================================");
                        System.err.println("Upgrade your Java 17 install to Java 17.0.6 for lwjgl3ify to work");
                        System.err.println("Your Java version is: " + runtimeVersion);
                        System.err.println("=================================================================");
                    } else {
                        JOptionPane.showMessageDialog(null, "Upgrade your Java 17 install to Java 17.0.6 for lwjgl3ify to work\nYour java version is: " + runtimeVersion, "Java version requirement not met", 0);
                    }
                    System.exit(1);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

