/*
 * Decompiled with CFR 0.152.
 */
package net.sapfii.modutilities.features.reportoverlay;

import java.time.Duration;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.sapfii.modutilities.config.ModUtilsConfig;
import net.sapfii.modutilities.config.enums.ReportType;

public class ReportData {
    public final String reporter;
    public final String offender;
    public final String reason;
    public final String location;
    private final long creationTime;

    public static ReportData create(String reporter, String offender, String reason, String location) {
        return new ReportData(reporter, offender, reason, location);
    }

    private ReportData(String reporter, String offender, String reason, String location) {
        this.reporter = reporter;
        this.offender = offender;
        this.reason = reason;
        this.location = location;
        this.creationTime = System.currentTimeMillis();
    }

    public int time() {
        return Math.round((float)(System.currentTimeMillis() - this.creationTime) / 1000.0f);
    }

    public String formattedTime() {
        Duration d = Duration.ofSeconds(this.time());
        return String.format("%02d:%02d", d.toMinutes(), d.toSeconds() % 60L);
    }

    public class_2561 title() {
        ModUtilsConfig config = ModUtilsConfig.config;
        if (config.reportType.is(ReportType.CLASSIC)) {
            return class_2561.method_43470((String)"! ").method_27694(style -> style.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"Incoming Report ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)("(" + this.reporter + ") ")).method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)("(" + this.formattedTime() + " ago)\n")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false))));
        }
        if (config.reportType.is(ReportType.REIMAGINED)) {
            return class_2561.method_43470((String)"! ").method_27694(style -> style.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"Incoming Report ").method_27694(style -> style.method_36139(0xFFAAAA).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"! ").method_27694(style -> style.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"(").method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)this.reporter).method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)") ").method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)("(" + this.formattedTime() + " ago)\n")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false))));
        }
        if (config.reportType.is(ReportType.REVAMPED)) {
            return class_2561.method_43470((String)"[ ").method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)"Report ").method_27694(style -> style.method_36139(0xFFAAAA).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"filed by ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)this.reporter).method_27694(style -> style.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)" ] ").method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)("(" + this.formattedTime() + " ago)\n")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false))));
        }
        return class_2561.method_43470((String)"SOMETHING WENT HORRIBLY WRONG");
    }
}

