/*
 * Decompiled with CFR 0.152.
 */
package net.sapfii.modutilities.features.reportoverlay;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_7439;
import net.sapfii.modutilities.ModUtilities;
import net.sapfii.modutilities.config.ModUtilsConfig;
import net.sapfii.modutilities.features.Feature;
import net.sapfii.modutilities.features.interfaces.KeyBindListeningFeature;
import net.sapfii.modutilities.features.interfaces.PacketListeningFeature;
import net.sapfii.modutilities.features.interfaces.RenderedFeature;
import net.sapfii.modutilities.features.reportoverlay.ReportData;
import net.sapfii.modutilities.features.reportoverlay.ReportWidget;
import net.sapfii.modutilities.keybinds.ModUtilsKeyBinds;
import net.sapfii.modutilities.sounds.ModUtilsSounds;
import net.velli.scelli.widget.widgets.Widget;

public class ReportOverlayFeature
extends Feature
implements RenderedFeature,
PacketListeningFeature,
KeyBindListeningFeature {
    private static final Pattern REPORT_REGEX = Pattern.compile("! Incoming Report \\((.+)\\)\\n\\| {2}Offender: (.+)\\n\\| {2}Offense: (.+)\\n\\| {2}Location: (.+) Mode (.+)");
    public static ReportOverlayFeature instance;
    private final List<Widget<?>> widgets = new CopyOnWriteArrayList();
    public List<ReportData> reports = new CopyOnWriteArrayList<ReportData>();

    public ReportOverlayFeature() {
        instance = this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PacketListeningFeature.PacketResult onPacket(class_2596<?> packet) {
        boolean bl;
        class_2561 msgText;
        if (!ModUtilsConfig.config.useReportDisplay.get().booleanValue()) {
            return PacketListeningFeature.PacketResult.PASS;
        }
        if (!(packet instanceof class_7439)) return PacketListeningFeature.PacketResult.PASS;
        class_7439 class_74392 = (class_7439)packet;
        try {
            class_2561 class_25612;
            msgText = class_25612 = class_74392.comp_763();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        boolean overlay = bl = class_74392.comp_906();
        String string = msgText.getString();
        Matcher matcher = REPORT_REGEX.matcher(string);
        if (!matcher.find()) return PacketListeningFeature.PacketResult.PASS;
        ReportData newReport = ReportData.create(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
        ReportWidget widget = ReportWidget.create(newReport);
        widget.withOpacity(1, true);
        widget.withOpacity(255, false);
        this.widgets.addFirst(widget);
        this.reports.add(newReport);
        return PacketListeningFeature.PacketResult.CANCEL;
    }

    @Override
    public void render(class_332 context, float mouseX, float mouseY) {
        if (this.getWidgets().isEmpty()) {
            return;
        }
        if (this.getWidgets().getFirst().renderedOpacity() == 0) {
            this.getWidgets().removeFirst();
        }
        int x = 0;
        for (Widget<?> widget : this.getWidgets()) {
            if (!(widget instanceof ReportWidget)) continue;
            ReportWidget rw = (ReportWidget)widget;
            rw.withPosition(x, 20, false);
            rw.updateText();
            rw.withDimensions(ModUtilities.MC.field_1772.method_27525((class_5348)rw.data.title()), rw.textDisplay.height() + 6, true);
            if (rw != this.getWidgets().getFirst()) {
                rw.withOpacity(1, false);
            } else if (rw.opacity() != 0) {
                rw.withOpacity(255, false);
            }
            if (this.getWidgets().getFirst().opacity() == 0 && this.getWidgets().size() > 1 && this.getWidgets().get(1) == rw) {
                rw.withOpacity(255, false);
            }
            if (rw.opacity() == 0) continue;
            x += rw.renderedWidth() + 4;
        }
        if (ModUtilsConfig.config.useReportDisplay.get().booleanValue()) {
            this.renderWidgets(context, mouseX, mouseY, this.renderedOpacity());
        }
    }

    public List<Widget<?>> getWidgets() {
        return this.widgets;
    }

    public RenderedFeature getThis() {
        return this;
    }

    @Override
    public void onKeyBindPress(class_304 keyBind) {
        if (keyBind.method_1435(ModUtilsKeyBinds.DISMISS_REPORT) && !this.getWidgets().isEmpty() && this.getWidgets().getFirst().renderedOpacity() >= 175) {
            this.getWidgets().getFirst().withOpacity(0, false);
            ModUtilities.playSound(ModUtilsSounds.REPORT_DISMISS, 1.0f);
        }
    }
}

