/*
 * Decompiled with CFR 0.152.
 */
package net.sapfii.modutilities.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModUtilsConfig {
    public boolean useVanishDisplay = true;
    public boolean useReportDisplay = true;
    public boolean useHistoryScreen = true;
    public boolean useLogScreen = true;
    public LOG_DIRECTION logDirection = LOG_DIRECTION.UP;
    public REPORT_TYPE reportType = REPORT_TYPE.REVAMPED;
    public boolean hideJoinMessages = true;
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("modutils.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static ModUtilsConfig config = new ModUtilsConfig();

    public static void loadConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                config = (ModUtilsConfig)GSON.fromJson((Reader)reader, ModUtilsConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ModUtilsConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum LOG_DIRECTION {
        UP,
        DOWN;

    }

    public static enum REPORT_TYPE {
        CLASSIC,
        REVAMPED,
        REIMAGINED;

    }
}

