/*
 * Decompiled with CFR 0.152.
 */
package net.sapfii.modutilities.features.report;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.sapfii.modutilities.ModUtilities;
import net.sapfii.modutilities.config.ModUtilsConfig;
import net.sapfii.sapscreens.SapScreens;

public class ReportData {
    public String reporter;
    public String offender;
    public String offense;
    public String node;
    public String mode;
    public class_2561 title;
    public class_2561 text;
    public boolean beingRemoved = false;
    private int mins = 0;
    private int secs = 0;
    private float secsFloat = 0.0f;
    private float x;
    public float textOpacity = 255.0f;
    private float bgOpacity = 136.0f;
    private double lastRender;
    private final int linePadding;

    public ReportData(String reporter, String offender, String offense, String node, String mode) {
        Objects.requireNonNull(ModUtilities.MC.field_1772);
        this.linePadding = 9 + 1;
        this.lastRender = System.currentTimeMillis();
        this.reporter = reporter;
        this.offender = offender;
        this.offense = offense;
        this.node = node;
        this.mode = mode;
        this.updateText();
        List texts = SapScreens.splitTextNewline((class_2561)this.text);
        int width = ModUtilities.MC.field_1772.method_27525((class_5348)this.title);
        for (class_2561 txt : texts) {
            width = Math.max(width, ModUtilities.MC.field_1772.method_27525((class_5348)txt));
        }
        this.x = -width + 15;
    }

    private void updateText() {
        if (ModUtilsConfig.config.reportType == ModUtilsConfig.REPORT_TYPE.CLASSIC) {
            this.title = class_2561.method_43470((String)"! ").method_27694(style -> style.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"Incoming Report ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)("(" + this.reporter + ") ")).method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)("(" + this.mins + "m" + this.secs + "s ago)")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false))));
        } else if (ModUtilsConfig.config.reportType == ModUtilsConfig.REPORT_TYPE.REIMAGINED) {
            this.title = class_2561.method_43470((String)"! ").method_27694(style -> style.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)"Incoming Report ").method_27694(style -> style.method_36139(0xFFAAAA).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"! ").method_27694(style -> style.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"(").method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)this.reporter).method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)") ").method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)("(" + this.mins + "m" + this.secs + "s ago)")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false))));
        } else if (ModUtilsConfig.config.reportType == ModUtilsConfig.REPORT_TYPE.REVAMPED) {
            this.title = class_2561.method_43470((String)"[ ").method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)"Report ").method_27694(style -> style.method_36139(0xFFAAAA).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"filed by ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)this.reporter).method_27694(style -> style.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)" ] ").method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)("(" + this.mins + "m" + this.secs + "s ago)")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false))));
        }
        List offenseLines = ModUtilities.MC.field_1772.method_1728(class_5348.method_29430((String)this.offense), 200);
        class_5250 mutableText = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Offender: ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)(this.offender + "\n")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"Offense: ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false))));
        for (class_5481 line : offenseLines) {
            StringBuilder sb = new StringBuilder();
            line.accept((index, style, codePoint) -> {
                sb.appendCodePoint(codePoint);
                return true;
            });
            mutableText.method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(sb) + "\n")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false))));
        }
        mutableText.method_10852((class_2561)class_2561.method_43470((String)"Location: ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)(this.node + " Mode " + this.mode)).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false))));
        this.text = mutableText;
        if (!ModUtilsConfig.config.useReportDisplay) {
            ModUtilities.sendMessage((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"! ").method_27694(style -> style.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)"Incoming Report ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)("(" + this.reporter + ")\n")).method_27694(style -> style.method_10977(class_124.field_1063).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"Offender: ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)(this.offender + "\n")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"Offense: ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)(this.offense + "\n")).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)"Location: ").method_27694(style -> style.method_10977(class_124.field_1080).method_10982(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)(this.node + " Mode " + this.mode)).method_27694(style -> style.method_10977(class_124.field_1068).method_10982(Boolean.valueOf(false)))), false);
        }
    }

    public void updateTime() {
        float delta = (float)((double)System.currentTimeMillis() - this.lastRender) / 1000.0f;
        this.secsFloat += delta;
        int totalSecs = (int)this.secsFloat;
        this.mins = totalSecs / 60;
        this.secs = totalSecs % 60;
        this.updateText();
        this.lastRender = System.currentTimeMillis();
    }

    public int render(class_332 drawContext, int xOffset) {
        float delta = (float)((double)System.currentTimeMillis() - this.lastRender) / 1000.0f;
        float targetOpacity = 255.0f;
        float targetBgOpacity = 136.0f;
        if (xOffset > 1 || this.beingRemoved) {
            targetOpacity = 4.0f;
            targetBgOpacity = 0.0f;
        }
        this.textOpacity = ModUtilities.lerp(this.textOpacity, targetOpacity, 8.0f * delta);
        this.bgOpacity = ModUtilities.lerp(this.bgOpacity, targetBgOpacity, 8.0f * delta);
        this.updateTime();
        List texts = SapScreens.splitTextNewline((class_2561)this.text);
        int height = 35 + this.linePadding + texts.size() * this.linePadding;
        int width = ModUtilities.MC.field_1772.method_27525((class_5348)this.title);
        for (class_2561 txt : texts) {
            width = Math.max(width, ModUtilities.MC.field_1772.method_27525((class_5348)txt));
        }
        this.x = ModUtilities.lerp(this.x, xOffset, 8.0f * delta);
        int intX = (int)this.x;
        drawContext.method_25294(intX, 25, width += intX + 10, height, (int)this.bgOpacity << 24);
        drawContext.method_51439(ModUtilities.MC.field_1772, this.title, 5 + intX, 30, (int)this.textOpacity << 24 | 0xFFFFFF, true);
        for (class_2561 txt : texts) {
            drawContext.method_51439(ModUtilities.MC.field_1772, txt, 5 + intX, 30 + this.linePadding + texts.indexOf(txt) * this.linePadding, (int)this.textOpacity << 24 | 0xFFFFFF, true);
        }
        this.lastRender = System.currentTimeMillis();
        return width + 5;
    }
}

