/*
 * Decompiled with CFR 0.152.
 */
package net.sapfii.modutilities.features.report;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7439;
import net.minecraft.class_9779;
import net.sapfii.modutilities.ModUtilities;
import net.sapfii.modutilities.config.ModUtilsConfig;
import net.sapfii.modutilities.features.report.ReportData;
import net.sapfii.modutilities.features.report.screen.ReportsScreen;
import net.sapfii.modutilities.keybinds.KeyBindListener;
import net.sapfii.modutilities.keybinds.KeyBindRegistry;
import net.sapfii.modutilities.keybinds.ModUtilsKeyBinds;
import net.sapfii.modutilities.packet.recieve.ClientPacketListener;
import net.sapfii.modutilities.packet.recieve.PacketListenerRegistry;
import net.sapfii.modutilities.sounds.ModUtilsSounds;

public class ReportHandler
implements ClientPacketListener,
KeyBindListener {
    private static final class_2960 REPORT_DISPLAY_LAYER = class_2960.method_60655((String)"modutils", (String)"report-display-layer");
    private static final Pattern REPORT_REGEX = Pattern.compile("! Incoming Report \\((.+)\\)\\n\\| {2}Offender: (.+)\\n\\| {2}Offense: (.+)\\n\\| {2}Location: (.+) Mode (.+)");
    public static ReportHandler handler = new ReportHandler();
    public static CopyOnWriteArrayList<ReportData> reports = new CopyOnWriteArrayList();
    public static CopyOnWriteArrayList<ReportData> sessionReports = new CopyOnWriteArrayList();
    private static double lastDismiss = System.currentTimeMillis();

    public static void init() {
        HudRenderCallback.EVENT.register(REPORT_DISPLAY_LAYER, ReportHandler::render);
        PacketListenerRegistry.register(handler);
        KeyBindRegistry.registerListener(handler);
    }

    private static void render(class_332 drawContext, class_9779 renderTickCounter) {
        if (!ModUtilsConfig.config.useReportDisplay) {
            return;
        }
        int width = 0;
        for (ReportData report : reports.reversed()) {
            width = report.render(drawContext, width);
            if (!(report.textOpacity <= 100.0f) || !report.beingRemoved) continue;
            reports.remove(report);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T extends class_2547> ClientPacketListener.PacketEventResult onPacket(class_2596<T> packet) {
        boolean bl;
        class_2561 msgText;
        if (!(packet instanceof class_7439)) return ClientPacketListener.PacketEventResult.PASS;
        class_7439 class_74392 = (class_7439)packet;
        try {
            class_2561 class_25612;
            msgText = class_25612 = class_74392.comp_763();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        boolean overlay = bl = class_74392.comp_906();
        String string = msgText.getString();
        Matcher matcher = REPORT_REGEX.matcher(string);
        if (!matcher.find()) return ClientPacketListener.PacketEventResult.PASS;
        ReportData report = new ReportData(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5));
        reports.add(report);
        sessionReports.add(report);
        class_437 class_4372 = ModUtilities.MC.field_1755;
        if (!(class_4372 instanceof ReportsScreen)) return ClientPacketListener.PacketEventResult.CANCEL;
        ReportsScreen screen = (ReportsScreen)class_4372;
        screen.refresh();
        return ClientPacketListener.PacketEventResult.CANCEL;
    }

    @Override
    public void keyPressed(class_304 keyBinding) {
        if (keyBinding.method_1435(ModUtilsKeyBinds.DISMISS_REPORT)) {
            if ((double)System.currentTimeMillis() - lastDismiss < 500.0 || reports.isEmpty() || ReportHandler.reports.getLast().beingRemoved || !ModUtilsConfig.config.useReportDisplay) {
                return;
            }
            if (class_437.method_25441()) {
                reports.forEach(report -> {
                    report.beingRemoved = true;
                });
            } else {
                ReportHandler.reports.getLast().beingRemoved = true;
            }
            ModUtilities.playSound(ModUtilsSounds.REPORT_DISMISS, 1.0f);
            lastDismiss = System.currentTimeMillis();
        }
    }
}

