/*
 * Decompiled with CFR 0.152.
 */
package com.maDU59_.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.maDU59_.config.Option;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class SettingsManager {
    public static List<Option> ALL_OPTIONS = new ArrayList<Option>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("better-compass.json");
    public static List<Object> ENABLING_OPTION_VALUES = List.of(Boolean.valueOf(true), Boolean.valueOf(false));
    public static List<Object> COLOR_OPTION_VALUES = List.of("Red", "Green", "Blue", "Yellow", "Cyan", "Magenta", "Purple", "White", "Grey", "Black");
    public static List<Object> POSITION_VALUES = List.of("Aligned", "Above", "Under", "Disabled");
    public static Option SHOW_COMPASS_HUD = SettingsManager.loadOptionWithDefaults("SHOW_COMPASS_HUD", "better-compass.config.show_compass_hud", "better-compass.config.show_compass_hud_desc", "Always", "Always", List.of("Always", "Compass in inventory", "Compass in hand", "Never"));
    public static Option COMPASS_STYLE = SettingsManager.loadOptionWithDefaults("COMPASS_STYLE", "better-compass.config.compass_style", "better-compass.config.compass_style_desc", "No shadows", "No shadows", List.of("Shadows", "No shadows"));
    public static Option COMPASS_POSITION = SettingsManager.loadOptionWithDefaults("COMPASS_POSITION", "better-compass.config.compass_position", "better-compass.config.compass_position_desc", "Top", "Top", List.of("Top", "Bottom"));
    public static Option CARDINALS_DIRECTION_POSITION = SettingsManager.loadOptionWithDefaults("CARDINALS_DIRECTION_POSITION", "better-compass.config.cardinals_direction_position", "better-compass.config.cardinals_direction_position_desc", "Aligned", "Aligned", POSITION_VALUES);
    public static Option CARDINALS_DIRECTION_COLOR = SettingsManager.loadOptionWithDefaults("CARDINALS_DIRECTION_COLOR", "better-compass.config.cardinals_direction_color", "better-compass.config.cardinals_direction_color_desc", "Red", "Red", COLOR_OPTION_VALUES);
    public static Option LAST_DEATH_DIRECTION_POSITION = SettingsManager.loadOptionWithDefaults("LAST_DEATH_DIRECTION_POSITION", "better-compass.config.last_death_direction_position", "better-compass.config.last_death_direction_position_desc", "Under", "Under", POSITION_VALUES);
    public static Option LAST_DEATH_DIRECTION_COLOR = SettingsManager.loadOptionWithDefaults("LAST_DEATH_DIRECTION_COLOR", "better-compass.config.last_death_direction_color", "better-compass.config.last_death_direction_color_desc", "Grey", "Grey", COLOR_OPTION_VALUES);
    public static Option NETHER_PORTAL_DIRECTION_POSITION = SettingsManager.loadOptionWithDefaults("NETHER_PORTAL_DIRECTION_POSITION", "better-compass.config.nether_portal_direction_position", "better-compass.config.nether_portal_direction_position_desc", "Under", "Under", POSITION_VALUES);
    public static Option NETHER_PORTAL_DIRECTION_COLOR = SettingsManager.loadOptionWithDefaults("NETHER_PORTAL_DIRECTION_COLOR", "better-compass.config.nether_portal_direction_color", "better-compass.config.nether_portal_direction_color_desc", "Purple", "Purple", COLOR_OPTION_VALUES);

    public static List<String> getAllOptionsId() {
        ArrayList<String> list = new ArrayList<String>();
        for (Option option : ALL_OPTIONS) {
            list.add(option.getId());
        }
        return list;
    }

    public static boolean setOptionValue(String optionId, Object value) {
        for (Option option : ALL_OPTIONS) {
            System.out.println(optionId + ": " + option.getId() + ", " + option.getId().equalsIgnoreCase(optionId));
            System.out.println(String.valueOf(value) + ": " + String.valueOf(option.getPossibleValues()) + ", " + option.getPossibleValues().contains(value));
            if (!option.getId().equalsIgnoreCase(optionId)) continue;
            int index = option.getPossibleValues().stream().map(Object::toString).collect(Collectors.toList()).indexOf((String)value);
            if (option.getPossibleValues().contains(value)) {
                option.setValue(value);
                return true;
            }
            if (index == -1) continue;
            option.setValue(option.getPossibleValues().get(index));
            return true;
        }
        return false;
    }

    public static List<String> getOptionPossibleValues(String optionId) {
        for (Option option : ALL_OPTIONS) {
            if (!option.getId().equalsIgnoreCase(optionId)) continue;
            return option.getPossibleValues().stream().map(Object::toString).collect(Collectors.toList());
        }
        return null;
    }

    public static int getRGBColorFromSetting(String colorName) {
        int[] colors = SettingsManager.getColorFromSetting(colorName);
        return colors[2] + colors[1] * 256 + colors[0] * 256 * 256 + -16777216;
    }

    public static float[] convertColorToFloat(int[] colors) {
        float red = (float)colors[0] / 255.0f;
        float green = (float)colors[1] / 255.0f;
        float blue = (float)colors[2] / 255.0f;
        return new float[]{red, green, blue};
    }

    public static float convertAlphaToFloat(int alpha) {
        float alphaFloat = (float)alpha / 255.0f;
        return alphaFloat;
    }

    public static int[] getColorFromSetting(String colorName) {
        int red = 0;
        int green = 0;
        int blue = 0;
        switch (colorName) {
            case "Red": {
                red = 255;
                break;
            }
            case "Green": {
                green = 255;
                break;
            }
            case "Blue": {
                blue = 255;
                break;
            }
            case "Yellow": {
                red = 255;
                green = 255;
                break;
            }
            case "Cyan": {
                green = 255;
                blue = 255;
                break;
            }
            case "Magenta": {
                red = 255;
                blue = 255;
                break;
            }
            case "Purple": {
                red = 128;
                green = 0;
                blue = 128;
                break;
            }
            case "White": {
                red = 255;
                green = 255;
                blue = 255;
                break;
            }
            case "Grey": {
                red = 128;
                green = 128;
                blue = 128;
                break;
            }
            case "Black": {
                red = 0;
                green = 0;
                blue = 0;
                break;
            }
            default: {
                red = 255;
            }
        }
        return new int[]{red, green, blue};
    }

    public static void saveSettings(List<Option> options) {
        Map<String, Option> map = SettingsManager.toMap(options);
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson(map, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Option> toMap(List<Option> options) {
        LinkedHashMap<String, Option> map = new LinkedHashMap<String, Option>();
        for (Option option : options) {
            map.put(option.getId(), option);
        }
        return map;
    }

    private static Option loadOption(String key) {
        Option option;
        block8: {
            BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
            try {
                Type type = new TypeToken<Map<String, Option>>(){}.getType();
                Map map = (Map)GSON.fromJson((Reader)reader, type);
                option = (Option)map.get(key);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return option;
    }

    private static Option loadOptionWithDefaults(String id, String name, String description, Object value, Object defaultValue, List<Object> possibleValues) {
        Option loadedOption = SettingsManager.loadOption(id);
        System.out.println("Loaded option for " + id + ": " + (loadedOption == null ? "null" : loadedOption.getValueAsString()));
        if (loadedOption == null) {
            return new Option(id, name, description, value, defaultValue, possibleValues);
        }
        loadedOption.setPossibleValues(possibleValues);
        loadedOption.setName(name);
        loadedOption.setDescription(description);
        ALL_OPTIONS.add(loadedOption);
        return loadedOption;
    }
}

