/*
 * Decompiled with CFR 0.152.
 */
package com.maDU59_;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.maDU59_.config.ClientCommands;
import com.maDU59_.config.SettingsManager;
import com.maDU59_.mixin.client.FovMultiplierAccessor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_642;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_9779;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class BetterCompassClient
implements ClientModInitializer {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final float GUI_WIDTH = 0.5f;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Map<String, Object> valueMap = new LinkedHashMap<String, Object>();
    private static class_5321<class_1937> lastDimension = null;
    public static class_2338 deathPointBlockPos = null;
    public static class_5321<class_1937> deathDimension = null;
    public static class_2338 netherPortalBlockPos = null;
    public static String serverId;

    public void onInitializeClient() {
        ClientCommands.register();
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.CHAT, (class_2960)class_2960.method_60655((String)"better-compass", (String)"before_chat"), BetterCompassClient::render);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null && client.field_1724.method_29504()) {
                deathPointBlockPos = client.field_1724.method_24515();
                deathDimension = client.field_1687.method_27983();
                valueMap.put("deathPointBlockPos", deathPointBlockPos);
                valueMap.put("deathDimension", deathDimension);
                BetterCompassClient.saveValues();
            }
            if (client.field_1687 != null) {
                class_5321 current = client.field_1687.method_27983();
                if (lastDimension != null && !lastDimension.equals((Object)current)) {
                    if (current == class_1937.field_25180) {
                        netherPortalBlockPos = client.field_1724.method_24515();
                        valueMap.put("netherPortalBlockPos", netherPortalBlockPos);
                        BetterCompassClient.saveValues();
                    } else {
                        netherPortalBlockPos = null;
                    }
                }
                lastDimension = current;
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            class_642 info;
            serverId = CLIENT.method_1576() == null ? ((info = CLIENT.method_1558()) != null ? info.field_3761.replace(":", "_") : "unknown_server") : CLIENT.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString();
            BetterCompassClient.loadData();
        });
    }

    private static void render(class_332 context, class_9779 tickCounter) {
        double dz;
        double dx;
        float compassPosition = 0.05f;
        if (SettingsManager.COMPASS_POSITION.getValueAsString().equals("Bottom")) {
            compassPosition = 0.82f;
        }
        float deltaY = 0.0f;
        float size = 1.5f;
        int color = -1;
        class_746 player = BetterCompassClient.CLIENT.field_1724;
        int optionValueIndex = SettingsManager.SHOW_COMPASS_HUD.getValueAsIndex();
        if (optionValueIndex == 3 || optionValueIndex == 2 && !player.method_6047().method_7909().method_7876().equals("item.minecraft.compass") || optionValueIndex == 1 && !player.method_31548().method_18862(Set.of(class_1802.field_8251))) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        class_4184 camera = BetterCompassClient.CLIENT.field_1773.method_19418();
        if (camera == null) {
            return;
        }
        float fov = ((FovMultiplierAccessor)BetterCompassClient.CLIENT.field_1773).getFovMultiplier() * (float)((Integer)BetterCompassClient.CLIENT.field_1690.method_41808().method_41753()).intValue();
        float camDirection = camera.method_19330();
        if (!SettingsManager.CARDINALS_DIRECTION_POSITION.getValue().equals("Disabled")) {
            color = SettingsManager.getRGBColorFromSetting(SettingsManager.CARDINALS_DIRECTION_COLOR.getValueAsString());
            if (SettingsManager.CARDINALS_DIRECTION_POSITION.getValue().equals("Under")) {
                deltaY = 0.03f;
                size = 0.8f;
            }
            if (SettingsManager.CARDINALS_DIRECTION_POSITION.getValue().equals("Above")) {
                deltaY = -0.03f;
                size = 0.8f;
            }
            BetterCompassClient.drawCompassSymbol(context, textRenderer, fov, "N", 180.0f, camDirection, compassPosition + deltaY, color, size);
            BetterCompassClient.drawCompassSymbol(context, textRenderer, fov, "E", 270.0f, camDirection, compassPosition + deltaY, color, size);
            BetterCompassClient.drawCompassSymbol(context, textRenderer, fov, "S", 0.0f, camDirection, compassPosition + deltaY, color, size);
            BetterCompassClient.drawCompassSymbol(context, textRenderer, fov, "W", 90.0f, camDirection, compassPosition + deltaY, color, size);
        }
        for (int i = 0; i < 36; ++i) {
            if (i % 9 == 0 && SettingsManager.CARDINALS_DIRECTION_POSITION.getValue().equals("Aligned")) continue;
            BetterCompassClient.drawCompassSymbol(context, textRenderer, fov, "|", i * 10, camDirection, compassPosition, -1, 1.0f);
        }
        if (deathPointBlockPos != null && BetterCompassClient.CLIENT.field_1687.method_27983() == deathDimension && !SettingsManager.LAST_DEATH_DIRECTION_POSITION.getValue().equals("Disabled")) {
            deltaY = 0.0f;
            size = 1.5f;
            color = SettingsManager.getRGBColorFromSetting(SettingsManager.LAST_DEATH_DIRECTION_COLOR.getValueAsString());
            if (SettingsManager.LAST_DEATH_DIRECTION_POSITION.getValue().equals("Under")) {
                deltaY = 0.03f;
                size = 0.8f;
            }
            if (SettingsManager.LAST_DEATH_DIRECTION_POSITION.getValue().equals("Above")) {
                deltaY = -0.03f;
                size = 0.8f;
            }
            class_243 deathPos = new class_243((double)deathPointBlockPos.method_10263(), 0.0, (double)deathPointBlockPos.method_10260());
            dx = deathPos.field_1352 - player.method_23317();
            dz = deathPos.field_1350 - player.method_23321();
            BetterCompassClient.drawCompassSymbol(context, textRenderer, fov, "\ud83d\udc80", (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f, camDirection, compassPosition + deltaY, color, size);
        }
        if (netherPortalBlockPos != null && BetterCompassClient.CLIENT.field_1687.method_27983() == class_1937.field_25180 && !SettingsManager.NETHER_PORTAL_DIRECTION_POSITION.getValue().equals("Disabled")) {
            deltaY = 0.0f;
            size = 1.5f;
            color = SettingsManager.getRGBColorFromSetting(SettingsManager.NETHER_PORTAL_DIRECTION_COLOR.getValueAsString());
            if (SettingsManager.NETHER_PORTAL_DIRECTION_POSITION.getValue().equals("Under")) {
                deltaY = 0.03f;
                size = 0.8f;
            }
            if (SettingsManager.NETHER_PORTAL_DIRECTION_POSITION.getValue().equals("Above")) {
                deltaY = -0.03f;
                size = 0.8f;
            }
            class_243 netherPortalPos = new class_243((double)netherPortalBlockPos.method_10263(), 0.0, (double)netherPortalBlockPos.method_10260());
            dx = netherPortalPos.field_1352 - player.method_23317();
            dz = netherPortalPos.field_1350 - player.method_23321();
            BetterCompassClient.drawCompassSymbol(context, textRenderer, fov, "\ud83c\udf0d", (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f, camDirection, compassPosition + deltaY, color, size);
        }
    }

    public static void drawCompassSymbol(class_332 context, class_327 textRenderer, float fov, String symbol, float targetDirection, float camDirection, float y, int color, float scale) {
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int x = -((int)((double)screenWidth * 0.5 * 0.5 * (double)class_3532.method_15393((float)(camDirection - targetDirection)) / (double)fov));
        if ((double)Math.abs(class_3532.method_15393((float)(camDirection - targetDirection)) / fov) > 1.0) {
            return;
        }
        color %= 0x1000000;
        int alpha = (int)(255.0 * (1.0 - Math.abs(Math.sin(Math.toRadians(camDirection - targetDirection)))));
        color += 0x1000000 * alpha;
        Matrix3x2fStack matrices = context.method_51448();
        Matrix3x2f before = new Matrix3x2f((Matrix3x2fc)matrices);
        matrices.scale(scale, scale);
        if (SettingsManager.COMPASS_STYLE.getValueAsString().equals("Shadows")) {
            class_5250 class_52502 = class_2561.method_43470((String)symbol);
            int n = (int)((float)(screenWidth / 2 + x) / scale);
            float f = (float)screenHeight * y / scale;
            Objects.requireNonNull(textRenderer);
            context.method_27534(textRenderer, (class_2561)class_52502, n, (int)(f - 9.0f / 2.0f), color);
        } else {
            int n = (int)((float)(screenWidth / 2 + x) / scale - (float)textRenderer.method_1727(symbol) / 2.0f);
            float f = (float)screenHeight * y / scale;
            Objects.requireNonNull(textRenderer);
            context.method_51433(textRenderer, symbol, n, (int)(f - 9.0f / 2.0f), color, false);
        }
        matrices.set((Matrix3x2fc)before);
    }

    public static void saveValues() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve(serverId).resolve("better-compass.json");
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                GSON.toJson(valueMap, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadData() {
        Map rawMap;
        Object valueRaw;
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve(serverId).resolve("better-compass.json");
        try (BufferedReader reader = Files.newBufferedReader(configPath);){
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            valueMap = (Map)GSON.fromJson((Reader)reader, type);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Object raw = valueMap.get("deathDimension");
        if (raw instanceof Map && (valueRaw = (rawMap = (Map)raw).get("value")) instanceof Map) {
            Map innerRawMap = (Map)valueRaw;
            String namespace = (String)innerRawMap.get("namespace");
            String path = (String)innerRawMap.get("path");
            deathDimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)namespace, (String)path));
        }
        if ((raw = valueMap.get("deathPointBlockPos")) instanceof Map) {
            rawMap = (Map)raw;
            int x = ((Double)rawMap.get("x")).intValue();
            int y = ((Double)rawMap.get("y")).intValue();
            int z = ((Double)rawMap.get("z")).intValue();
            deathPointBlockPos = new class_2338(x, y, z);
        }
        if ((raw = valueMap.get("netherPortalBlockPos")) instanceof Map) {
            rawMap = (Map)raw;
            int x = ((Double)rawMap.get("x")).intValue();
            int y = ((Double)rawMap.get("y")).intValue();
            int z = ((Double)rawMap.get("z")).intValue();
            netherPortalBlockPos = new class_2338(x, y, z);
        }
    }
}

